/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.Properties;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphics2d.SymbolShape;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.util.UserProperties;

public abstract class AbstractVectorGraphics
extends VectorGraphics {
    private UserProperties properties;
    private String creator;
    private boolean isDeviceIndependent;
    private SymbolShape cachedShape;
    private int colorMode;
    private Color backgroundColor;
    private Color currentColor;
    private Paint currentPaint;
    private Font currentFont;

    public AbstractVectorGraphics() {
        this.properties = new UserProperties();
        this.creator = "FreeHEP Graphics2D Driver";
        this.isDeviceIndependent = false;
        this.cachedShape = new SymbolShape();
        this.colorMode = 0;
        this.currentFont = null;
        this.backgroundColor = null;
        this.currentColor = null;
        this.currentPaint = null;
    }

    protected AbstractVectorGraphics(AbstractVectorGraphics graphics) {
        this.properties = graphics.properties;
        this.creator = graphics.creator;
        this.isDeviceIndependent = graphics.isDeviceIndependent;
        this.cachedShape = graphics.cachedShape;
        this.backgroundColor = graphics.backgroundColor;
        this.currentColor = graphics.currentColor;
        this.currentPaint = graphics.currentPaint;
        this.colorMode = graphics.colorMode;
        this.currentFont = graphics.currentFont;
    }

    public void setProperties(Properties newProperties) {
        if (newProperties == null) {
            return;
        }
        this.properties.setProperties(newProperties);
    }

    protected void initProperties(Properties defaults) {
        this.properties = new UserProperties();
        this.properties.setProperties(defaults);
    }

    protected Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Color getPropertyColor(String key) {
        return this.properties.getPropertyColor(key);
    }

    public Rectangle getPropertyRectangle(String key) {
        return this.properties.getPropertyRectangle(key);
    }

    public Insets getPropertyInsets(String key) {
        return this.properties.getPropertyInsets(key);
    }

    public Dimension getPropertyDimension(String key) {
        return this.properties.getPropertyDimension(key);
    }

    public int getPropertyInt(String key) {
        return this.properties.getPropertyInt(key);
    }

    public double getPropertyDouble(String key) {
        return this.properties.getPropertyDouble(key);
    }

    public boolean isProperty(String key) {
        return this.properties.isProperty(key);
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        if (creator != null) {
            this.creator = creator;
        }
    }

    public boolean isDeviceIndependent() {
        return this.isDeviceIndependent;
    }

    public void setDeviceIndependent(boolean isDeviceIndependent) {
        this.isDeviceIndependent = isDeviceIndependent;
    }

    public Font getFont() {
        return this.currentFont;
    }

    public void setFont(Font font) {
        this.currentFont = font;
    }

    public void drawSymbol(int x, int y, int size, int symbol) {
        this.drawSymbol((double)x, (double)y, (double)size, symbol);
    }

    public void fillSymbol(int x, int y, int size, int symbol) {
        this.fillSymbol((double)x, (double)y, (double)size, symbol);
    }

    public void drawSymbol(double x, double y, double size, int symbol) {
        if (size <= 0.0) {
            return;
        }
        this.drawSymbol(this, x, y, size, symbol);
    }

    protected void drawSymbol(VectorGraphics g, double x, double y, double size, int symbol) {
        switch (symbol) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.cachedShape.create(symbol, x, y, size);
                g.draw(this.cachedShape);
                break;
            }
            case 5: {
                double diameter = Math.max(1.0, size);
                diameter += diameter % 2.0;
                g.drawOval(x - diameter / 2.0, y - diameter / 2.0, diameter, diameter);
                break;
            }
        }
    }

    public void fillSymbol(double x, double y, double size, int symbol) {
        if (size <= 0.0) {
            return;
        }
        this.fillSymbol(this, x, y, size, symbol);
    }

    protected void fillSymbol(VectorGraphics g, double x, double y, double size, int symbol) {
        switch (symbol) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.cachedShape.create(symbol, x, y, size);
                g.draw(this.cachedShape);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.cachedShape.create(symbol, x, y, size);
                g.fill(this.cachedShape);
                break;
            }
            case 5: {
                double diameter = Math.max(1.0, size);
                diameter += diameter % 2.0;
                g.fillOval(x - diameter / 2.0, y - diameter / 2.0, diameter, diameter);
                break;
            }
        }
    }

    public void clearRect(int x, int y, int width, int height) {
        this.clearRect((double)x, (double)y, (double)width, (double)height);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.drawLine((double)x1, (double)y1, (double)x2, (double)y2);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.drawRect((double)x, (double)y, (double)width, (double)height);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.fillRect((double)x, (double)y, (double)width, (double)height);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.drawArc((double)x, (double)y, (double)width, (double)height, (double)startAngle, (double)arcAngle);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fillArc((double)x, (double)y, (double)width, (double)height, (double)startAngle, (double)arcAngle);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.drawOval((double)x, (double)y, (double)width, (double)height);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.fillOval((double)x, (double)y, (double)width, (double)height);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.drawRoundRect((double)x, (double)y, (double)width, (double)height, (double)arcWidth, (double)arcHeight);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fillRoundRect((double)x, (double)y, (double)width, (double)height, (double)arcWidth, (double)arcHeight);
    }

    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    public void setLineWidth(int width) {
        this.setLineWidth((double)width);
    }

    public void setLineWidth(double width) {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke cs = (BasicStroke)stroke;
            if ((double)cs.getLineWidth() != width) {
                stroke = new BasicStroke((float)width, cs.getEndCap(), cs.getLineJoin(), cs.getMiterLimit(), cs.getDashArray(), cs.getDashPhase());
                this.setStroke(stroke);
            }
        } else {
            stroke = new BasicStroke((float)width);
            this.setStroke(stroke);
        }
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, (double)x, (double)y);
    }

    public void drawString(String s, float x, float y) {
        this.drawString(s, (double)x, (double)y);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    public void drawString(String str, double x, double y, int horizontal, int vertical) {
        this.drawString(str, x, y, horizontal, vertical, false, null, 0.0, false, null);
    }

    public void drawString(TagString str, double x, double y) {
        this.drawString(str, x, y, 1, 0);
    }

    public void drawString(TagString str, double x, double y, int horizontal, int vertical) {
        this.drawString(str, x, y, horizontal, vertical, false, null, 0.0, false, null);
    }

    public int getColorMode() {
        return this.colorMode;
    }

    public void setColorMode(int colorMode) {
        this.colorMode = colorMode;
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    public void setColor(Color color) {
        this.currentColor = color;
        this.currentPaint = color;
    }

    public Color getColor() {
        return this.currentColor;
    }

    public void setPaint(Paint paint) {
        if (!(paint instanceof Color)) {
            this.currentColor = null;
        }
        this.currentPaint = paint;
    }

    public Paint getPaint() {
        return this.currentPaint;
    }

    protected Color getPrintColor(Color color) {
        if (this.colorMode == 0) {
            return color;
        }
        PrintColor printColor = PrintColor.createPrintColor(color);
        return printColor.getColor(this.colorMode);
    }

    public void rotate(double theta, double x, double y) {
        this.translate(x, y);
        this.rotate(theta);
        this.translate(-x, -y);
    }

    public void drawArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        this.draw(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    public void drawOval(double x, double y, double width, double height) {
        this.draw(new Ellipse2D.Double(x, y, width, height));
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.draw(this.createShape(xPoints, yPoints, nPoints, false));
    }

    public void drawPolyline(double[] xPoints, double[] yPoints, int nPoints) {
        this.draw(this.createShape(xPoints, yPoints, nPoints, false));
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.draw(this.createShape(xPoints, yPoints, nPoints, true));
    }

    public void drawPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        this.draw(this.createShape(xPoints, yPoints, nPoints, true));
    }

    public void drawRect(double x, double y, double width, double height) {
        this.draw(new Rectangle2D.Double(x, y, width, height));
    }

    public void drawRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.draw(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    public void fillArc(double x, double y, double width, double height, double startAngle, double arcAngle) {
        this.fill(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2));
    }

    public void fillOval(double x, double y, double width, double height) {
        this.fill(new Ellipse2D.Double(x, y, width, height));
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.fill(new Polygon(xPoints, yPoints, nPoints));
    }

    public void fillPolygon(double[] xPoints, double[] yPoints, int nPoints) {
        this.fill(this.createShape(xPoints, yPoints, nPoints, true));
    }

    public void fillRect(double x, double y, double width, double height) {
        this.fill(new Rectangle2D.Double(x, y, width, height));
    }

    public void fillRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.fill(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    protected abstract GeneralPath createShape(double[] var1, double[] var2, int var3, boolean var4);

    protected GeneralPath createShape(int[] xPoints, int[] yPoints, int nPoints, boolean close) {
        GeneralPath path = new GeneralPath(0);
        if (nPoints > 0) {
            path.moveTo(xPoints[0], yPoints[0]);
            int lastX = xPoints[0];
            int lastY = yPoints[0];
            if (close && Math.abs(xPoints[nPoints - 1] - lastX) < 1 && Math.abs(yPoints[nPoints - 1] - lastY) < 1) {
                --nPoints;
            }
            for (int i = 1; i < nPoints; ++i) {
                if (Math.abs(xPoints[i] - lastX) <= 1 && Math.abs(yPoints[i] - lastY) <= 1) continue;
                path.lineTo(xPoints[i], yPoints[i]);
                lastX = xPoints[i];
                lastY = yPoints[i];
            }
            if (close) {
                path.closePath();
            }
        }
        return path;
    }
}

