/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.GeoPointInBBoxQueryImpl;
import org.apache.lucene.search.GeoPointTermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.GeoRect;
import org.apache.lucene.util.GeoUtils;

public final class GeoPointInPolygonQuery
extends GeoPointInBBoxQueryImpl {
    private final double[] x;
    private final double[] y;

    public GeoPointInPolygonQuery(String field, double[] polyLons, double[] polyLats) {
        this(field, GeoUtils.polyToBBox(polyLons, polyLats), polyLons, polyLats);
    }

    private GeoPointInPolygonQuery(String field, GeoRect bbox, double[] polyLons, double[] polyLats) {
        super(field, bbox.minLon, bbox.minLat, bbox.maxLon, bbox.maxLat);
        if (polyLats.length != polyLons.length) {
            throw new IllegalArgumentException("polyLats and polyLons must be equal length");
        }
        if (polyLats.length < 4) {
            throw new IllegalArgumentException("at least 4 polygon points required");
        }
        if (polyLats[0] != polyLats[polyLats.length - 1]) {
            throw new IllegalArgumentException("first and last points of the polygon must be the same (it must close itself): polyLats[0]=" + polyLats[0] + " polyLats[" + (polyLats.length - 1) + "]=" + polyLats[polyLats.length - 1]);
        }
        if (polyLons[0] != polyLons[polyLons.length - 1]) {
            throw new IllegalArgumentException("first and last points of the polygon must be the same (it must close itself): polyLons[0]=" + polyLons[0] + " polyLons[" + (polyLons.length - 1) + "]=" + polyLons[polyLons.length - 1]);
        }
        this.x = polyLons;
        this.y = polyLats;
    }

    @Override
    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        return new GeoPolygonTermsEnum(terms.iterator(), this.minLon, this.minLat, this.maxLon, this.maxLat);
    }

    @Override
    public void setRewriteMethod(MultiTermQuery.RewriteMethod method) {
        throw new UnsupportedOperationException("cannot change rewrite method");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointInPolygonQuery that = (GeoPointInPolygonQuery)((Object)o);
        if (!Arrays.equals(this.x, that.x)) {
            return false;
        }
        return Arrays.equals(this.y, that.y);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.x != null ? Arrays.hashCode(this.x) : 0);
        result = 31 * result + (this.y != null ? Arrays.hashCode(this.y) : 0);
        return result;
    }

    @Override
    public String toString(String field) {
        assert (this.x.length == this.y.length);
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.getField().equals(field)) {
            sb.append(" field=");
            sb.append(this.getField());
            sb.append(':');
        }
        sb.append(" Points: ");
        for (int i = 0; i < this.x.length; ++i) {
            sb.append("[").append(this.x[i]).append(", ").append(this.y[i]).append("] ");
        }
        return sb.toString();
    }

    public double[] getLons() {
        return this.x;
    }

    public double[] getLats() {
        return this.y;
    }

    private final class GeoPolygonTermsEnum
    extends GeoPointTermsEnum {
        GeoPolygonTermsEnum(TermsEnum tenum, double minLon, double minLat, double maxLon, double maxLat) {
            super(tenum, minLon, minLat, maxLon, maxLat);
        }

        @Override
        protected boolean cellCrosses(double minLon, double minLat, double maxLon, double maxLat) {
            return GeoUtils.rectCrossesPoly(minLon, minLat, maxLon, maxLat, GeoPointInPolygonQuery.this.x, GeoPointInPolygonQuery.this.y, GeoPointInPolygonQuery.this.minLon, GeoPointInPolygonQuery.this.minLat, GeoPointInPolygonQuery.this.maxLon, GeoPointInPolygonQuery.this.maxLat);
        }

        @Override
        protected boolean cellWithin(double minLon, double minLat, double maxLon, double maxLat) {
            return GeoUtils.rectWithinPoly(minLon, minLat, maxLon, maxLat, GeoPointInPolygonQuery.this.x, GeoPointInPolygonQuery.this.y, GeoPointInPolygonQuery.this.minLon, GeoPointInPolygonQuery.this.minLat, GeoPointInPolygonQuery.this.maxLon, GeoPointInPolygonQuery.this.maxLat);
        }

        @Override
        protected boolean cellIntersectsShape(double minLon, double minLat, double maxLon, double maxLat) {
            return this.cellContains(minLon, minLat, maxLon, maxLat) || this.cellWithin(minLon, minLat, maxLon, maxLat) || this.cellCrosses(minLon, minLat, maxLon, maxLat);
        }

        @Override
        protected boolean postFilter(double lon, double lat) {
            return GeoUtils.pointInPolygon(GeoPointInPolygonQuery.this.x, GeoPointInPolygonQuery.this.y, lat, lon);
        }
    }
}

