/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast.node;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.NodeShouldNotConnectException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportBroadcastByNodeAction<Request extends BroadcastRequest, Response extends BroadcastResponse, ShardOperationResult extends Streamable>
extends HandledTransportAction<Request, Response> {
    private final ClusterService clusterService;
    private final TransportService transportService;
    final String transportNodeBroadcastAction;

    public TransportBroadcastByNodeAction(Settings settings, String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Class<Request> request, String executor) {
        super(settings, actionName, threadPool, transportService, actionFilters, indexNameExpressionResolver, request);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.transportNodeBroadcastAction = actionName + "[n]";
        transportService.registerRequestHandler(this.transportNodeBroadcastAction, new Callable<NodeRequest>(){

            @Override
            public NodeRequest call() throws Exception {
                return new NodeRequest();
            }
        }, executor, new BroadcastByNodeTransportRequestHandler());
    }

    private final Response newResponse(Request request, AtomicReferenceArray responses, List<NoShardAvailableActionException> unavailableShardExceptions, Map<String, List<ShardRouting>> nodes, ClusterState clusterState) {
        int totalShards = 0;
        int successfulShards = 0;
        ArrayList broadcastByNodeResponses = new ArrayList();
        ArrayList<ShardOperationFailedException> exceptions = new ArrayList<ShardOperationFailedException>();
        for (int i = 0; i < responses.length(); ++i) {
            if (responses.get(i) instanceof FailedNodeException) {
                FailedNodeException exception = (FailedNodeException)responses.get(i);
                totalShards += nodes.get(exception.nodeId()).size();
                for (ShardRouting shard : nodes.get(exception.nodeId())) {
                    exceptions.add(new DefaultShardOperationFailedException(shard.getIndex(), shard.getId(), exception));
                }
                continue;
            }
            NodeResponse response = (NodeResponse)responses.get(i);
            broadcastByNodeResponses.addAll(response.results);
            totalShards += response.getTotalShards();
            successfulShards += response.getSuccessfulShards();
            for (BroadcastShardOperationFailedException throwable : response.getExceptions()) {
                if (TransportActions.isShardNotAvailableException(throwable)) continue;
                exceptions.add(new DefaultShardOperationFailedException(throwable.getIndex(), throwable.getShardId().getId(), throwable));
            }
        }
        int failedShards = exceptions.size();
        return this.newResponse(request, totalShards += unavailableShardExceptions.size(), successfulShards, failedShards, broadcastByNodeResponses, exceptions, clusterState);
    }

    protected abstract ShardOperationResult readShardResult(StreamInput var1) throws IOException;

    protected abstract Response newResponse(Request var1, int var2, int var3, int var4, List<ShardOperationResult> var5, List<ShardOperationFailedException> var6, ClusterState var7);

    protected abstract Request readRequestFrom(StreamInput var1) throws IOException;

    protected abstract ShardOperationResult shardOperation(Request var1, ShardRouting var2) throws IOException;

    protected abstract ShardsIterator shards(ClusterState var1, Request var2, String[] var3);

    protected abstract ClusterBlockException checkGlobalBlock(ClusterState var1, Request var2);

    protected abstract ClusterBlockException checkRequestBlock(ClusterState var1, Request var2, String[] var3);

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncAction(this, request, listener).start();
    }

    public static final class EmptyResult
    implements Streamable {
        public static EmptyResult INSTANCE = new EmptyResult();

        private EmptyResult() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }

        public static EmptyResult readEmptyResultFrom(StreamInput in) {
            return INSTANCE;
        }
    }

    class NodeResponse
    extends TransportResponse {
        protected String nodeId;
        protected int totalShards;
        protected List<BroadcastShardOperationFailedException> exceptions;
        protected List<ShardOperationResult> results;

        public NodeResponse() {
        }

        public NodeResponse(String nodeId, int totalShards, List<ShardOperationResult> results, List<BroadcastShardOperationFailedException> exceptions) {
            this.nodeId = nodeId;
            this.totalShards = totalShards;
            this.results = results;
            this.exceptions = exceptions;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public int getTotalShards() {
            return this.totalShards;
        }

        public int getSuccessfulShards() {
            return this.results.size();
        }

        public List<BroadcastShardOperationFailedException> getExceptions() {
            return this.exceptions;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int resultsSize;
            super.readFrom(in);
            this.nodeId = in.readString();
            this.totalShards = in.readVInt();
            this.results = new ArrayList(resultsSize);
            for (resultsSize = in.readVInt(); resultsSize > 0; --resultsSize) {
                Object result = in.readBoolean() ? (Object)TransportBroadcastByNodeAction.this.readShardResult(in) : null;
                this.results.add(result);
            }
            if (in.readBoolean()) {
                int failureShards = in.readVInt();
                this.exceptions = new ArrayList<BroadcastShardOperationFailedException>(failureShards);
                for (int i = 0; i < failureShards; ++i) {
                    this.exceptions.add(new BroadcastShardOperationFailedException(in));
                }
            } else {
                this.exceptions = null;
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.nodeId);
            out.writeVInt(this.totalShards);
            out.writeVInt(this.results.size());
            for (Streamable result : this.results) {
                out.writeOptionalStreamable(result);
            }
            out.writeBoolean(this.exceptions != null);
            if (this.exceptions != null) {
                int failureShards = this.exceptions.size();
                out.writeVInt(failureShards);
                for (int i = 0; i < failureShards; ++i) {
                    this.exceptions.get(i).writeTo(out);
                }
            }
        }
    }

    public class NodeRequest
    extends TransportRequest
    implements IndicesRequest {
        private String nodeId;
        private List<ShardRouting> shards;
        protected Request indicesLevelRequest;

        public NodeRequest() {
        }

        public NodeRequest(String nodeId, Request request, List<ShardRouting> shards) {
            super((TransportRequest)request);
            this.indicesLevelRequest = request;
            this.shards = shards;
            this.nodeId = nodeId;
        }

        public List<ShardRouting> getShards() {
            return this.shards;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        @Override
        public String[] indices() {
            return ((BroadcastRequest)this.indicesLevelRequest).indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            return ((BroadcastRequest)this.indicesLevelRequest).indicesOptions();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.indicesLevelRequest = TransportBroadcastByNodeAction.this.readRequestFrom(in);
            int size = in.readVInt();
            this.shards = new ArrayList<ShardRouting>(size);
            for (int i = 0; i < size; ++i) {
                this.shards.add(ShardRouting.readShardRoutingEntry(in));
            }
            this.nodeId = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            ((BroadcastRequest)this.indicesLevelRequest).writeTo(out);
            int size = this.shards.size();
            out.writeVInt(size);
            for (int i = 0; i < size; ++i) {
                this.shards.get(i).writeTo(out);
            }
            out.writeString(this.nodeId);
        }
    }

    class BroadcastByNodeTransportRequestHandler
    implements TransportRequestHandler<NodeRequest> {
        BroadcastByNodeTransportRequestHandler() {
        }

        @Override
        public void messageReceived(NodeRequest request, TransportChannel channel) throws Exception {
            List<ShardRouting> shards = request.getShards();
            int totalShards = shards.size();
            if (TransportBroadcastByNodeAction.this.logger.isTraceEnabled()) {
                TransportBroadcastByNodeAction.this.logger.trace("[{}] executing operation on [{}] shards", TransportBroadcastByNodeAction.this.actionName, totalShards);
            }
            Object[] shardResultOrExceptions = new Object[totalShards];
            int shardIndex = -1;
            for (ShardRouting shardRouting : shards) {
                this.onShardOperation(request, shardResultOrExceptions, ++shardIndex, shardRouting);
            }
            ArrayList<BroadcastShardOperationFailedException> accumulatedExceptions = new ArrayList<BroadcastShardOperationFailedException>();
            ArrayList<Streamable> results = new ArrayList<Streamable>();
            for (int i = 0; i < totalShards; ++i) {
                if (shardResultOrExceptions[i] instanceof BroadcastShardOperationFailedException) {
                    accumulatedExceptions.add((BroadcastShardOperationFailedException)shardResultOrExceptions[i]);
                    continue;
                }
                results.add((Streamable)shardResultOrExceptions[i]);
            }
            channel.sendResponse(new NodeResponse(request.getNodeId(), totalShards, results, accumulatedExceptions));
        }

        private void onShardOperation(NodeRequest request, Object[] shardResults, int shardIndex, ShardRouting shardRouting) {
            block6: {
                try {
                    if (TransportBroadcastByNodeAction.this.logger.isTraceEnabled()) {
                        TransportBroadcastByNodeAction.this.logger.trace("[{}]  executing operation for shard [{}]", TransportBroadcastByNodeAction.this.actionName, shardRouting.shortSummary());
                    }
                    Object result = TransportBroadcastByNodeAction.this.shardOperation(request.indicesLevelRequest, shardRouting);
                    shardResults[shardIndex] = result;
                    if (TransportBroadcastByNodeAction.this.logger.isTraceEnabled()) {
                        TransportBroadcastByNodeAction.this.logger.trace("[{}]  completed operation for shard [{}]", TransportBroadcastByNodeAction.this.actionName, shardRouting.shortSummary());
                    }
                }
                catch (Throwable t) {
                    BroadcastShardOperationFailedException e = new BroadcastShardOperationFailedException(shardRouting.shardId(), "operation " + TransportBroadcastByNodeAction.this.actionName + " failed", t);
                    e.setIndex(shardRouting.getIndex());
                    e.setShard(shardRouting.shardId());
                    shardResults[shardIndex] = e;
                    if (TransportActions.isShardNotAvailableException(t)) {
                        if (TransportBroadcastByNodeAction.this.logger.isTraceEnabled()) {
                            TransportBroadcastByNodeAction.this.logger.trace("[{}] failed to execute operation for shard [{}]", t, TransportBroadcastByNodeAction.this.actionName, shardRouting.shortSummary());
                        }
                    }
                    if (!TransportBroadcastByNodeAction.this.logger.isDebugEnabled()) break block6;
                    TransportBroadcastByNodeAction.this.logger.debug("[{}] failed to execute operation for shard [{}]", t, TransportBroadcastByNodeAction.this.actionName, shardRouting.shortSummary());
                }
            }
        }
    }

    protected static class AsyncAction {
        private final Request request;
        private final ActionListener<Response> listener;
        private final ClusterState clusterState;
        private final DiscoveryNodes nodes;
        private final Map<String, List<ShardRouting>> nodeIds;
        private final AtomicReferenceArray<Object> responses;
        private final AtomicInteger counter = new AtomicInteger();
        private List<NoShardAvailableActionException> unavailableShardExceptions = new ArrayList<NoShardAvailableActionException>();
        final /* synthetic */ TransportBroadcastByNodeAction this$0;

        protected AsyncAction(Request request, ActionListener<Response> listener) {
            this.this$0 = var1_1;
            this.request = request;
            this.listener = listener;
            this.clusterState = ((TransportBroadcastByNodeAction)var1_1).clusterService.state();
            this.nodes = this.clusterState.nodes();
            ClusterBlockException globalBlockException = var1_1.checkGlobalBlock(this.clusterState, request);
            if (globalBlockException != null) {
                throw globalBlockException;
            }
            String[] concreteIndices = ((TransportBroadcastByNodeAction)var1_1).indexNameExpressionResolver.concreteIndices(this.clusterState, (IndicesRequest)request);
            ClusterBlockException requestBlockException = var1_1.checkRequestBlock(this.clusterState, request, concreteIndices);
            if (requestBlockException != null) {
                throw requestBlockException;
            }
            if (((TransportBroadcastByNodeAction)var1_1).logger.isTraceEnabled()) {
                ((TransportBroadcastByNodeAction)var1_1).logger.trace("resolving shards for [{}] based on cluster state version [{}]", ((TransportBroadcastByNodeAction)var1_1).actionName, this.clusterState.version());
            }
            ShardsIterator shardIt = var1_1.shards(this.clusterState, request, concreteIndices);
            this.nodeIds = Maps.newHashMap();
            for (ShardRouting shard : shardIt.asUnordered()) {
                if (shard.assignedToNode() && this.nodes.get(shard.currentNodeId()) != null) {
                    String nodeId = shard.currentNodeId();
                    if (!this.nodeIds.containsKey(nodeId)) {
                        this.nodeIds.put(nodeId, new ArrayList());
                    }
                    this.nodeIds.get(nodeId).add(shard);
                    continue;
                }
                this.unavailableShardExceptions.add(new NoShardAvailableActionException(shard.shardId(), " no shards available for shard " + shard.toString() + " while executing " + ((TransportBroadcastByNodeAction)var1_1).actionName));
            }
            this.responses = new AtomicReferenceArray(this.nodeIds.size());
        }

        public void start() {
            if (this.nodeIds.size() == 0) {
                try {
                    this.onCompletion();
                }
                catch (Throwable e) {
                    this.listener.onFailure(e);
                }
            } else {
                int nodeIndex = -1;
                for (Map.Entry<String, List<ShardRouting>> entry : this.nodeIds.entrySet()) {
                    DiscoveryNode node = this.nodes.get(entry.getKey());
                    this.sendNodeRequest(node, entry.getValue(), ++nodeIndex);
                }
            }
        }

        private void sendNodeRequest(final DiscoveryNode node, List<ShardRouting> shards, final int nodeIndex) {
            try {
                NodeRequest nodeRequest = new NodeRequest(this.this$0, node.getId(), this.request, shards);
                this.this$0.transportService.sendRequest(node, this.this$0.transportNodeBroadcastAction, nodeRequest, new BaseTransportResponseHandler<NodeResponse>(){

                    @Override
                    public NodeResponse newInstance() {
                        return AsyncAction.this.this$0.new NodeResponse();
                    }

                    @Override
                    public void handleResponse(NodeResponse response) {
                        AsyncAction.this.onNodeResponse(node, nodeIndex, response);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        AsyncAction.this.onNodeFailure(node, nodeIndex, exp);
                    }

                    @Override
                    public String executor() {
                        return "same";
                    }
                });
            }
            catch (Throwable e) {
                this.onNodeFailure(node, nodeIndex, e);
            }
        }

        protected void onNodeResponse(DiscoveryNode node, int nodeIndex, NodeResponse response) {
            if (this.this$0.logger.isTraceEnabled()) {
                this.this$0.logger.trace("received response for [{}] from node [{}]", this.this$0.actionName, node.id());
            }
            if (this.responses.compareAndSet(nodeIndex, null, response) && this.counter.incrementAndGet() == this.responses.length()) {
                this.onCompletion();
            }
        }

        protected void onNodeFailure(DiscoveryNode node, int nodeIndex, Throwable t) {
            String nodeId = node.id();
            if (this.this$0.logger.isDebugEnabled() && !(t instanceof NodeShouldNotConnectException)) {
                this.this$0.logger.debug("failed to execute [{}] on node [{}]", t, this.this$0.actionName, nodeId);
            }
            if (this.responses.compareAndSet(nodeIndex, null, new FailedNodeException(nodeId, "Failed node [" + nodeId + "]", t)) && this.counter.incrementAndGet() == this.responses.length()) {
                this.onCompletion();
            }
        }

        protected void onCompletion() {
            BroadcastResponse response = null;
            try {
                response = this.this$0.newResponse(this.request, this.responses, this.unavailableShardExceptions, this.nodeIds, this.clusterState);
            }
            catch (Throwable t) {
                this.this$0.logger.debug("failed to combine responses from nodes", t, new Object[0]);
                this.listener.onFailure(t);
            }
            if (response != null) {
                try {
                    this.listener.onResponse(response);
                }
                catch (Throwable t) {
                    this.listener.onFailure(t);
                }
            }
        }
    }
}

