/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import com.carrotsearch.hppc.FloatArrayList;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericFloatAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class FloatFieldMapper
extends NumberFieldMapper {
    public static final String CONTENT_TYPE = "float";

    protected FloatFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, ignoreMalformed, coerce, indexSettings, multiFields, copyTo);
    }

    @Override
    public FloatFieldType fieldType() {
        return (FloatFieldType)super.fieldType();
    }

    private static float parseValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof BytesRef) {
            return Float.parseFloat(((BytesRef)value).utf8ToString());
        }
        return Float.parseFloat(value.toString());
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected void innerParseCreateField(ParseContext context, List<Field> fields) throws IOException {
        Object field;
        float value;
        float boost = this.fieldType().boost();
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue == null) {
                if (this.fieldType().nullValue() == null) {
                    return;
                }
                value = this.fieldType().nullValue().floatValue();
            } else if (externalValue instanceof String) {
                String sExternalValue = (String)externalValue;
                if (sExternalValue.length() == 0) {
                    if (this.fieldType().nullValue() == null) {
                        return;
                    }
                    value = this.fieldType().nullValue().floatValue();
                } else {
                    value = Float.parseFloat(sExternalValue);
                }
            } else {
                value = ((Number)externalValue).floatValue();
            }
            if (context.includeInAll(this.includeInAll, this)) {
                context.allEntries().addText(this.fieldType().names().fullName(), Float.toString(value), boost);
            }
        } else {
            XContentParser parser = context.parser();
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL || parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
                if (this.fieldType().nullValue() == null) {
                    return;
                }
                value = this.fieldType().nullValue().floatValue();
                if (this.fieldType().nullValueAsString() != null && context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.fieldType().names().fullName(), this.fieldType().nullValueAsString(), boost);
                }
            } else if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                String currentFieldName = null;
                Float objValue = this.fieldType().nullValue();
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        objValue = Float.valueOf(parser.floatValue((Boolean)this.coerce.value()));
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new IllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
                if (objValue == null) {
                    return;
                }
                value = objValue.floatValue();
            } else {
                value = parser.floatValue((Boolean)this.coerce.value());
                if (context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.fieldType().names().fullName(), parser.text(), boost);
                }
            }
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            field = new CustomFloatNumericField(value, this.fieldType());
            field.setBoost(boost);
            fields.add((Field)field);
        }
        if (this.fieldType().hasDocValues()) {
            if (this.useSortedNumericDocValues) {
                this.addDocValue(context, fields, NumericUtils.floatToSortableInt((float)value));
            } else {
                field = (CustomFloatNumericDocValuesField)context.doc().getByKey(this.fieldType().names().indexName());
                if (field != null) {
                    ((CustomFloatNumericDocValuesField)field).add(value);
                } else {
                    field = new CustomFloatNumericDocValuesField(this.fieldType().names().indexName(), value);
                    context.doc().addWithKey(this.fieldType().names().indexName(), (IndexableField)field);
                }
            }
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.fieldType().numericPrecisionStep() != 8) {
            builder.field("precision_step", this.fieldType().numericPrecisionStep());
        }
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValue());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
    }

    public static class CustomFloatNumericDocValuesField
    extends NumberFieldMapper.CustomNumericDocValuesField {
        private final FloatArrayList values = new FloatArrayList();

        public CustomFloatNumericDocValuesField(String name, float value) {
            super(name);
            this.add(value);
        }

        public void add(float value) {
            this.values.add(value);
        }

        public BytesRef binaryValue() {
            CollectionUtils.sortAndDedup(this.values);
            byte[] bytes = new byte[this.values.size() * 4];
            for (int i = 0; i < this.values.size(); ++i) {
                ByteUtils.writeFloatLE(this.values.get(i), bytes, i * 4);
            }
            return new BytesRef(bytes);
        }
    }

    public static class CustomFloatNumericField
    extends NumberFieldMapper.CustomNumericField {
        private final float number;

        public CustomFloatNumericField(float number, NumberFieldMapper.NumberFieldType fieldType) {
            super(Float.valueOf(number), fieldType);
            this.number = number;
        }

        public TokenStream tokenStream(Analyzer analyzer, TokenStream previous) throws IOException {
            if (this.fieldType().indexOptions() != IndexOptions.NONE) {
                return this.getCachedStream().setFloatValue(this.number);
            }
            return null;
        }

        @Override
        public String numericAsString() {
            return Float.toString(this.number);
        }
    }

    static final class FloatFieldType
    extends NumberFieldMapper.NumberFieldType {
        public FloatFieldType() {
            super(FieldType.NumericType.FLOAT);
        }

        protected FloatFieldType(FloatFieldType ref) {
            super(ref);
        }

        @Override
        public NumberFieldMapper.NumberFieldType clone() {
            return new FloatFieldType(this);
        }

        @Override
        public String typeName() {
            return FloatFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Float nullValue() {
            return (Float)super.nullValue();
        }

        @Override
        public Float value(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            if (value instanceof BytesRef) {
                return Float.valueOf(Numbers.bytesToFloat((BytesRef)value));
            }
            return Float.valueOf(Float.parseFloat(value.toString()));
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            int intValue = NumericUtils.floatToSortableInt((float)FloatFieldMapper.parseValue(value));
            BytesRefBuilder bytesRef = new BytesRefBuilder();
            NumericUtils.intToPrefixCoded((int)intValue, (int)0, (BytesRefBuilder)bytesRef);
            return bytesRef.get();
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
            return NumericRangeQuery.newFloatRange((String)this.names().indexName(), (int)this.numericPrecisionStep(), (Float)(lowerTerm == null ? null : Float.valueOf(FloatFieldMapper.parseValue(lowerTerm))), (Float)(upperTerm == null ? null : Float.valueOf(FloatFieldMapper.parseValue(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
            float iValue = FloatFieldMapper.parseValue(value);
            float iSim = fuzziness.asFloat();
            return NumericRangeQuery.newFloatRange((String)this.names().indexName(), (int)this.numericPrecisionStep(), (Float)Float.valueOf(iValue - iSim), (Float)Float.valueOf(iValue + iSim), (boolean)true, (boolean)true);
        }

        @Override
        public FieldStats stats(Terms terms, int maxDoc) throws IOException {
            float minValue = NumericUtils.sortableIntToFloat((int)NumericUtils.getMinInt((Terms)terms));
            float maxValue = NumericUtils.sortableIntToFloat((int)NumericUtils.getMaxInt((Terms)terms));
            return new FieldStats.Float(maxDoc, terms.getDocCount(), terms.getSumDocFreq(), terms.getSumTotalTermFreq(), minValue, maxValue);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.floatField(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                if (propNode == null) {
                    throw new MapperParsingException("Property [null_value] cannot be null.");
                }
                builder.nullValue(Float.valueOf(XContentMapValues.nodeFloatValue(propNode)));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, FloatFieldMapper> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, 8);
            this.builder = this;
        }

        @Override
        public FloatFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            FloatFieldMapper fieldMapper = new FloatFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.coerce(context), context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
            return (FloatFieldMapper)fieldMapper.includeInAll(this.includeInAll);
        }

        @Override
        protected NamedAnalyzer makeNumberAnalyzer(int precisionStep) {
            return NumericFloatAnalyzer.buildNamedAnalyzer(precisionStep);
        }

        @Override
        protected int maxPrecisionStep() {
            return 32;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final MappedFieldType FIELD_TYPE = new FloatFieldType();

        static {
            FIELD_TYPE.freeze();
        }
    }
}

