/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.jvm;

import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.jvm.JvmStats;

public class JvmService
extends AbstractComponent {
    private final JvmInfo jvmInfo = JvmInfo.jvmInfo();
    private final TimeValue refreshInterval;
    private JvmStats jvmStats = JvmStats.jvmStats();

    @Inject
    public JvmService(Settings settings) {
        super(settings);
        this.refreshInterval = this.settings.getAsTime("refresh_interval", TimeValue.timeValueSeconds(1L));
        this.logger.debug("Using refresh_interval [{}]", this.refreshInterval);
    }

    public JvmInfo info() {
        return this.jvmInfo;
    }

    public synchronized JvmStats stats() {
        if (System.currentTimeMillis() - this.jvmStats.getTimestamp() > this.refreshInterval.millis()) {
            this.jvmStats = JvmStats.jvmStats();
        }
        return this.jvmStats;
    }
}

