/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontAdder;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.autodetect.FontFileFinder;
import org.apache.fop.util.LogUtil;
import org.apache.xmlgraphics.util.ClasspathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontDetector {
    private static Log log = LogFactory.getLog(FontDetector.class);
    private static final String[] FONT_MIMETYPES = new String[]{"application/x-font", "application/x-font-truetype"};
    private final FontManager fontManager;
    private final FontAdder fontAdder;
    private final boolean strict;
    private final FontEventListener eventListener;

    public FontDetector(FontManager manager, FontAdder adder, boolean strict, FontEventListener listener) {
        this.fontManager = manager;
        this.fontAdder = adder;
        this.strict = strict;
        this.eventListener = listener;
    }

    public void detect(List<EmbedFontInfo> fontInfoList) throws FOPException {
        FontFileFinder fontFileFinder = new FontFileFinder(this.eventListener);
        String fontBaseURL = this.fontManager.getFontBaseURL();
        if (fontBaseURL != null) {
            try {
                File fontBase = FileUtils.toFile(new URL(fontBaseURL));
                if (fontBase != null) {
                    List<URL> fontURLList = fontFileFinder.find(fontBase.getAbsolutePath());
                    this.fontAdder.add(fontURLList, fontInfoList);
                }
            }
            catch (IOException e) {
                LogUtil.handleException((Log)log, (Exception)e, (boolean)this.strict);
            }
        }
        try {
            List<URL> systemFontList = fontFileFinder.find();
            this.fontAdder.add(systemFontList, fontInfoList);
        }
        catch (IOException e) {
            LogUtil.handleException((Log)log, (Exception)e, (boolean)this.strict);
        }
        ClasspathResource resource = ClasspathResource.getInstance();
        for (int i = 0; i < FONT_MIMETYPES.length; ++i) {
            this.fontAdder.add(resource.listResourcesOfMimeType(FONT_MIMETYPES[i]), fontInfoList);
        }
    }
}

