/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.rendersurface;

import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.render.MeshRenderer;
import org.jmol.shapesurface.Isosurface;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.C;
import org.jmol.util.Normix;

public class IsosurfaceRenderer
extends MeshRenderer {
    protected boolean iHideBackground;
    protected boolean isBicolorMap;
    protected short backgroundColix;
    protected int nError = 0;
    protected float[] vertexValues;
    protected IsosurfaceMesh imesh;
    private Isosurface isosurface;
    private boolean isNavigationMode;
    private boolean iShowNormals;
    private boolean showNumbers;
    private Boolean showKey;
    private boolean hasColorRange;
    private int meshScale = -1;
    private int mySlabValue;
    private int globalSlabValue;

    @Override
    protected boolean render() {
        return this.renderIso();
    }

    protected boolean renderIso() {
        this.setGlobals();
        int n = this.isosurface.meshCount;
        while (--n >= 0) {
            this.imesh = (IsosurfaceMesh)this.isosurface.meshes[n];
            this.mesh = this.imesh;
            if (this.imesh.connectedAtoms != null && !this.vwr.ms.at[this.imesh.connectedAtoms[0]].checkVisible()) continue;
            this.hasColorRange = false;
            if (!this.renderMeshSlab()) continue;
            this.renderInfo();
            if (!this.isExport || !this.isGhostPass) continue;
            this.exportPass = 1;
            this.renderMeshSlab();
            this.exportPass = 2;
        }
        return this.needTranslucent;
    }

    private void setGlobals() {
        this.needTranslucent = false;
        this.antialias = this.g3d.isAntialiased();
        this.iShowNormals = this.vwr.getTestFlag(4);
        this.showNumbers = this.vwr.getTestFlag(3);
        this.isosurface = (Isosurface)this.shape;
        this.exportPass = this.isExport ? 2 : 0;
        this.isNavigationMode = this.vwr.getBoolean(603979889);
        this.showKey = this.vwr.getBoolean(603979869) ? Boolean.TRUE : null;
        this.isosurface.keyXy = null;
        this.meshScale = -1;
        this.globalSlabValue = this.vwr.gdata.slab;
        this.mySlabValue = this.isNavigationMode ? (int)this.tm.getNavigationOffset().z : Integer.MAX_VALUE;
    }

    protected void renderInfo() {
        if (this.isExport || !this.hasColorRange || this.imesh.colorEncoder == null || Boolean.TRUE != this.showKey) {
            return;
        }
        this.showKey = Boolean.FALSE;
        int[] nArray = null;
        short[] sArray = null;
        Lst<Object>[] lstArray = null;
        int n = 0;
        int n2 = 0;
        if (this.imesh.showContourLines) {
            lstArray = this.imesh.getContours();
            if (lstArray == null) {
                sArray = this.imesh.jvxlData.contourColixes;
                if (sArray == null) {
                    return;
                }
                n = sArray.length;
            } else {
                n = lstArray.length;
                n2 = 1;
            }
        } else {
            nArray = this.imesh.colorEncoder.getColorSchemeArray(this.imesh.colorEncoder.currentPalette);
            n = nArray == null ? 0 : nArray.length;
            n2 = 2;
        }
        if (n < 2) {
            return;
        }
        int n3 = this.antialias ? 2 : 1;
        int n4 = this.vwr.getScreenHeight() * n3;
        int n5 = n4 / 2 / (n - 1);
        int n6 = n4 / 4 * 3 - n5;
        int n7 = 10 * n3;
        int n8 = 20 * n3;
        this.isosurface.keyXy = new int[]{n7 / n3, 0, (n7 + n8) / n3, (n6 + n5) / n3, n5 / n3};
        int n9 = 0;
        while (n9 < n) {
            switch (n2) {
                case 0: {
                    if (this.g3d.setC(sArray[n9])) break;
                    return;
                }
                case 1: {
                    if (this.g3d.setC(((short[])lstArray[n9].get(3))[0])) break;
                    return;
                }
                case 2: {
                    this.vwr.gdata.setColor(nArray[n9]);
                }
            }
            this.g3d.fillTextRect(n7, n6, 5, Integer.MIN_VALUE, n8, n5);
            ++n9;
            n6 -= n5;
        }
        this.isosurface.keyXy[1] = (n6 + n5) / n3;
    }

    private boolean renderMeshSlab() {
        boolean bl;
        this.volumeRender = this.imesh.jvxlData.colorDensity && this.imesh.jvxlData.allowVolumeRender;
        int n = this.mySlabValue;
        boolean bl2 = this.frontOnly = this.mesh.frontOnly || this.shapeID == 26;
        if (!this.isNavigationMode) {
            this.meshSlabValue = this.imesh.jvxlData.slabValue;
            if (this.meshSlabValue != Integer.MIN_VALUE && this.imesh.jvxlData.isSlabbable) {
                P3[] p3Array = this.imesh.jvxlData.boundingBox;
                float f = Float.MAX_VALUE;
                float f2 = Float.MIN_VALUE;
                int n2 = p3Array.length;
                while (--n2 >= 0) {
                    this.pt2f.setT(p3Array[n2]);
                    this.tm.transformPt3f(this.pt2f, this.pt2f);
                    if (this.pt2f.z < f) {
                        f = this.pt2f.z;
                    }
                    if (!(this.pt2f.z > f2)) continue;
                    f2 = this.pt2f.z;
                }
                n = Math.round(f + (f2 - f) * (100.0f - (float)this.meshSlabValue) / 100.0f);
                this.frontOnly &= this.meshSlabValue >= 100;
            }
        }
        boolean bl3 = this.vwr.gdata.translucentCoverOnly;
        this.vwr.gdata.translucentCoverOnly = this.frontOnly || !this.vwr.getBoolean(603979967);
        this.thePlane = this.imesh.jvxlData.jvxlPlane;
        this.vertexValues = this.mesh.vvs;
        if (n != Integer.MAX_VALUE && this.imesh.jvxlData.isSlabbable) {
            this.g3d.setSlab(n);
            bl = this.renderMesh2(this.mesh);
            this.g3d.setSlab(this.globalSlabValue);
        } else {
            bl = this.renderMesh2(this.mesh);
        }
        this.vwr.gdata.translucentCoverOnly = bl3;
        return bl;
    }

    @Override
    protected void render2(boolean bl) {
        if (this.volumeRender) {
            this.renderPoints();
            return;
        }
        switch (this.imesh.dataType) {
            case 70: {
                this.renderLonePair(false);
                return;
            }
            case 71: {
                this.renderLonePair(true);
                return;
            }
        }
        this.isBicolorMap = this.imesh.jvxlData.isBicolorMap;
        this.render2b(bl);
        if (!this.g3d.setC((short)4)) {
            return;
        }
        if (this.imesh.showContourLines) {
            this.renderContourLines();
        }
    }

    private void renderLonePair(boolean bl) {
        this.pt2f.setT(this.vertices[1]);
        this.tm.transformPt3f(this.pt2f, this.pt2f);
        int n = (int)this.vwr.tm.scaleToScreen((int)this.pt2f.z, 100);
        if (n < 1) {
            n = 1;
        }
        if (!bl) {
            V3 v3 = new V3();
            V3 v32 = new V3();
            this.pt1f.setT(this.vertices[0]);
            this.tm.transformPt3f(this.pt1f, this.pt1f);
            v3.sub2(this.pt2f, this.pt1f);
            v32.set(v3.x, v3.y, v3.z + 1.0f);
            v32.cross(v32, v3);
            v32.normalize();
            float f = this.vwr.tm.scaleToScreen((int)this.pt1f.z, 100);
            v32.scale(f);
            this.pt1f.add2(this.pt2f, v32);
            this.pt2f.sub(v32);
            this.screens[0].set(Math.round(this.pt1f.x), Math.round(this.pt1f.y), Math.round(this.pt1f.z));
            this.g3d.fillSphereI(n, this.screens[0]);
        }
        this.screens[1].set(Math.round(this.pt2f.x), Math.round(this.pt2f.y), Math.round(this.pt2f.z));
        this.g3d.fillSphereI(n, this.screens[1]);
    }

    private void renderContourLines() {
        Lst<Object>[] lstArray = this.imesh.getContours();
        if (lstArray == null) {
            if (this.imesh.jvxlData.contourValues != null) {
                this.hasColorRange = true;
            }
            return;
        }
        this.hasColorRange = this.mesh.meshColix == 0;
        int n = lstArray.length;
        block0: while (--n >= 0) {
            Lst<Object> lst = lstArray[n];
            if (lst.size() < 6) continue;
            short s = this.colix = this.mesh.meshColix == 0 ? ((short[])lst.get(3))[0] : this.mesh.meshColix;
            if (!this.g3d.setC(this.colix)) {
                return;
            }
            int n2 = lst.size() - 1;
            int n3 = this.getDiameter();
            for (int i = 6; i < n2; ++i) {
                T3 t3 = (T3)lst.get(i);
                T3 t32 = (T3)lst.get(++i);
                if (Float.isNaN(t3.x) || Float.isNaN(t32.x)) continue block0;
                this.tm.transformPtScrT3(t3, this.pt1f);
                this.tm.transformPtScrT3(t32, this.pt2f);
                this.pt1f.z -= 2.0f;
                this.pt2f.z -= 2.0f;
                if (!this.antialias && n3 == 1) {
                    this.g3d.drawLineAB(this.pt1f, this.pt2f);
                    continue;
                }
                this.g3d.fillCylinderBits((byte)1, n3, this.pt1f, this.pt2f);
            }
        }
    }

    @Override
    protected void renderPoints() {
        try {
            int n;
            int n2;
            int n3;
            if (this.volumeRender) {
                this.g3d.volumeRender(true);
            }
            boolean bl = (this.volumeRender || this.mesh.pc == 0) && this.selectedPolyOnly;
            int n4 = this.imesh.vertexIncrement;
            if (this.mesh.diameter <= 0) {
                n3 = this.vwr.getInt(0x21000010);
                this.frontOnly = false;
            } else {
                n3 = this.vwr.getScreenDim() / (this.volumeRender ? 50 : 100);
            }
            int n5 = Math.round(Float.isNaN(this.mesh.volumeRenderPointSize) ? 150.0f : this.mesh.volumeRenderPointSize * 1000.0f);
            if (n3 < 1) {
                n3 = 1;
            }
            int n6 = this.showNumbers ? this.vwr.getScreenWidth() / 2 : 0;
            int n7 = n2 = this.showNumbers ? this.vwr.getScreenHeight() / 2 : 0;
            if (this.showNumbers) {
                this.vwr.gdata.setFontFid(this.vwr.gdata.getFontFidFS("Monospaced", 24.0f));
            }
            int n8 = n = !this.imesh.hasGridPoints || this.imesh.firstRealVertex < 0 ? 0 : this.imesh.firstRealVertex;
            while (n < this.vertexCount) {
                if (!(this.vertexValues != null && Float.isNaN(this.vertexValues[n]) || this.frontOnly && !this.isVisibleNormix(this.normixes[n]) || this.imesh.jvxlData.thisSet >= 0 && this.mesh.vertexSets[n] != this.imesh.jvxlData.thisSet || !this.mesh.isColorSolid && this.mesh.vcs != null && !this.setColix(this.mesh.vcs[n]) || this.haveBsDisplay && !this.mesh.bsDisplay.get(n) || bl && !this.bsPolygons.get(n))) {
                    this.hasColorRange = true;
                    if (this.showNumbers && this.screens[n].z > 10 && Math.abs(this.screens[n].x - n6) < 150 && Math.abs(this.screens[n].y - n2) < 150) {
                        String string = n + (this.mesh.isColorSolid ? "" : " " + this.mesh.vvs[n]);
                        this.g3d.setC((short)4);
                        this.g3d.drawStringNoSlab(string, null, this.screens[n].x, this.screens[n].y, this.screens[n].z - 30, (short)0);
                    }
                    if (this.volumeRender) {
                        n3 = (int)this.vwr.tm.scaleToScreen(this.screens[n].z, n5);
                        if (n3 < 1) {
                            n3 = 1;
                        }
                        this.g3d.volumeRender4(n3, this.screens[n].x, this.screens[n].y, this.screens[n].z);
                    } else {
                        this.g3d.fillSphereI(n3, this.screens[n]);
                    }
                }
                n += n4;
            }
            if (n4 == 3) {
                this.g3d.setC(this.isTranslucent ? C.getColixTranslucent3((short)12, true, 0.5f) : (short)12);
                for (n = 1; n < this.vertexCount; n += 3) {
                    this.g3d.fillCylinder((byte)3, n3 / 4, this.screens[n], this.screens[n + 1]);
                }
                this.g3d.setC(this.isTranslucent ? C.getColixTranslucent3((short)21, true, 0.5f) : (short)21);
                for (n = 1; n < this.vertexCount; n += 3) {
                    this.g3d.fillSphereI(n3, this.screens[n]);
                }
                this.g3d.setC(this.isTranslucent ? C.getColixTranslucent3((short)7, true, 0.5f) : (short)7);
                for (n = 2; n < this.vertexCount; n += 3) {
                    this.g3d.fillSphereI(n3, this.screens[n]);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.volumeRender) {
            this.g3d.volumeRender(false);
        }
    }

    @Override
    protected void renderTriangles(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        short[] sArray;
        this.g3d.addRenderer(1073742182);
        int[][] nArray = this.mesh.pis;
        this.colix = this.isGhostPass ? this.mesh.slabColix : (!bl && this.mesh.meshColix != 0 ? this.mesh.meshColix : this.mesh.colix);
        Object object = sArray = (Object)(!bl && this.mesh.meshColix != 0 ? null : this.mesh.vcs);
        if (this.isTranslucentInherit) {
            this.colix = C.copyColixTranslucency(this.mesh.slabColix, this.mesh.colix);
        }
        this.g3d.setC(this.colix);
        boolean bl5 = bl3;
        if (bl5) {
            if (this.frontOnly && bl) {
                this.frontOnly = false;
            }
            this.bsPolygonsToExport.clearAll();
        }
        if (this.exportType == 1) {
            this.frontOnly = false;
        }
        boolean bl6 = this.isGhostPass && !this.isBicolorMap || sArray == null || this.mesh.isColorSolid;
        boolean bl7 = this.isGhostPass && !this.isBicolorMap || sArray == null || !bl && this.mesh.meshColix != 0;
        boolean bl8 = this.imesh.jvxlData.jvxlPlane != null;
        short s = this.colix;
        if (bl8 && !bl6 && !bl && this.mesh.fillTriangles) {
            bl6 = true;
            s = 4;
        }
        boolean bl9 = bl4 = bl6 && this.mesh.pcs != null;
        if (bl4 && !bl && this.mesh.fillTriangles) {
            bl4 = false;
        }
        short[] sArray2 = this.imesh.jvxlData.contourColixes;
        this.hasColorRange = !bl6 && !this.isBicolorMap;
        int n = this.getDiameter();
        int n2 = 0;
        int n3 = this.mesh.pc;
        while (--n3 >= n2) {
            short s2;
            short s3;
            short s4;
            int[] nArray2 = nArray[n3];
            if (nArray2 == null || this.selectedPolyOnly && !this.bsPolygons.get(n3)) continue;
            int n4 = nArray2[0];
            int n5 = nArray2[1];
            int n6 = nArray2[2];
            if (this.imesh.jvxlData.thisSet >= 0 && this.mesh.vertexSets != null && this.mesh.vertexSets[n4] != this.imesh.jvxlData.thisSet || this.haveBsDisplay && (!this.mesh.bsDisplay.get(n4) || !this.mesh.bsDisplay.get(n5) || !this.mesh.bsDisplay.get(n6))) continue;
            short s5 = this.normixes[n4];
            short s6 = this.normixes[n5];
            short s7 = this.normixes[n6];
            int n7 = this.checkNormals(s5, s6, s7);
            if (bl && n7 == 0) continue;
            if (bl6) {
                if (bl4 && n3 < this.mesh.pcs.length) {
                    short s8 = this.mesh.pcs[n3];
                    if (s8 == 0) continue;
                    s = s8;
                }
                if (bl2) {
                    s = (short)(Math.round(Math.random() * 10.0) + 5L);
                }
                s3 = s4 = s;
                s2 = s4;
            } else {
                s2 = sArray[n4];
                s3 = sArray[n5];
                s4 = sArray[n6];
                if (this.isBicolorMap) {
                    if (s2 != s3 || s3 != s4) continue;
                    if (this.isGhostPass) {
                        s3 = s4 = C.copyColixTranslucency(this.mesh.slabColix, s2);
                        s2 = s4;
                    }
                }
            }
            if (bl) {
                if (bl5) {
                    this.bsPolygonsToExport.set(n3);
                    continue;
                }
                if (n5 == n6) {
                    this.setColix(s2);
                    if (n4 == n5) {
                        this.g3d.fillSphereI(n, this.screens[n4]);
                    } else {
                        this.g3d.fillCylinder((byte)3, n, this.screens[n4], this.screens[n5]);
                    }
                } else if (this.mesh.colorsExplicit) {
                    this.vwr.gdata.setColor(nArray2[4]);
                    s2 = C.copyColixTranslucency(this.mesh.colix, (short)2047);
                    this.g3d.setC(s2);
                    this.g3d.fillTriangle3CN(this.screens[n4], s2, s5, this.screens[n5], s2, s6, this.screens[n6], s2, s7);
                } else {
                    if (this.isTranslucentInherit && sArray != null) {
                        s2 = C.copyColixTranslucency(this.mesh.slabColix, sArray[n4]);
                        s3 = C.copyColixTranslucency(this.mesh.slabColix, sArray[n5]);
                        s4 = C.copyColixTranslucency(this.mesh.slabColix, sArray[n6]);
                    }
                    this.g3d.fillTriangle3CN(this.screens[n4], s2, s5, this.screens[n5], s3, s6, this.screens[n6], s4, s7);
                }
                if (!this.iShowNormals) continue;
                this.renderNormals();
                continue;
            }
            if ((n7 &= nArray2[3]) == 0) continue;
            if (bl2) {
                n7 = 7;
            }
            this.pt1i.setT(this.screens[n4]);
            this.pt2i.setT(this.screens[n5]);
            this.pt3i.setT(this.screens[n6]);
            this.pt1i.z -= 2;
            this.pt2i.z -= 2;
            this.pt3i.z -= 2;
            if (!bl7) {
                if (bl4) {
                    this.g3d.setC(this.mesh.fillTriangles ? (short)4 : sArray2[nArray2[4] % sArray2.length]);
                } else {
                    this.drawTriangle(this.pt1i, s2, this.pt2i, s3, this.pt3i, s4, n7, n);
                    continue;
                }
            }
            this.drawTriangle(this.pt1i, s, this.pt2i, s, this.pt3i, s, n7, n);
        }
        if (bl5) {
            this.exportSurface(bl6 ? s : (short)0);
        }
    }

    private int getDiameter() {
        int n;
        if (this.mesh.diameter <= 0) {
            int n2 = n = this.meshScale < 0 ? (this.meshScale = this.vwr.getInt(553648151)) : this.meshScale;
            if (this.antialias) {
                n *= 2;
            }
        } else {
            n = this.vwr.getScreenDim() / 100;
        }
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    private void renderNormals() {
        if (!this.g3d.setC(C.copyColixTranslucency(this.mesh.colix, (short)8))) {
            return;
        }
        this.vwr.gdata.setFontFid(this.vwr.gdata.getFontFidFS("Monospaced", 24.0f));
        V3[] v3Array = Normix.getVertexVectors();
        int n = this.vertexCount;
        while (--n >= 0) {
            if (this.vertexValues != null && Float.isNaN(this.vertexValues[n])) continue;
            this.pt1f.setT(this.vertices[n]);
            short s = this.mesh.normixes[n];
            if (s < 0) continue;
            this.pt2f.scaleAdd2(0.3f, v3Array[s], this.pt1f);
            this.tm.transformPtScrT3(this.pt2f, this.pt2f);
            this.pt1f.set(this.screens[n].x, this.screens[n].y, this.screens[n].z);
            this.g3d.drawLineAB(this.pt1f, this.pt2f);
        }
    }
}

