/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.P3;
import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public class JSONReader
extends AtomSetCollectionReader {
    private P3 scale;

    public void initializeReader() throws Exception {
        this.asc.setCollectionName("JSON");
        this.asc.newAtomSet();
        String string = "";
        while (this.rd() != null) {
            string = string + this.line;
        }
        if ((string = PT.replaceAllCharacters((String)string, (String)"\" ", (String)"").replace(',', ':')).contains("_is2D:true")) {
            this.set2D();
        }
        if (string.contains("_scale:")) {
            this.getScaling(this.getSection(string, "_scale", false));
        }
        string = PT.replaceAllCharacters((String)string, (String)"}", (String)"").replace(',', ':');
        this.readAtoms(this.getSection(string, "a", true));
        this.readBonds(this.getSection(string, "b", true));
        this.continuing = false;
    }

    private void getScaling(String[] stringArray) {
        String[] stringArray2 = PT.split((String)stringArray[0], (String)":");
        this.scale = P3.new3((float)1.0f, (float)1.0f, (float)1.0f);
        block5: for (int i = 0; i < stringArray2.length; i += 2) {
            if (stringArray2[i].length() != 1) continue;
            switch (stringArray2[i].charAt(0)) {
                case 'x': {
                    this.scale.x = this.parseFloatStr(stringArray2[i + 1]);
                    continue block5;
                }
                case 'y': {
                    this.scale.y = this.parseFloatStr(stringArray2[i + 1]);
                    continue block5;
                }
                case 'z': {
                    this.scale.z = this.parseFloatStr(stringArray2[i + 1]);
                }
            }
        }
        Logger.info((String)("scale set to " + this.scale));
    }

    private String[] getSection(String string, String string2, boolean bl) {
        String[] stringArray = PT.split((String)string, (String)(string2 + ":" + (bl ? "[" : "") + "{"));
        if (stringArray.length < 2) {
            return stringArray;
        }
        String string3 = stringArray[1];
        string3 = string3.substring(0, string3.indexOf(bl ? "]" : "}")) + ":";
        return PT.split((String)string3, (String)"{");
    }

    private void readAtoms(String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = PT.split((String)stringArray[i], (String)":");
            Atom atom = this.asc.addNewAtom();
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            String string = "C";
            block7: for (int j = 0; j < stringArray2.length; j += 2) {
                if (stringArray2[j].length() != 1) continue;
                switch (stringArray2[j].charAt(0)) {
                    case 'x': {
                        f = this.parseFloatStr(stringArray2[j + 1]);
                        continue block7;
                    }
                    case 'y': {
                        f2 = this.parseFloatStr(stringArray2[j + 1]);
                        continue block7;
                    }
                    case 'z': {
                        f3 = this.parseFloatStr(stringArray2[j + 1]);
                        continue block7;
                    }
                    case 'l': {
                        string = stringArray2[j + 1];
                    }
                }
            }
            if (this.scale != null) {
                f /= this.scale.x;
                f2 /= this.scale.y;
                f3 /= this.scale.z;
            }
            this.setAtomCoordXYZ(atom, f, f2, f3);
            atom.elementSymbol = string;
        }
    }

    private void readBonds(String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = PT.split((String)stringArray[i], (String)":");
            int n = 0;
            int n2 = 0;
            int n3 = 1;
            block13: for (int j = 0; j < stringArray2.length; j += 2) {
                if (stringArray2[j].length() != 1) continue;
                switch (stringArray2[j].charAt(0)) {
                    case 'b': {
                        n = this.parseIntStr(stringArray2[j + 1]);
                        continue block13;
                    }
                    case 'e': {
                        n2 = this.parseIntStr(stringArray2[j + 1]);
                        continue block13;
                    }
                    case 'o': {
                        int n4 = (int)(this.parseFloatStr(stringArray2[j + 1]) * 2.0f);
                        switch (n4) {
                            case 0: {
                                continue block13;
                            }
                            case 2: 
                            case 4: 
                            case 6: 
                            case 8: {
                                n3 = n4 / 2;
                                continue block13;
                            }
                            case 1: {
                                n3 = 33;
                                continue block13;
                            }
                            case 3: {
                                n3 = 66;
                                continue block13;
                            }
                            case 5: {
                                n3 = 97;
                                continue block13;
                            }
                        }
                        n3 = 1;
                    }
                }
            }
            this.asc.addBond(new Bond(n, n2, n3));
        }
    }
}

