/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.CalculationsMMFF;

class MMFFOOPCalc
extends Calculation {
    static final double FOOPD = 2.5120761569715815;
    static final double FOOP = 71.96568080495746;
    int[] list = new int[4];

    MMFFOOPCalc() {
    }

    void setData(Lst<Object[]> lst, int n) {
        if (this.calcs.minAtoms[n].nBonds != 3) {
            return;
        }
        int[] nArray = this.calcs.minAtoms[n].getBondedAtomIndexes();
        this.list[0] = nArray[2];
        this.list[1] = n;
        this.list[2] = nArray[1];
        this.list[3] = nArray[0];
        double d = ((CalculationsMMFF)this.calcs).mmff.getOutOfPlaneParameter(this.list);
        if (d == 0.0) {
            return;
        }
        double[] dArray = new double[]{d};
        lst.addLast((Object)new Object[]{new int[]{nArray[0], n, nArray[1], nArray[2]}, dArray});
        lst.addLast((Object)new Object[]{new int[]{nArray[1], n, nArray[2], nArray[0]}, dArray});
        lst.addLast((Object)new Object[]{new int[]{nArray[2], n, nArray[0], nArray[1]}, dArray});
    }

    @Override
    double compute(Object[] objectArray) {
        this.getPointers(objectArray);
        this.calcs.setOopVariables(this, false);
        double d = this.dData[0];
        this.energy = 71.96568080495746 * d * this.theta * this.theta;
        if (this.calcs.gradients) {
            this.dE = 2.5120761569715815 * d * this.theta;
            this.calcs.addForces(this, 4);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(4, this));
        }
        return this.energy;
    }
}

