/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.shape.FontLineShape;
import org.jmol.util.Escape;
import org.jmol.viewer.JC;

public class Axes
extends FontLineShape {
    public P3 axisXY = new P3();
    public float scale;
    private P3 fixedOrigin;
    final P3 originPoint = new P3();
    final P3[] axisPoints = new P3[6];
    static final P3 pt0 = new P3();
    public String[] labels;
    public String axisType;
    final P3 ptTemp;
    private static final float MIN_AXIS_LEN = 1.5f;
    V3 corner;

    public Axes() {
        int n = 6;
        while (--n >= 0) {
            this.axisPoints[n] = new P3();
        }
        this.ptTemp = new P3();
        this.corner = new V3();
    }

    public P3 getOriginPoint(boolean bl) {
        return bl ? pt0 : this.originPoint;
    }

    public P3 getAxisPoint(int n, boolean bl) {
        if (!bl && this.axisXY.z == 0.0f) {
            return this.axisPoints[n];
        }
        this.ptTemp.sub2(this.axisPoints[n], this.originPoint);
        this.ptTemp.scale(0.5f);
        return this.ptTemp;
    }

    @Override
    public void setProperty(String string, Object object, BS bS) {
        if ("position" == string) {
            boolean bl = this.axisXY.z == 0.0f && ((P3)object).z != 0.0f;
            this.axisXY = (P3)object;
            this.setScale(bl ? 1.0f : this.scale);
            return;
        }
        if ("origin" == string) {
            if (object == null) {
                this.fixedOrigin = null;
            } else {
                if (this.fixedOrigin == null) {
                    this.fixedOrigin = new P3();
                }
                this.fixedOrigin.setT((P3)object);
            }
            this.initShape();
            return;
        }
        if ("labels" == string) {
            this.labels = (String[])object;
            return;
        }
        if ("labelsOn" == string) {
            this.labels = null;
            return;
        }
        if ("labelsOff" == string) {
            this.labels = new String[]{"", "", ""};
            return;
        }
        if ("type" == string) {
            this.axisType = (String)object;
            if (this.axisType.equals("abc")) {
                this.axisType = null;
            }
        }
        this.setPropFLS(string, object);
    }

    @Override
    public void initShape() {
        super.initShape();
        this.myType = "axes";
        this.font3d = this.vwr.gdata.getFont3D(14.0f);
        int n = this.vwr.g.axesMode;
        if (this.fixedOrigin == null) {
            this.originPoint.set(0.0f, 0.0f, 0.0f);
        } else {
            this.originPoint.setT(this.fixedOrigin);
        }
        if (n == 0x24000020 && this.ms.unitCells != null) {
            SymmetryInterface symmetryInterface = this.vwr.getCurrentUnitCell();
            if (symmetryInterface != null) {
                this.scale = this.vwr.getFloat(0x22000002) / 2.0f;
                symmetryInterface.setAxes(this.scale, this.axisPoints, this.fixedOrigin, this.originPoint);
                return;
            }
        } else if (n == 0x24000022 && this.fixedOrigin == null) {
            this.originPoint.setT(this.vwr.getBoundBoxCenter());
        }
        this.setScale(this.vwr.getFloat(0x22000002) / 2.0f);
    }

    @Override
    public Object getProperty(String string, int n) {
        if (string == "axisPoints") {
            return this.axisPoints;
        }
        if (string == "origin") {
            return this.fixedOrigin;
        }
        if (string == "axesTypeXY") {
            return this.axisXY.z == 0.0f ? Boolean.FALSE : Boolean.TRUE;
        }
        return null;
    }

    void setScale(float f) {
        this.scale = f;
        this.corner.setT(this.vwr.getBoundBoxCornerVector());
        int n = 6;
        while (--n >= 0) {
            P3 p3 = this.axisPoints[n];
            p3.setT(JC.unitAxisVectors[n]);
            if (this.corner.x < 1.5f) {
                this.corner.x = 1.5f;
            }
            if (this.corner.y < 1.5f) {
                this.corner.y = 1.5f;
            }
            if (this.corner.z < 1.5f) {
                this.corner.z = 1.5f;
            }
            if (this.axisXY.z == 0.0f) {
                p3.x *= this.corner.x * f;
                p3.y *= this.corner.y * f;
                p3.z *= this.corner.z * f;
            }
            p3.add(this.originPoint);
        }
    }

    @Override
    public String getShapeState() {
        SB sB = new SB();
        sB.append("  axes scale ").appendF(this.vwr.getFloat(0x22000002)).append(";\n");
        if (this.fixedOrigin != null) {
            sB.append("  axes center ").append(Escape.eP(this.fixedOrigin)).append(";\n");
        }
        if (this.axisXY.z != 0.0f) {
            sB.append("  axes position [").appendI((int)this.axisXY.x).append(" ").appendI((int)this.axisXY.y).append(" ").append(this.axisXY.z < 0.0f ? " %" : "").append("];\n");
        }
        if (this.labels != null) {
            sB.append("  axes labels ");
            for (int i = 0; i < this.labels.length; ++i) {
                if (this.labels[i] == null) continue;
                sB.append(PT.esc(this.labels[i])).append(" ");
            }
            sB.append(";\n");
        }
        if (this.axisType != null) {
            sB.append("  axes type " + PT.esc(this.axisType));
        }
        return super.getShapeState() + sB;
    }
}

