/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.multitouch.sparshui;

import com.sparshui.common.Event;
import com.sparshui.common.Location;
import com.sparshui.common.messages.events.DragEvent;
import com.sparshui.common.messages.events.RotateEvent;
import com.sparshui.common.messages.events.ZoomEvent;
import com.sparshui.gestures.Gesture;
import com.sparshui.server.TouchPoint;
import java.util.ArrayList;
import java.util.List;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.util.Logger;

public class TwoPointGesture
implements Gesture {
    private int _myType = 9;
    protected Location _offset = null;
    protected Location _offsetCentroid = null;
    private List<Location> _traces1 = new ArrayList<Location>();
    private List<Location> _traces2 = new ArrayList<Location>();
    private int _id1 = -1;
    private int _id2 = -1;
    private int _nTraces = 0;
    private float _scale;
    private float _rotation;
    private long time;

    @Override
    public String getName() {
        return "TwoPointGesture";
    }

    @Override
    public int getGestureType() {
        return this._myType;
    }

    @Override
    public List<Event> processChange(List<TouchPoint> list, TouchPoint touchPoint) {
        return this.processChangeSync(touchPoint);
    }

    private synchronized List<Event> processChangeSync(TouchPoint touchPoint) {
        ArrayList arrayList = null;
        this.time = touchPoint.getTime();
        switch (touchPoint.getState()) {
            case 0: {
                arrayList = this.processBirth(touchPoint);
                break;
            }
            case 2: {
                arrayList = this.processMove(touchPoint);
                break;
            }
            case 1: {
                arrayList = this.processDeath(touchPoint);
            }
        }
        return arrayList != null ? arrayList : new ArrayList();
    }

    protected List<Event> processBirth(TouchPoint touchPoint) {
        Location location = touchPoint.getLocation();
        int n = touchPoint.getID();
        switch (this._nTraces) {
            case 0: {
                this._traces1.clear();
                this._traces1.add(Location.pixelLocation(location));
                this._id1 = n;
                this._nTraces = 1;
                break;
            }
            case 1: {
                this._traces2.clear();
                this._traces2.add(Location.pixelLocation(location));
                this._id2 = n;
                Location location2 = this._traces1.get(this._traces1.size() - 1);
                this._traces1.clear();
                this._traces1.add(location2);
                this._nTraces = 2;
                break;
            }
            default: {
                Logger.error((String)"TwoPointGesture birth ignored!");
            }
        }
        return null;
    }

    protected List<Event> processDeath(TouchPoint touchPoint) {
        int n = touchPoint.getID();
        switch (this._nTraces) {
            case 0: {
                Logger.error((String)("TwoPointGesture death -- no traces! " + n));
                break;
            }
            case 1: {
                this._nTraces = 0;
                break;
            }
            case 2: {
                if (n == this._id1) {
                    this._id1 = this._id2;
                    List<Location> list = this._traces1;
                    this._traces1 = this._traces2;
                    this._traces2 = list;
                    this._traces2.clear();
                    this._id2 = -1;
                    this._nTraces = 1;
                    break;
                }
                if (n == this._id2) {
                    this._traces2.clear();
                    this._id2 = -1;
                    this._nTraces = 1;
                    break;
                }
                this._nTraces = 0;
            }
        }
        if (this._nTraces == 0) {
            this._traces1.clear();
            this._traces2.clear();
            this._id2 = -1;
            this._id1 = -1;
        }
        this._offsetCentroid = null;
        this._myType = 9;
        return null;
    }

    protected List<Event> processMove(TouchPoint touchPoint) {
        ArrayList<Event> arrayList = new ArrayList<Event>();
        if (!this.updateLocations(touchPoint)) {
            return arrayList;
        }
        if (this._myType == 9) {
            this.checkType();
        }
        Location location = Location.screenLocation(this._offsetCentroid);
        if (this._myType == 9 || !this.updateParameters()) {
            return arrayList;
        }
        Location location2 = Location.screenLocation(this._offsetCentroid);
        Event event = null;
        switch (this._myType) {
            case 5: {
                event = new ZoomEvent(this._scale, location2, this.time);
                break;
            }
            case 2: {
                event = new RotateEvent(this._rotation, location2, this.time);
                break;
            }
            case 1: {
                if (location == null) break;
                V3 v3 = location.getVector(location2);
                event = new DragEvent(v3.x, v3.y, 2, this.time);
            }
        }
        if (event != null) {
            arrayList.add(event);
        }
        return arrayList;
    }

    private boolean updateLocations(TouchPoint touchPoint) {
        Location location = Location.pixelLocation(touchPoint.getLocation());
        int n = touchPoint.getID();
        if (n == this._id1) {
            if (this._traces1.size() > 2) {
                while (this._traces1.size() > 2) {
                    this._traces1.remove(0);
                }
            }
            this._traces1.add(location);
        } else if (n == this._id2) {
            if (this._traces2.size() > 2) {
                while (this._traces2.size() > 2) {
                    this._traces2.remove(0);
                }
            }
            this._traces2.add(location);
        } else {
            Logger.error((String)("TwoPointGesture updateLocation error: no trace with id " + n));
            return false;
        }
        return this._nTraces == 2 && this._traces1.size() == 3 && this._traces2.size() == 3;
    }

    private void checkType() {
        Location location = this._traces1.get(0);
        Location location2 = this._traces1.get(this._traces1.size() - 1);
        V3 v3 = location.getVector(location2);
        float f = v3.length();
        Location location3 = this._traces2.get(0);
        Location location4 = this._traces2.get(this._traces2.size() - 1);
        V3 v32 = location3.getVector(location4);
        float f2 = v32.length();
        if (f < 3.0f || f2 < 3.0f) {
            return;
        }
        v3.normalize();
        v32.normalize();
        float f3 = v3.dot((T3)v32);
        if ((double)f3 > 0.8) {
            this._myType = 1;
        } else if ((double)f3 < -0.8) {
            this._myType = 5;
        }
    }

    private boolean updateParameters() {
        Location location = this._traces1.get(0);
        Location location2 = this._traces2.get(0);
        Location location3 = this._traces1.get(this._traces1.size() - 1);
        Location location4 = this._traces2.get(this._traces2.size() - 1);
        float f = location.getDistance(location3);
        float f2 = location2.getDistance(location4);
        float f3 = location3.getDistance(location4);
        if (f < 2.0f && f2 < 2.0f) {
            return false;
        }
        V3 v3 = location.getVector(location2);
        float f4 = v3.length();
        v3.normalize();
        switch (this._myType) {
            case 2: {
                V3 v32;
                V3 v33;
                this._offsetCentroid = Location.getCenter(location, location2);
                if (f2 < 2.0f) {
                    v33 = location2.getVector(location);
                    v32 = location2.getVector(location3);
                } else {
                    v33 = location.getVector(location2);
                    v32 = location.getVector(location4);
                }
                v33.cross((T3)v33, (T3)v32);
                this._rotation = v33.z < 0.0f ? 1 : -1;
                return true;
            }
            case 5: {
                if (Math.abs(f3 - f4) < 2.0f) {
                    return false;
                }
                this._scale = f3 < f4 ? -1 : 1;
                this._offsetCentroid = Location.getCentroid(location, location2, f / (f + f2));
                return true;
            }
            case 1: {
                this._offsetCentroid = Location.getCenter(location3, location4);
                return true;
            }
        }
        return false;
    }
}

