/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.api.Interface;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.JmolBioMeshRenderer;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelsetbio.CarbohydratePolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.PhosphorusPolymer;
import org.jmol.render.ShapeRenderer;
import org.jmol.renderbio.TraceRenderer;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeCollection;
import org.jmol.util.C;

abstract class BioShapeRenderer
extends ShapeRenderer {
    private boolean invalidateMesh;
    private boolean invalidateSheets;
    private boolean isTraceAlpha;
    private boolean ribbonBorder = false;
    private boolean haveControlPointScreens;
    float aspectRatio;
    int hermiteLevel;
    private float sheetSmoothing;
    protected boolean cartoonsFancy;
    protected int monomerCount;
    protected Monomer[] monomers;
    protected boolean isNucleic;
    protected boolean isPhosphorusOnly;
    protected boolean isCarbohydrate;
    protected BS bsVisible = new BS();
    protected P3[] ribbonTopScreens;
    protected P3[] ribbonBottomScreens;
    protected P3[] controlPoints;
    protected P3[] controlPointScreens;
    protected int[] leadAtomIndices;
    protected V3[] wingVectors;
    protected short[] mads;
    protected short[] colixes;
    protected short[] colixesBack;
    protected STR[] structureTypes;
    boolean isHighRes;
    protected boolean wireframeOnly;
    private boolean needTranslucent;
    JmolBioMeshRenderer meshRenderer;
    private final P3 pointT = new P3();
    int iPrev;
    int iNext;
    int iNext2;
    int iNext3;
    int diameterBeg;
    int diameterMid;
    int diameterEnd;
    short madBeg;
    short madMid;
    short madEnd;
    short colixBack;
    private BS reversed;
    private final P3 screenArrowTop = new P3();
    private final P3 screenArrowTopPrev = new P3();
    private final P3 screenArrowBot = new P3();
    private final P3 screenArrowBotPrev = new P3();

    BioShapeRenderer() {
    }

    protected abstract void renderBioShape(BioShape var1);

    protected boolean render() {
        if (this.shape == null) {
            return false;
        }
        this.setGlobals();
        this.renderShapes();
        return this.needTranslucent;
    }

    private void setGlobals() {
        int n;
        boolean bl;
        this.invalidateMesh = false;
        this.needTranslucent = false;
        this.g3d.addRenderer(553648147);
        boolean bl2 = bl = !this.isExport && !this.vwr.checkMotionRendering(1112152066);
        if (bl != this.wireframeOnly) {
            this.invalidateMesh = true;
        }
        this.wireframeOnly = bl;
        boolean bl3 = bl = this.isExport || !this.wireframeOnly && this.vwr.getBoolean(603979864);
        if (bl != this.isHighRes) {
            this.invalidateMesh = true;
        }
        this.isHighRes = bl;
        boolean bl4 = bl = !this.wireframeOnly && (this.vwr.getBoolean(603979817) || this.isExport);
        if (this.cartoonsFancy != bl) {
            this.invalidateMesh = true;
            this.cartoonsFancy = bl;
        }
        int n2 = (n = this.vwr.getHermiteLevel()) <= 0 ? -n : (n = this.vwr.getInMotion(true) ? 0 : n);
        if (this.cartoonsFancy && !this.wireframeOnly) {
            n = Math.max(n, 3);
        }
        if (n != this.hermiteLevel) {
            this.invalidateMesh = true;
        }
        this.hermiteLevel = Math.min(n, 8);
        int n3 = this.vwr.getInt(553648166);
        n3 = Math.min(Math.max(0, n3), 20);
        if (this.cartoonsFancy && n3 >= 16) {
            n3 = 4;
        }
        if (this.wireframeOnly || this.hermiteLevel == 0) {
            n3 = 0;
        }
        if ((float)n3 != this.aspectRatio && n3 != 0 && n != 0) {
            this.invalidateMesh = true;
        }
        this.aspectRatio = n3;
        if (this.aspectRatio > 0.0f && this.meshRenderer == null) {
            this.meshRenderer = (JmolBioMeshRenderer)Interface.getInterface((String)"org.jmol.renderbio.BioMeshRenderer");
            this.meshRenderer.setup(this.g3d, this.vwr.ms, this.shape);
            this.meshRenderer.setViewerG3dShapeID(this.vwr, this.shape.shapeID);
        }
        if ((bl = this.vwr.getBoolean(603979966)) != this.isTraceAlpha) {
            this.invalidateMesh = true;
        }
        this.isTraceAlpha = bl;
        this.invalidateSheets = false;
        float f = this.vwr.getFloat(0x22000030);
        if (f != this.sheetSmoothing && this.isTraceAlpha) {
            this.sheetSmoothing = f;
            this.invalidateMesh = true;
            this.invalidateSheets = true;
        }
    }

    private void renderShapes() {
        BioShapeCollection bioShapeCollection = (BioShapeCollection)this.shape;
        int n = bioShapeCollection.bioShapes.length;
        while (--n >= 0) {
            BioShape bioShape = bioShapeCollection.getBioShape(n);
            if ((bioShape.modelVisibilityFlags & this.myVisibilityFlag) == 0 || bioShape.monomerCount < 2 || !this.initializePolymer(bioShape)) continue;
            if (this.meshRenderer != null) {
                this.meshRenderer.initBS();
            }
            this.renderBioShape(bioShape);
            if (this.meshRenderer != null) {
                this.meshRenderer.renderMeshes();
            }
            this.freeTempArrays();
        }
    }

    protected boolean setBioColix(short s) {
        if (this.g3d.setC(s)) {
            return true;
        }
        this.needTranslucent = true;
        return false;
    }

    private void freeTempArrays() {
        if (this.haveControlPointScreens) {
            this.vwr.freeTempPoints(this.controlPointScreens);
        }
        this.vwr.freeTempEnum(this.structureTypes);
    }

    private boolean initializePolymer(BioShape bioShape) {
        BS bS = this.vwr.slm.bsDeleted;
        this.controlPoints = this.vwr.ms.isJmolDataFrameForModel(bioShape.modelIndex) ? bioShape.bioPolymer.getControlPoints(true, 0.0f, false) : bioShape.bioPolymer.getControlPoints(this.isTraceAlpha, this.sheetSmoothing, this.invalidateSheets);
        this.monomerCount = bioShape.monomerCount;
        this.monomers = bioShape.monomers;
        this.reversed = bioShape.bioPolymer.reversed;
        this.leadAtomIndices = bioShape.bioPolymer.getLeadAtomIndices();
        this.bsVisible.clearAll();
        boolean bl = false;
        if (this.invalidateMesh) {
            bioShape.falsifyMesh();
        }
        int n = this.monomerCount;
        while (--n >= 0) {
            if ((this.monomers[n].shapeVisibilityFlags & this.myVisibilityFlag) == 0 || this.ms.isAtomHidden(this.leadAtomIndices[n]) || bS != null && bS.get(this.leadAtomIndices[n])) continue;
            Atom atom = this.ms.at[this.leadAtomIndices[n]];
            if (!this.g3d.isInDisplayRange(atom.sX, atom.sY)) continue;
            this.bsVisible.set(n);
            bl = true;
        }
        if (!bl) {
            return false;
        }
        this.ribbonBorder = this.vwr.getBoolean(603979899);
        this.isNucleic = bioShape.bioPolymer instanceof NucleicPolymer;
        this.isPhosphorusOnly = !this.isNucleic && bioShape.bioPolymer instanceof PhosphorusPolymer;
        this.isCarbohydrate = bioShape.bioPolymer instanceof CarbohydratePolymer;
        this.haveControlPointScreens = false;
        this.wingVectors = bioShape.wingVectors;
        if (this.meshRenderer != null) {
            this.meshRenderer.initialize((ShapeRenderer)this, bioShape, this.monomerCount);
        }
        this.mads = bioShape.mads;
        this.colixes = bioShape.colixes;
        this.colixesBack = bioShape.colixesBack;
        this.setStructureTypes();
        return true;
    }

    private void setStructureTypes() {
        this.structureTypes = this.vwr.allocTempEnum(this.monomerCount + 1);
        STR[] sTRArray = this.structureTypes;
        int n = this.monomerCount;
        while (--n >= 0) {
            sTRArray[n] = this.monomers[n].getProteinStructureType();
            if (sTRArray[n] != STR.TURN) continue;
            sTRArray[n] = STR.NONE;
        }
        sTRArray[this.monomerCount] = sTRArray[this.monomerCount - 1];
    }

    protected void calcScreenControlPoints() {
        int n = this.monomerCount + 1;
        this.controlPointScreens = this.vwr.allocTempPoints(n);
        P3[] p3Array = this.controlPointScreens;
        P3[] p3Array2 = this.controlPoints;
        int n2 = n;
        while (--n2 >= 0) {
            this.tm.transformPtScrT3((T3)p3Array2[n2], (T3)p3Array[n2]);
        }
        this.haveControlPointScreens = true;
    }

    protected P3[] calcScreens(float f, short[] sArray) {
        int n = this.controlPoints.length;
        P3[] p3Array = this.vwr.allocTempPoints(n);
        if (f == 0.0f) {
            int n2 = n;
            while (--n2 >= 0) {
                this.tm.transformPtScrT3((T3)this.controlPoints[n2], (T3)p3Array[n2]);
            }
        } else {
            float f2 = f / 1000.0f;
            int n3 = n;
            while (--n3 >= 0) {
                this.calc1Screen(this.controlPoints[n3], this.wingVectors[n3], sArray[n3] == 0 && n3 > 0 ? sArray[n3 - 1] : sArray[n3], f2, p3Array[n3]);
            }
        }
        return p3Array;
    }

    private void calc1Screen(P3 p3, V3 v3, short s, float f, P3 p32) {
        this.pointT.scaleAdd2((float)s * f, (T3)v3, (T3)p3);
        this.tm.transformPtScrT3((T3)this.pointT, (T3)p32);
    }

    protected short getLeadColix(int n) {
        return C.getColixInherited((short)this.colixes[n], (short)this.monomers[n].getLeadAtom().colixAtom);
    }

    protected short getLeadColixBack(int n) {
        return this.colixesBack == null || this.colixesBack.length <= n ? (short)0 : this.colixesBack[n];
    }

    void setNeighbors(int n) {
        this.iPrev = Math.max(n - 1, 0);
        this.iNext = Math.min(n + 1, this.monomerCount);
        this.iNext2 = Math.min(n + 2, this.monomerCount);
        this.iNext3 = Math.min(n + 3, this.monomerCount);
    }

    protected boolean setColix(short s) {
        this.colix = s;
        return this.g3d.setC(s);
    }

    private boolean setMads(int n, boolean bl) {
        this.madBeg = this.madEnd = this.mads[n];
        this.madMid = this.madEnd;
        if (this.isTraceAlpha) {
            if (!bl || this.structureTypes[n] == this.structureTypes[this.iNext]) {
                this.madEnd = this.mads[this.iNext];
                if (this.madEnd == 0) {
                    this.madEnd = this instanceof TraceRenderer ? this.madBeg : this.madBeg;
                }
                this.madMid = (short)(this.madBeg + this.madEnd >> 1);
            }
        } else {
            if (!bl || this.structureTypes[n] == this.structureTypes[this.iPrev]) {
                this.madBeg = (short)((this.mads[this.iPrev] == 0 ? this.madMid : this.mads[this.iPrev]) + this.madMid >> 1);
            }
            if (!bl || this.structureTypes[n] == this.structureTypes[this.iNext]) {
                this.madEnd = (short)((this.mads[this.iNext] == 0 ? this.madMid : this.mads[this.iNext]) + this.madMid >> 1);
            }
        }
        this.diameterBeg = (int)this.vwr.tm.scaleToScreen((int)this.controlPointScreens[n].z, (int)this.madBeg);
        this.diameterMid = (int)this.vwr.tm.scaleToScreen(this.monomers[n].getLeadAtom().sZ, (int)this.madMid);
        this.diameterEnd = (int)this.vwr.tm.scaleToScreen((int)this.controlPointScreens[this.iNext].z, (int)this.madEnd);
        boolean bl2 = n == this.iPrev || bl && this.structureTypes[n] != this.structureTypes[this.iPrev];
        boolean bl3 = this.iNext == this.iNext2 || bl && this.structureTypes[n] != this.structureTypes[this.iNext];
        return this.meshRenderer != null && this.meshRenderer.check(bl2, bl3);
    }

    protected void renderHermiteCylinder(P3[] p3Array, int n) {
        this.colix = this.getLeadColix(n);
        if (!this.setBioColix(this.colix)) {
            return;
        }
        this.setNeighbors(n);
        this.g3d.drawHermite4(this.isNucleic ? 4 : 7, p3Array[this.iPrev], p3Array[n], p3Array[this.iNext], p3Array[this.iNext2]);
    }

    protected void renderHermiteConic(int n, boolean bl, int n2) {
        this.setNeighbors(n);
        this.colix = this.getLeadColix(n);
        if (!this.setBioColix(this.colix)) {
            return;
        }
        if (this.setMads(n, bl) || this.isExport) {
            this.meshRenderer.setFancyConic(n, n2);
            return;
        }
        if (this.diameterBeg == 0 && this.diameterEnd == 0 || this.wireframeOnly) {
            this.g3d.drawLineAB(this.controlPointScreens[n], this.controlPointScreens[this.iNext]);
        } else {
            this.g3d.fillHermite(this.isNucleic ? 4 : 7, this.diameterBeg, this.diameterMid, this.diameterEnd, this.controlPointScreens[this.iPrev], this.controlPointScreens[n], this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2]);
        }
    }

    protected void renderHermiteRibbon(boolean bl, int n, boolean bl2) {
        this.setNeighbors(n);
        short s = this.colix = this.getLeadColix(n);
        if (!this.setBioColix(this.colix)) {
            return;
        }
        short s2 = this.colixBack = this.getLeadColixBack(n);
        if (bl && (this.aspectRatio != 0.0f || this.isExport) && (this.setMads(n, bl2) || this.isExport)) {
            this.meshRenderer.setFancyRibbon(n);
            return;
        }
        boolean bl3 = this.reversed.get(n);
        if (bl3 && this.colixBack != 0) {
            this.setColix(this.colixBack);
            s2 = s;
        }
        this.g3d.drawHermite7(bl, this.ribbonBorder, (bl3 ? -1 : 1) * (this.isNucleic ? 4 : 7), this.ribbonTopScreens[this.iPrev], this.ribbonTopScreens[n], this.ribbonTopScreens[this.iNext], this.ribbonTopScreens[this.iNext2], this.ribbonBottomScreens[this.iPrev], this.ribbonBottomScreens[n], this.ribbonBottomScreens[this.iNext], this.ribbonBottomScreens[this.iNext2], (int)this.aspectRatio, s2);
        if (bl3 && this.colixBack != 0) {
            this.setColix(s);
            s2 = this.colixBack;
        }
    }

    protected void renderHermiteArrowHead(int n) {
        this.colix = this.getLeadColix(n);
        if (!this.setBioColix(this.colix)) {
            return;
        }
        this.colixBack = this.getLeadColixBack(n);
        this.setNeighbors(n);
        if (this.setMads(n, false) || this.isExport) {
            this.meshRenderer.setFancyArrowHead(n);
            return;
        }
        P3 p3 = this.controlPoints[n];
        V3 v3 = this.wingVectors[n];
        this.calc1Screen(p3, v3, this.madBeg, 7.0E-4f, this.screenArrowTop);
        this.calc1Screen(p3, v3, this.madBeg, -7.0E-4f, this.screenArrowBot);
        this.calc1Screen(p3, v3, this.madBeg, 0.001f, this.screenArrowTopPrev);
        this.calc1Screen(p3, v3, this.madBeg, -0.001f, this.screenArrowBotPrev);
        this.g3d.drawHermite7(true, this.ribbonBorder, this.isNucleic ? 4 : 7, this.screenArrowTopPrev, this.screenArrowTop, this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2], this.screenArrowBotPrev, this.screenArrowBot, this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2], (int)this.aspectRatio, this.colixBack);
        this.g3d.setC(this.colix);
        if (this.ribbonBorder && this.aspectRatio == 0.0f) {
            this.g3d.fillCylinderBits((byte)3, 3, this.screenArrowTop, this.screenArrowBot);
        }
    }
}

