/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.array.ArrayGeneralizeNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=ArrayGeneralizeNode.class)
public final class ArrayGeneralizeNodeGen
extends ArrayGeneralizeNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode requiredCapacity_;
    @CompilerDirectives.CompilationFinal
    private Class<?> requiredCapacityType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayGeneralizeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
        super(context, sourceSection);
        this.array_ = array;
        this.requiredCapacity_ = requiredCapacity;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeGeneralize(DynamicObject arrayValue, int requiredCapacityValue) {
        return this.specialization_.execute1(arrayValue, requiredCapacityValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
        return this.specialization_.executeDynamicObject(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static ArrayGeneralizeNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
        return new ArrayGeneralizeNodeGen(context, sourceSection, array, requiredCapacity);
    }

    @GeneratedBy(methodName="generalizeDouble(DynamicObject, int)", value=ArrayGeneralizeNode.class)
    private static final class GeneralizeDoubleNode_
    extends BaseNode_ {
        private final Class<?> requiredCapacityImplicitType;

        GeneralizeDoubleNode_(ArrayGeneralizeNodeGen root, Object requiredCapacityValue) {
            super(root, 4);
            this.requiredCapacityImplicitType = RubyTypesGen.getImplicitIntegerClass(requiredCapacityValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.requiredCapacityImplicitType == ((GeneralizeDoubleNode_)other).requiredCapacityImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            return this.executeDynamicObject(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), requiredCapacityValue);
            }
            try {
                if (this.requiredCapacityImplicitType == Integer.TYPE) {
                    requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
                } else {
                    Object requiredCapacityValue__ = this.executeRequiredCapacity_(frameValue);
                    requiredCapacityValue_ = RubyTypesGen.expectImplicitInteger(requiredCapacityValue__, this.requiredCapacityImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult());
            }
            if (ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.generalizeDouble(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int requiredCapacityValue) {
            if (ArrayGuards.isDoubleArray(arrayValue)) {
                return this.root.generalizeDouble(arrayValue, requiredCapacityValue);
            }
            return this.getNext().execute1(arrayValue, requiredCapacityValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = RubyTypesGen.asImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType);
                if (ArrayGuards.isDoubleArray(arrayValue_)) {
                    return this.root.generalizeDouble(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(ArrayGeneralizeNodeGen root, Object requiredCapacityValue) {
            return new GeneralizeDoubleNode_(root, requiredCapacityValue);
        }
    }

    @GeneratedBy(methodName="generalizeLong(DynamicObject, int)", value=ArrayGeneralizeNode.class)
    private static final class GeneralizeLongNode_
    extends BaseNode_ {
        private final Class<?> requiredCapacityImplicitType;

        GeneralizeLongNode_(ArrayGeneralizeNodeGen root, Object requiredCapacityValue) {
            super(root, 3);
            this.requiredCapacityImplicitType = RubyTypesGen.getImplicitIntegerClass(requiredCapacityValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.requiredCapacityImplicitType == ((GeneralizeLongNode_)other).requiredCapacityImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            return this.executeDynamicObject(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), requiredCapacityValue);
            }
            try {
                if (this.requiredCapacityImplicitType == Integer.TYPE) {
                    requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
                } else {
                    Object requiredCapacityValue__ = this.executeRequiredCapacity_(frameValue);
                    requiredCapacityValue_ = RubyTypesGen.expectImplicitInteger(requiredCapacityValue__, this.requiredCapacityImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult());
            }
            if (ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.generalizeLong(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int requiredCapacityValue) {
            if (ArrayGuards.isLongArray(arrayValue)) {
                return this.root.generalizeLong(arrayValue, requiredCapacityValue);
            }
            return this.getNext().execute1(arrayValue, requiredCapacityValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = RubyTypesGen.asImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType);
                if (ArrayGuards.isLongArray(arrayValue_)) {
                    return this.root.generalizeLong(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(ArrayGeneralizeNodeGen root, Object requiredCapacityValue) {
            return new GeneralizeLongNode_(root, requiredCapacityValue);
        }
    }

    @GeneratedBy(methodName="generalizeInt(DynamicObject, int)", value=ArrayGeneralizeNode.class)
    private static final class GeneralizeIntNode_
    extends BaseNode_ {
        private final Class<?> requiredCapacityImplicitType;

        GeneralizeIntNode_(ArrayGeneralizeNodeGen root, Object requiredCapacityValue) {
            super(root, 2);
            this.requiredCapacityImplicitType = RubyTypesGen.getImplicitIntegerClass(requiredCapacityValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.requiredCapacityImplicitType == ((GeneralizeIntNode_)other).requiredCapacityImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            return this.executeDynamicObject(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), requiredCapacityValue);
            }
            try {
                if (this.requiredCapacityImplicitType == Integer.TYPE) {
                    requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
                } else {
                    Object requiredCapacityValue__ = this.executeRequiredCapacity_(frameValue);
                    requiredCapacityValue_ = RubyTypesGen.expectImplicitInteger(requiredCapacityValue__, this.requiredCapacityImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult());
            }
            if (ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.generalizeInt(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int requiredCapacityValue) {
            if (ArrayGuards.isIntArray(arrayValue)) {
                return this.root.generalizeInt(arrayValue, requiredCapacityValue);
            }
            return this.getNext().execute1(arrayValue, requiredCapacityValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = RubyTypesGen.asImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType);
                if (ArrayGuards.isIntArray(arrayValue_)) {
                    return this.root.generalizeInt(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(ArrayGeneralizeNodeGen root, Object requiredCapacityValue) {
            return new GeneralizeIntNode_(root, requiredCapacityValue);
        }
    }

    @GeneratedBy(methodName="generalizeNull(DynamicObject, int)", value=ArrayGeneralizeNode.class)
    private static final class GeneralizeNullNode_
    extends BaseNode_ {
        private final Class<?> requiredCapacityImplicitType;

        GeneralizeNullNode_(ArrayGeneralizeNodeGen root, Object requiredCapacityValue) {
            super(root, 1);
            this.requiredCapacityImplicitType = RubyTypesGen.getImplicitIntegerClass(requiredCapacityValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.requiredCapacityImplicitType == ((GeneralizeNullNode_)other).requiredCapacityImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            return this.executeDynamicObject(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_(frameValue);
                return this.getNext().executeDynamicObject_(ex.getResult(), requiredCapacityValue);
            }
            try {
                if (this.requiredCapacityImplicitType == Integer.TYPE) {
                    requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
                } else {
                    Object requiredCapacityValue__ = this.executeRequiredCapacity_(frameValue);
                    requiredCapacityValue_ = RubyTypesGen.expectImplicitInteger(requiredCapacityValue__, this.requiredCapacityImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject_(arrayValue_, ex.getResult());
            }
            if (ArrayGuards.isNullArray(arrayValue_)) {
                return this.root.generalizeNull(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeDynamicObject_(arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int requiredCapacityValue) {
            if (ArrayGuards.isNullArray(arrayValue)) {
                return this.root.generalizeNull(arrayValue, requiredCapacityValue);
            }
            return this.getNext().execute1(arrayValue, requiredCapacityValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = RubyTypesGen.asImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType);
                if (ArrayGuards.isNullArray(arrayValue_)) {
                    return this.root.generalizeNull(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeDynamicObject_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(ArrayGeneralizeNodeGen root, Object requiredCapacityValue) {
            return new GeneralizeNullNode_(root, requiredCapacityValue);
        }
    }

    @GeneratedBy(value=ArrayGeneralizeNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayGeneralizeNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object requiredCapacityValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, requiredCapacityValue));
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object requiredCapacityValue) {
            return this.getNext().executeDynamicObject_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(ArrayGeneralizeNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayGeneralizeNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayGeneralizeNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public DynamicObject executeDynamicObject_(Object arrayValue, Object requiredCapacityValue) {
            return (DynamicObject)this.uninitialized((Frame)null, arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(ArrayGeneralizeNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayGeneralizeNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayGeneralizeNodeGen root;

        BaseNode_(ArrayGeneralizeNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ArrayGeneralizeNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.requiredCapacity_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object requiredCapacityValue) {
            return this.executeDynamicObject_(arrayValue, requiredCapacityValue);
        }

        public abstract DynamicObject executeDynamicObject_(Object var1, Object var2);

        public Object execute1(DynamicObject arrayValue, int requiredCapacityValue) {
            return this.executeDynamicObject_(arrayValue, requiredCapacityValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object requiredCapacityValue_ = this.executeRequiredCapacity_(frameValue);
            return this.executeDynamicObject_(arrayValue_, requiredCapacityValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
            return (DynamicObject)this.execute0(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(requiredCapacityValue)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                if (ArrayGuards.isNullArray(arrayValue_)) {
                    return GeneralizeNullNode_.create(this.root, requiredCapacityValue);
                }
                if (ArrayGuards.isIntArray(arrayValue_)) {
                    return GeneralizeIntNode_.create(this.root, requiredCapacityValue);
                }
                if (ArrayGuards.isLongArray(arrayValue_)) {
                    return GeneralizeLongNode_.create(this.root, requiredCapacityValue);
                }
                if (ArrayGuards.isDoubleArray(arrayValue_)) {
                    return GeneralizeDoubleNode_.create(this.root, requiredCapacityValue);
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeRequiredCapacity_(Frame frameValue) {
            Object object;
            Class requiredCapacityType_ = this.root.requiredCapacityType_;
            if (requiredCapacityType_ == Integer.TYPE) {
                return this.root.requiredCapacity_.executeInteger((VirtualFrame)frameValue);
            }
            if (requiredCapacityType_ != null) return this.root.requiredCapacity_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.requiredCapacity_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.requiredCapacityType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.requiredCapacityType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.requiredCapacityType_ = _type;
            return object;
        }
    }
}

