// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var ACCTYPES, ArgumentParser, Base, C, Command, CryptocurrencySigGen, E, PackageJson, S, ST, User, add_option_dict, assert, bitcoyne, dict_union, fs, iced, log, make_esc, prompt_remote_name, prompt_yn, proofs, req, session, util, __iced_k, __iced_k_noop, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  Base = require('./base').Base;

  log = require('../log');

  ArgumentParser = require('argparse').ArgumentParser;

  add_option_dict = require('./argparse').add_option_dict;

  C = require('../constants').constants;

  ST = C.signature_types;

  ACCTYPES = C.allowed_cryptocurrency_types;

  PackageJson = require('../package').PackageJson;

  E = require('../err').E;

  make_esc = require('iced-error').make_esc;

  _ref = require('../prompter'), prompt_yn = _ref.prompt_yn, prompt_remote_name = _ref.prompt_remote_name;

  User = require('../user').User;

  req = require('../req').req;

  assert = require('assert');

  session = require('../session');

  S = require('../services');

  dict_union = require('../util').dict_union;

  util = require('util');

  fs = require('fs');

  proofs = require('keybase-proofs');

  bitcoyne = require('bitcoyne');

  CryptocurrencySigGen = require('../sigs').CryptocurrencySigGen;

  exports.Command = Command = (function(_super) {
    __extends(Command, _super);

    function Command() {
      return Command.__super__.constructor.apply(this, arguments);
    }

    Command.prototype.OPTS = {
      f: {
        alias: 'force',
        action: 'storeTrue',
        help: 'force overwrite, revoking any old addresses'
      }
    };

    Command.prototype.use_session = function() {
      return true;
    };

    Command.prototype.needs_configuration = function() {
      return true;
    };

    Command.prototype.add_subcommand_parser = function(scp) {
      var name, opts, sub;
      opts = {
        aliases: ['bitcoin'],
        help: "add a signed cryptocurrency address to your profile"
      };
      name = "btc";
      sub = scp.addParser(name, opts);
      add_option_dict(sub, this.OPTS);
      sub.addArgument(["btc"], {
        nargs: 1,
        help: "the address to sign and publicly post"
      });
      return opts.aliases.concat([name]);
    };

    Command.prototype.parse_args = function(cb) {
      var err, ret, _ref1, _ref2;
      _ref1 = bitcoyne.address.check(this.argv.btc[0]), err = _ref1[0], ret = _ref1[1];
      if (err != null) {
        err = new E.BadCryptocurrencyAddressError("Bad BTC address: " + err.message);
      } else if ((ret != null ? ret.version : void 0) == null) {
        err = new E.BadCryptocurrencyAddressError("Bad BTC address; no type found");
      } else if (!(_ref2 = ret.version, __indexOf.call(ACCTYPES, _ref2) >= 0)) {
        err = new E.UnsupportedCryptocurrencyAddressError("Only support bitcoin addresses at current");
      } else {
        this.address_version = ret.version;
      }
      return cb(err);
    };

    Command.prototype.check_exists = function(cb) {
      var address_types, addresses, c, err, link, links, m, ok, prompt, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref1, _ref2;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      address_types = ((_ref1 = this.me.sig_chain) != null ? (_ref2 = _ref1.table) != null ? _ref2.get(ST.CRYPTOCURRENCY) : void 0 : void 0) || null;
      links = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = ACCTYPES.length; _i < _len; _i++) {
          c = ACCTYPES[_i];
          if ((link = address_types != null ? address_types.get(c) : void 0) != null) {
            _results.push(link);
          }
        }
        return _results;
      })();
      addresses = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = links.length; _i < _len; _i++) {
          link = links[_i];
          _results.push(link.body().cryptocurrency.address);
        }
        return _results;
      })();
      (function(_this) {
        return (function(__iced_k) {
          if (!addresses.length) {
            return __iced_k(err = null);
          } else {
            (function(__iced_k) {
              var _ref3;
              if (_ref3 = _this.argv.btc[0], __indexOf.call(addresses, _ref3) >= 0) {
                return __iced_k(err = new E.DuplicateError("you've already signed BTC address '" + _this.argv.btc[0] + "'"));
              } else {
                (function(__iced_k) {
                  if (!_this.argv.force) {
                    if (addresses.length === 1) {
                      prompt = "You already have registered address " + addresses[0] + "; revoke and proceed?";
                    } else {
                      prompt = "You already have registered addresses [" + (addresses.join(',')) + "]; revoke and proceed?";
                    }
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/home/max/src/keybase/node-client/src/command/btc.iced",
                        funcname: "Command.check_exists"
                      });
                      prompt_yn({
                        prompt: prompt,
                        defval: false
                      }, __iced_deferrals.defer({
                        assign_fn: (function() {
                          return function() {
                            err = arguments[0];
                            return ok = arguments[1];
                          };
                        })(),
                        lineno: 81
                      }));
                      __iced_deferrals._fulfill();
                    })(function() {
                      return __iced_k(err != null ? void 0 : !ok ? (m = addresses.length === 1 ? 'Address already exists' : "Addresses already exist", err = new E.ProofExistsError(m)) : void 0);
                    });
                  } else {
                    return __iced_k();
                  }
                })(__iced_k);
              }
            })(__iced_k);
          }
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err === "undefined" || err === null) {
            _this.revoke_sig_ids = (function() {
              var _i, _len, _results;
              _results = [];
              for (_i = 0, _len = links.length; _i < _len; _i++) {
                link = links[_i];
                _results.push(link.sig_id());
              }
              return _results;
            })();
          }
          return cb(err);
        };
      })(this));
    };

    Command.prototype.allocate_proof_gen = function(cb) {
      var arg, cryptocurrency, err, klass, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      klass = CryptocurrencySigGen;
      cryptocurrency = {
        address: this.argv.btc[0],
        type: 'bitcoin'
      };
      arg = {
        revoke_sig_ids: this.revoke_sig_ids,
        cryptocurrency: cryptocurrency
      };
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/command/btc.iced",
            funcname: "Command.allocate_proof_gen"
          });
          _this.me.gen_sig_base({
            klass: klass,
            arg: arg
          }, __iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                return __slot_1.gen = arguments[1];
              };
            })(_this),
            lineno: 100
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    Command.prototype.run = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Command::run");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/node-client/src/command/btc.iced",
            funcname: "Command.run"
          });
          _this.parse_args(esc(__iced_deferrals.defer({
            lineno: 107
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/home/max/src/keybase/node-client/src/command/btc.iced",
              funcname: "Command.run"
            });
            session.login(esc(__iced_deferrals.defer({
              lineno: 108
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/home/max/src/keybase/node-client/src/command/btc.iced",
                funcname: "Command.run"
              });
              User.load_me({
                secret: true
              }, esc(__iced_deferrals.defer({
                assign_fn: (function(__slot_1) {
                  return function() {
                    return __slot_1.me = arguments[0];
                  };
                })(_this),
                lineno: 109
              })));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/home/max/src/keybase/node-client/src/command/btc.iced",
                  funcname: "Command.run"
                });
                _this.check_exists(esc(__iced_deferrals.defer({
                  lineno: 110
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/home/max/src/keybase/node-client/src/command/btc.iced",
                    funcname: "Command.run"
                  });
                  _this.allocate_proof_gen(esc(__iced_deferrals.defer({
                    lineno: 111
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/home/max/src/keybase/node-client/src/command/btc.iced",
                      funcname: "Command.run"
                    });
                    _this.gen.run(esc(__iced_deferrals.defer({
                      lineno: 112
                    })));
                    __iced_deferrals._fulfill();
                  })(function() {
                    log.info("Success!");
                    return cb(null);
                  });
                });
              });
            });
          });
        };
      })(this));
    };

    return Command;

  })(Base);

}).call(this);
