/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.Arrays;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;

public class AnalyzedTokenReadingsTest
extends TestCase {
    public void testNewTags() {
        AnalyzedTokenReadings tokenReadings = new AnalyzedTokenReadings(new AnalyzedToken("word", "POS", "lemma"));
        AnalyzedTokenReadingsTest.assertEquals((boolean)false, (boolean)tokenReadings.isLinebreak());
        AnalyzedTokenReadingsTest.assertEquals((boolean)false, (boolean)tokenReadings.isSentenceEnd());
        AnalyzedTokenReadingsTest.assertEquals((boolean)false, (boolean)tokenReadings.isParagraphEnd());
        AnalyzedTokenReadingsTest.assertEquals((boolean)false, (boolean)tokenReadings.isSentenceStart());
        tokenReadings.setSentEnd();
        AnalyzedTokenReadingsTest.assertEquals((boolean)false, (boolean)tokenReadings.isSentenceStart());
        AnalyzedTokenReadingsTest.assertEquals((boolean)true, (boolean)tokenReadings.isSentenceEnd());
        tokenReadings = new AnalyzedTokenReadings(new AnalyzedToken("word", null, "lemma"));
        tokenReadings.addReading(new AnalyzedToken("word", "SENT_END", null));
        AnalyzedTokenReadingsTest.assertEquals((boolean)true, (boolean)tokenReadings.isSentenceEnd());
        AnalyzedTokenReadingsTest.assertEquals((boolean)false, (boolean)tokenReadings.isParagraphEnd());
        tokenReadings.addReading(new AnalyzedToken("word", "PARA_END", null));
        AnalyzedTokenReadingsTest.assertEquals((boolean)true, (boolean)tokenReadings.isParagraphEnd());
        AnalyzedTokenReadingsTest.assertEquals((boolean)false, (boolean)tokenReadings.isSentenceStart());
        tokenReadings.addReading(new AnalyzedToken("word", "SENT_START", null));
        AnalyzedTokenReadingsTest.assertEquals((boolean)false, (boolean)tokenReadings.isSentenceStart());
        AnalyzedToken aTok = new AnalyzedToken("word", "POS", "lemma");
        aTok.setWhitespaceBefore(true);
        tokenReadings = new AnalyzedTokenReadings(aTok);
        AnalyzedTokenReadingsTest.assertEquals((Object)aTok, (Object)tokenReadings.getAnalyzedToken(0));
        AnalyzedToken aTok2 = new AnalyzedToken("word", "POS", "lemma");
        AnalyzedTokenReadingsTest.assertTrue((!aTok2.equals((Object)tokenReadings.getAnalyzedToken(0)) ? 1 : 0) != 0);
        AnalyzedToken aTok3 = new AnalyzedToken("word", "POS", "lemma");
        aTok3.setWhitespaceBefore(true);
        AnalyzedTokenReadingsTest.assertEquals((Object)aTok3, (Object)tokenReadings.getAnalyzedToken(0));
        AnalyzedTokenReadings testReadings = new AnalyzedTokenReadings(aTok3);
        testReadings.removeReading(aTok3);
        AnalyzedTokenReadingsTest.assertTrue((testReadings.getReadingsLength() == 1 ? 1 : 0) != 0);
        AnalyzedTokenReadingsTest.assertEquals((String)"word", (String)testReadings.getToken());
        AnalyzedTokenReadingsTest.assertTrue((!testReadings.hasPosTag("POS") ? 1 : 0) != 0);
        testReadings.leaveReading(aTok2);
        AnalyzedTokenReadingsTest.assertEquals((String)"word", (String)testReadings.getToken());
        AnalyzedTokenReadingsTest.assertTrue((!testReadings.hasPosTag("POS") ? 1 : 0) != 0);
        testReadings.removeReading(aTok2);
        AnalyzedTokenReadingsTest.assertEquals((String)"word", (String)testReadings.getToken());
        AnalyzedTokenReadingsTest.assertTrue((!testReadings.hasPosTag("POS") ? 1 : 0) != 0);
    }

    public void testToString() {
        AnalyzedTokenReadings tokenReadings = new AnalyzedTokenReadings(new AnalyzedToken("word", "POS", "lemma"));
        AnalyzedTokenReadingsTest.assertEquals((String)"word[lemma/POS*]", (String)tokenReadings.toString());
        AnalyzedToken aTok2 = new AnalyzedToken("word", "POS2", "lemma2");
        tokenReadings.addReading(aTok2);
        AnalyzedTokenReadingsTest.assertEquals((String)"word[lemma/POS*,lemma2/POS2*]", (String)tokenReadings.toString());
    }

    public void testHasPosTag() {
        AnalyzedTokenReadings tokenReadings = new AnalyzedTokenReadings(new AnalyzedToken("word", "POS:FOO:BAR", "lemma"));
        AnalyzedTokenReadingsTest.assertTrue((boolean)tokenReadings.hasPosTag("POS:FOO:BAR"));
        AnalyzedTokenReadingsTest.assertFalse((boolean)tokenReadings.hasPosTag("POS:FOO:bar"));
        AnalyzedTokenReadingsTest.assertFalse((boolean)tokenReadings.hasPosTag("POS:FOO"));
        AnalyzedTokenReadingsTest.assertFalse((boolean)tokenReadings.hasPosTag("xaz"));
    }

    public void testHasPartialPosTag() {
        AnalyzedTokenReadings tokenReadings = new AnalyzedTokenReadings(new AnalyzedToken("word", "POS:FOO:BAR", "lemma"));
        AnalyzedTokenReadingsTest.assertTrue((boolean)tokenReadings.hasPartialPosTag("POS:FOO:BAR"));
        AnalyzedTokenReadingsTest.assertTrue((boolean)tokenReadings.hasPartialPosTag("POS:FOO:"));
        AnalyzedTokenReadingsTest.assertTrue((boolean)tokenReadings.hasPartialPosTag("POS:FOO"));
        AnalyzedTokenReadingsTest.assertTrue((boolean)tokenReadings.hasPartialPosTag(":FOO:"));
        AnalyzedTokenReadingsTest.assertTrue((boolean)tokenReadings.hasPartialPosTag("FOO:BAR"));
        AnalyzedTokenReadingsTest.assertFalse((boolean)tokenReadings.hasPartialPosTag("POS:FOO:BARX"));
        AnalyzedTokenReadingsTest.assertFalse((boolean)tokenReadings.hasPartialPosTag("POS:foo:BAR"));
        AnalyzedTokenReadingsTest.assertFalse((boolean)tokenReadings.hasPartialPosTag("xaz"));
    }

    public void testMatchesPosTagRegex() {
        AnalyzedTokenReadings tokenReadings = new AnalyzedTokenReadings(new AnalyzedToken("word", "POS:FOO:BAR", "lemma"));
        AnalyzedTokenReadingsTest.assertTrue((boolean)tokenReadings.matchesPosTagRegex("POS:FOO:BAR"));
        AnalyzedTokenReadingsTest.assertTrue((boolean)tokenReadings.matchesPosTagRegex("POS:...:BAR"));
        AnalyzedTokenReadingsTest.assertTrue((boolean)tokenReadings.matchesPosTagRegex("POS:[A-Z]+:BAR"));
        AnalyzedTokenReadingsTest.assertFalse((boolean)tokenReadings.matchesPosTagRegex("POS:[AB]OO:BAR"));
        AnalyzedTokenReadingsTest.assertFalse((boolean)tokenReadings.matchesPosTagRegex("POS:FOO:BARX"));
    }

    public void testIteration() {
        AnalyzedTokenReadings tokenReadings = new AnalyzedTokenReadings(Arrays.asList(new AnalyzedToken("word1", null, null), new AnalyzedToken("word2", null, null)), 0);
        int i = 0;
        for (AnalyzedToken tokenReading : tokenReadings) {
            if (i == 0) {
                Assert.assertThat((Object)tokenReading.getToken(), (Matcher)CoreMatchers.is((Object)"word1"));
            } else if (i == 1) {
                Assert.assertThat((Object)tokenReading.getToken(), (Matcher)CoreMatchers.is((Object)"word2"));
            } else {
                AnalyzedTokenReadingsTest.fail();
            }
            ++i;
        }
    }
}

