/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.bitext;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import junit.framework.TestCase;
import org.languagetool.bitext.StringPair;
import org.languagetool.bitext.WordFastTMReader;

public class WordFastTMReaderTest
extends TestCase {
    public void testReader() throws Exception {
        File input = File.createTempFile("input", ".txt");
        input.deleteOnExit();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(input), "UTF-8"));
        writer.println("%20100801~111517\t%UserID,AHLJat,AHLJat\t%TU=00008580\t%EN-US\t%Wordfast TM v.546/00\t%PL-PL\t%\t.");
        writer.println("20100727~145333\tAHLJat\t2\tEN-US\tObjection:\tPL-PL\tZarzut: ");
        writer.println("20100727~051350\tAHLJat\t2\tEN-US\tWhy not?&tA;\tPL-PL\tDlaczego nie?&tA; ");
        writer.close();
        WordFastTMReader reader = new WordFastTMReader(input.getAbsolutePath(), "UTF-8");
        int i = 1;
        for (StringPair srcAndTrg : reader) {
            WordFastTMReaderTest.assertTrue((srcAndTrg.getSource() != null ? 1 : 0) != 0);
            WordFastTMReaderTest.assertTrue((srcAndTrg.getTarget() != null ? 1 : 0) != 0);
            if (i == 1) {
                WordFastTMReaderTest.assertEquals((String)"Objection:", (String)srcAndTrg.getSource());
            } else if (i == 2) {
                WordFastTMReaderTest.assertEquals((String)"Why not?&tA;", (String)srcAndTrg.getSource());
            }
            ++i;
        }
    }
}

