/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam;

import java.awt.SplashScreen;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Application;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.pdfsam.ConfigurableProperty;
import org.pdfsam.Pdfsam;
import org.pdfsam.UncaughtExceptionLogger;
import org.pdfsam.WindowStatusController;
import org.pdfsam.configuration.ApplicationContextHolder;
import org.pdfsam.configuration.StylesConfig;
import org.pdfsam.context.DefaultUserContext;
import org.pdfsam.context.UserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.i18n.SetLocaleEvent;
import org.pdfsam.news.FetchLatestNewsRequest;
import org.pdfsam.news.NewsService;
import org.pdfsam.ui.MainPane;
import org.pdfsam.ui.SetLatestStageStatusRequest;
import org.pdfsam.ui.StageMode;
import org.pdfsam.ui.StageService;
import org.pdfsam.ui.StageStatus;
import org.pdfsam.ui.commons.OpenUrlRequest;
import org.pdfsam.ui.commons.ShowStageRequest;
import org.pdfsam.ui.dialog.OverwriteConfirmationDialog;
import org.pdfsam.ui.event.SetActiveModuleRequest;
import org.pdfsam.ui.io.SetLatestDirectoryEvent;
import org.pdfsam.ui.log.LogMessageBroadcaster;
import org.pdfsam.ui.notification.NotificationsContainer;
import org.pdfsam.ui.workspace.LoadWorkspaceEvent;
import org.pdfsam.update.UpdateCheckRequest;
import org.sejda.core.Sejda;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfsamApp
extends Application {
    private static final Logger LOG = LoggerFactory.getLogger(PdfsamApp.class);
    private static StopWatch STOPWATCH = new StopWatch();
    private Stage primaryStage;

    public void init() {
        String defaultworkingPath;
        STOPWATCH.start();
        DefaultUserContext userContext = new DefaultUserContext();
        System.setProperty("eventstudio.max.queue.size", Integer.toString(userContext.getNumberOfLogRows()));
        LOG.info("Starting PDFsam");
        this.cleanUserContextIfNeeded(userContext);
        String localeString = userContext.getLocale();
        if (StringUtils.isNotBlank(localeString)) {
            StaticStudio.eventStudio().broadcast(new SetLocaleEvent(localeString));
        }
        if (StringUtils.isNotBlank(defaultworkingPath = userContext.getDefaultWorkingPath())) {
            try {
                if (Files.isDirectory(Paths.get(defaultworkingPath, new String[0]), new LinkOption[0])) {
                    StaticStudio.eventStudio().broadcast(new SetLatestDirectoryEvent(new File(defaultworkingPath)));
                }
            }
            catch (InvalidPathException e) {
                LOG.warn("Unable to set initial directory, default path is invalid.", e);
            }
        }
    }

    private void cleanUserContextIfNeeded(UserContext userContext) {
        if (this.getParameters().getRaw().contains("-clean")) {
            userContext.clear();
            LOG.info("Cleared user preferences");
        }
    }

    public void start(Stage primaryStage) {
        this.primaryStage = primaryStage;
        ApplicationContextHolder.getContext();
        this.startLogAppender();
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionLogger());
        this.initSejda();
        this.cleanIfNeeded();
        primaryStage.setScene(this.initScene());
        primaryStage.getIcons().addAll(ApplicationContextHolder.getContext().getBeansOfType(Image.class).values());
        primaryStage.setTitle(ApplicationContextHolder.getContext().getBean(Pdfsam.class).name());
        primaryStage.setOnCloseRequest(e -> Platform.exit());
        this.initWindowsStatusController(primaryStage);
        this.initOverwriteDialogController(primaryStage);
        this.initActiveModule();
        this.loadWorkspaceIfRequired();
        primaryStage.show();
        PdfsamApp.requestCheckForUpdateIfNecessary();
        PdfsamApp.requestLatestNews();
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
        this.closeSplash();
        STOPWATCH.stop();
        LOG.info(DefaultI18nContext.getInstance().i18n("Started in {0}", DurationFormatUtils.formatDurationWords(STOPWATCH.getTime(), true, true)));
    }

    private void initSejda() {
        Pdfsam pdfsam = ApplicationContextHolder.getContext().getBean(Pdfsam.class);
        Sejda.CREATOR = pdfsam.shortName() + " v" + pdfsam.property(ConfigurableProperty.VERSION);
        System.setProperty("sejda.unethical.read", "true");
    }

    private void startLogAppender() {
        LogMessageBroadcaster broadcaster = ApplicationContextHolder.getContext().getBean(LogMessageBroadcaster.class);
        broadcaster.start();
    }

    private void closeSplash() {
        Optional.ofNullable(SplashScreen.getSplashScreen()).ifPresent(SplashScreen::close);
    }

    private Scene initScene() {
        MainPane mainPane = ApplicationContextHolder.getContext().getBean(MainPane.class);
        NotificationsContainer notifications = ApplicationContextHolder.getContext().getBean(NotificationsContainer.class);
        StackPane main = new StackPane();
        StackPane.setAlignment((Node)notifications, (Pos)Pos.BOTTOM_RIGHT);
        StackPane.setAlignment((Node)mainPane, (Pos)Pos.TOP_LEFT);
        main.getChildren().addAll((Object[])new Node[]{mainPane, notifications});
        StylesConfig styles = ApplicationContextHolder.getContext().getBean(StylesConfig.class);
        Scene mainScene = new Scene((Parent)main);
        mainScene.getStylesheets().addAll(styles.styles());
        mainScene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.L, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), () -> StaticStudio.eventStudio().broadcast(new ShowStageRequest(), "LogStage"));
        return mainScene;
    }

    public void stop() {
        LOG.info(DefaultI18nContext.getInstance().i18n("Closing PDFsam..."));
        if (Objects.nonNull(this.primaryStage)) {
            StageStatus status = new StageStatus(this.primaryStage.getX(), this.primaryStage.getY(), this.primaryStage.getWidth(), this.primaryStage.getHeight());
            status.setMode(StageMode.valueFor(this.primaryStage));
            StaticStudio.eventStudio().broadcast(new SetLatestStageStatusRequest(status));
        }
        ApplicationContextHolder.getContext().close();
    }

    private static void requestCheckForUpdateIfNecessary() {
        if (ApplicationContextHolder.getContext().getBean(UserContext.class).isCheckForUpdates()) {
            StaticStudio.eventStudio().broadcast(new UpdateCheckRequest());
        }
    }

    private void cleanIfNeeded() {
        if (this.getParameters().getRaw().contains("-clean")) {
            ApplicationContextHolder.getContext().getBean(NewsService.class).clear();
            ApplicationContextHolder.getContext().getBean(StageService.class).clear();
        }
    }

    private static void requestLatestNews() {
        StaticStudio.eventStudio().broadcast(FetchLatestNewsRequest.INSTANCE);
    }

    @EventListener
    public void openUrl(OpenUrlRequest event) {
        HostServices services = this.getHostServices();
        if (services != null) {
            services.showDocument(event.getUrl());
        } else {
            LOG.warn("Unable to open '{}', please copy and paste the url to your browser.", (Object)event.getUrl());
        }
    }

    private void initOverwriteDialogController(Stage primaryStage) {
        OverwriteConfirmationDialog overwriteDialog = ApplicationContextHolder.getContext().getBean(OverwriteConfirmationDialog.class);
        overwriteDialog.setOwner((Window)primaryStage);
    }

    private void initWindowsStatusController(Stage primaryStage) {
        WindowStatusController stageStatusController = ApplicationContextHolder.getContext().getBean(WindowStatusController.class);
        stageStatusController.setStage(primaryStage);
    }

    private void initActiveModule() {
        String startupModule = new DefaultUserContext().getStartupModule();
        if (StringUtils.isNotBlank(startupModule)) {
            LOG.trace("Activating startup module '{}'", (Object)startupModule);
            StaticStudio.eventStudio().broadcast(SetActiveModuleRequest.activeteModule(startupModule));
        }
    }

    private void loadWorkspaceIfRequired() {
        String workspace = new DefaultUserContext().getDefaultWorkspacePath();
        if (StringUtils.isNotBlank(workspace) && Files.exists(Paths.get(workspace, new String[0]), new LinkOption[0])) {
            StaticStudio.eventStudio().broadcast(new LoadWorkspaceEvent(new File(workspace)));
        }
    }
}

