/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.alternatemix;

import org.pdfsam.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.support.params.SingleOutputTaskParametersBuilder;
import org.sejda.model.input.PdfFileSource;
import org.sejda.model.input.PdfMixInput;
import org.sejda.model.output.FileTaskOutput;
import org.sejda.model.parameter.AlternateMixParameters;

class AlternateMixParametersBuilder
extends AbstractPdfOutputParametersBuilder<AlternateMixParameters>
implements SingleOutputTaskParametersBuilder<AlternateMixParameters> {
    private FileTaskOutput output;
    private PdfFileSource firstSource;
    private PdfFileSource secondSource;
    private boolean reverseFirst;
    private boolean reverseSecond;
    private int stepFirst = 1;
    private int stepSecond = 1;

    AlternateMixParametersBuilder() {
    }

    @Override
    public void output(FileTaskOutput output) {
        this.output = output;
    }

    AlternateMixParametersBuilder first(PdfFileSource firstSource) {
        this.firstSource = firstSource;
        return this;
    }

    AlternateMixParametersBuilder second(PdfFileSource secondSource) {
        this.secondSource = secondSource;
        return this;
    }

    AlternateMixParametersBuilder reverseFirst(boolean reverseFirst) {
        this.reverseFirst = reverseFirst;
        return this;
    }

    AlternateMixParametersBuilder reverseSecond(boolean reverseSecond) {
        this.reverseSecond = reverseSecond;
        return this;
    }

    AlternateMixParametersBuilder stepFirst(int stepFirst) {
        this.stepFirst = stepFirst;
        return this;
    }

    AlternateMixParametersBuilder stepSecond(int stepSecond) {
        this.stepSecond = stepSecond;
        return this;
    }

    @Override
    public AlternateMixParameters build() {
        PdfMixInput firstInput = new PdfMixInput(this.firstSource, this.reverseFirst, this.stepFirst);
        PdfMixInput secondInput = new PdfMixInput(this.secondSource, this.reverseSecond, this.stepSecond);
        AlternateMixParameters params = new AlternateMixParameters(firstInput, secondInput);
        params.setCompress(this.isCompress());
        params.setExistingOutputPolicy(this.existingOutput());
        params.setVersion(this.getVersion());
        params.setOutput(this.output);
        return params;
    }
}

