/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.context;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.context.BooleanUserPreference;
import org.pdfsam.context.IntUserPreference;
import org.pdfsam.context.StringUserPreference;
import org.pdfsam.context.UserContext;
import org.pdfsam.ui.Theme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultUserContext
implements UserContext {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUserContext.class);
    static final String CHECK_FOR_UPDATES_PROP = "org.pdfsam.default.checkforupdate";
    static final String LOCALE_PROP = "org.pdfsam.default.locale";
    private Preferences prefs;

    public DefaultUserContext() {
        this.initNode();
    }

    private void initNode() {
        this.prefs = Preferences.userRoot().node("/org/pdfsam/user/conf");
    }

    @Override
    public String getDefaultWorkspacePath() {
        return this.prefs.get(StringUserPreference.WORKSPACE_PATH.toString(), "");
    }

    @Override
    public String getDefaultWorkingPath() {
        return this.prefs.get(StringUserPreference.WORKING_PATH.toString(), "");
    }

    @Override
    public boolean isPlaySounds() {
        return this.prefs.getBoolean(BooleanUserPreference.PLAY_SOUNDS.toString(), Boolean.TRUE);
    }

    @Override
    public boolean isUseSmartOutput() {
        return this.prefs.getBoolean(BooleanUserPreference.SMART_OUTPUT.toString(), Boolean.TRUE);
    }

    @Override
    public int getThumbnailsSize() {
        return this.prefs.getInt(IntUserPreference.THUMBNAILS_SIZE.toString(), 190);
    }

    @Override
    public int getNumberOfLogRows() {
        return this.prefs.getInt(IntUserPreference.LOGVIEW_ROWS_NUMBER.toString(), 200);
    }

    @Override
    public String getTheme() {
        return StringUtils.defaultIfBlank(this.prefs.get(StringUserPreference.THEME.toString(), ""), Theme.ROUNDISH.toString());
    }

    @Override
    public String getStartupModule() {
        return this.prefs.get(StringUserPreference.STARTUP_MODULE.toString(), "");
    }

    @Override
    public String getThumbnailsCreatorIdentifier() {
        return this.prefs.get(StringUserPreference.THUMBNAILS_IDENTIFIER.toString(), "");
    }

    @Override
    public boolean isCheckForUpdates() {
        return this.prefs.getBoolean(BooleanUserPreference.CHECK_UPDATES.toString(), Boolean.valueOf(System.getProperty(CHECK_FOR_UPDATES_PROP, Boolean.TRUE.toString())));
    }

    @Override
    public boolean isHighQualityThumbnails() {
        return this.prefs.getBoolean(BooleanUserPreference.HIGH_QUALITY_THUMB.toString(), Boolean.FALSE);
    }

    @Override
    public String getLocale() {
        return this.prefs.get(StringUserPreference.LOCALE.toString(), System.getProperty(LOCALE_PROP));
    }

    @Override
    public void clear() {
        try {
            this.prefs.removeNode();
            this.prefs.flush();
            this.initNode();
        }
        catch (BackingStoreException e) {
            LOG.error("Unable to clear user preferences", e);
        }
    }

    @Override
    public void setBooleanPreference(BooleanUserPreference pref, boolean value) {
        this.prefs.putBoolean(pref.toString(), value);
    }

    @Override
    public void setIntegerPreference(IntUserPreference pref, int value) {
        this.prefs.putInt(pref.toString(), value);
    }

    @Override
    public void setStringPreference(StringUserPreference pref, String value) {
        this.prefs.put(pref.toString(), value);
    }
}

