/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.preference;

import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.ui.dashboard.preference.ClearStatisticsButton;
import org.pdfsam.ui.dashboard.preference.PreferenceBrowsableDirectoryField;
import org.pdfsam.ui.dashboard.preference.PreferenceBrowsableFileField;
import org.pdfsam.ui.support.Style;

@Named
class PreferenceWorkspacePane
extends VBox {
    @Inject
    public PreferenceWorkspacePane(@Named(value="workingDirectory") PreferenceBrowsableDirectoryField workingDirectory, @Named(value="workspace") PreferenceBrowsableFileField workspace, ClearStatisticsButton clearStatsButton) {
        I18nContext i18n = DefaultI18nContext.getInstance();
        workspace.getTextField().setPromptText(i18n.i18n("Select a previously saved workspace that will be automatically loaded at startup"));
        workspace.getTextField().setTooltip(new Tooltip(i18n.i18n("Select a previously saved workspace that will be automatically loaded at startup")));
        workspace.setBrowseWindowTitle(i18n.i18n("Select a workspace"));
        workspace.getStyleClass().add((Object)"spaced-vitem");
        workingDirectory.getTextField().setPromptText(i18n.i18n("Select a directory where documents will be saved and loaded by default"));
        workingDirectory.getTextField().setTooltip(new Tooltip(i18n.i18n("Select a directory where documents will be saved and loaded by default")));
        workingDirectory.setBrowseWindowTitle(i18n.i18n("Select a directory"));
        workingDirectory.getStyleClass().add((Object)"spaced-vitem");
        Label clearStatsLabel = new Label(i18n.i18n("Usage statistics are used to populate the modules quick bar on the left with the most used and most recently used modules."));
        clearStatsLabel.setWrapText(true);
        this.getChildren().addAll((Object[])new Node[]{new Label(i18n.i18n("Load default workspace at startup:")), workspace, new Label(i18n.i18n("Default working directory:")), workingDirectory, clearStatsLabel, clearStatsButton});
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
    }
}

