/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.module;

import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.builder.Builder;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.Module;
import org.pdfsam.module.TaskExecutionRequestEvent;
import org.pdfsam.ui.module.ModuleFooterPane;
import org.pdfsam.ui.notification.AddNotificationRequestEvent;
import org.pdfsam.ui.notification.NotificationType;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.workspace.LoadWorkspaceEvent;
import org.pdfsam.ui.workspace.SaveWorkspaceEvent;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.model.parameter.base.AbstractParameters;

@Named
public abstract class BaseTaskExecutionModule
implements Module {
    private ModuleFooterPane footer;
    private BorderPane modulePanel = new BorderPane();

    @PostConstruct
    final void init() {
        Pane innerPanel = this.getInnerPanel();
        innerPanel.getStyleClass().addAll((Object[])Style.DEAULT_CONTAINER.css());
        innerPanel.getStyleClass().addAll((Object[])Style.MODULE_CONTAINER.css());
        this.footer.runButton().setOnAction(event -> {
            ErrorTracker errorTracker = new ErrorTracker();
            Builder<? extends AbstractParameters> builder = this.getBuilder(errorTracker.andThen(s -> StaticStudio.eventStudio().broadcast(new AddNotificationRequestEvent(NotificationType.ERROR, (String)s, DefaultI18nContext.getInstance().i18n("Invalid parameters")))));
            if (!errorTracker.errorOnBuild) {
                StaticStudio.eventStudio().broadcast(new TaskExecutionRequestEvent(this.id(), builder.build()));
            }
        });
        this.modulePanel.setBottom((Node)this.footer);
        this.modulePanel.setCenter((Node)innerPanel);
        StaticStudio.eventStudio().addAnnotatedListeners(this);
    }

    @EventListener
    public final void saveStateData(SaveWorkspaceEvent event) {
        this.onSaveWorkspace(event.getDataForModule(this.id()));
    }

    @EventListener
    public final void restoreState(LoadWorkspaceEvent event) {
        Platform.runLater(() -> this.onLoadWorkspace(event.getData(this.id())));
    }

    protected abstract Pane getInnerPanel();

    protected abstract Builder<? extends AbstractParameters> getBuilder(Consumer<String> var1);

    @Inject
    public void setFooter(ModuleFooterPane footer) {
        this.footer = footer;
    }

    @Override
    public Pane modulePanel() {
        return this.modulePanel;
    }

    private static class ErrorTracker
    implements Consumer<String> {
        boolean errorOnBuild = false;

        private ErrorTracker() {
        }

        @Override
        public void accept(String error) {
            this.errorOnBuild = true;
        }
    }
}

