/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.module;

import java.math.BigDecimal;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javax.inject.Named;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.TaskExecutionRequestEvent;
import org.pdfsam.ui.module.OpenButton;
import org.pdfsam.ui.module.TaskFailedButton;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.model.exception.TaskOutputVisitException;
import org.sejda.model.notification.event.PercentageOfWorkDoneChangedEvent;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;
import org.sejda.model.notification.event.TaskExecutionStartedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;

@Named
@Scope(value="prototype")
class ProgressPane
extends VBox {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressPane.class);
    private ProgressBar bar = new ProgressBar(0.0);
    private Label statusLabel = new Label(DefaultI18nContext.getInstance().i18n("Ready"));
    private TaskFailedButton failed = new TaskFailedButton();
    private OpenButton open = new OpenButton();

    public ProgressPane() {
        this.getStyleClass().add((Object)"progress-pane");
        this.statusLabel.getStyleClass().add((Object)"progress-status");
        this.failed.setVisible(false);
        this.open.setVisible(false);
        this.bar.getStyleClass().add((Object)"pdfsam-footer-bar");
        StackPane buttons = new StackPane(new Node[]{this.failed, this.open});
        HBox progressStatusBox = new HBox(new Node[]{this.statusLabel, buttons});
        progressStatusBox.getStyleClass().add((Object)"progress-status-pane");
        HBox.setHgrow((Node)this.statusLabel, (Priority)Priority.ALWAYS);
        this.statusLabel.setMaxWidth(Double.MAX_VALUE);
        this.getChildren().addAll((Object[])new Node[]{progressStatusBox, this.bar});
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener(priority=-2147483648)
    public void onTaskExecutionStarted(TaskExecutionStartedEvent event) {
        this.statusLabel.setText(DefaultI18nContext.getInstance().i18n("Running"));
    }

    @EventListener
    public void onTaskExecutionRequest(TaskExecutionRequestEvent event) {
        this.open.setVisible(false);
        this.failed.setVisible(false);
        this.statusLabel.setText(DefaultI18nContext.getInstance().i18n("Requested"));
        this.bar.setProgress(0.0);
        try {
            if (!Objects.isNull(event.getParameters().getOutput())) {
                event.getParameters().getOutput().accept(this.open);
            }
        }
        catch (TaskOutputVisitException e) {
            LOG.warn("This should never happen", e);
        }
    }

    @EventListener
    public void onTaskCompleted(TaskExecutionCompletedEvent event) {
        this.open.setVisible(true);
        this.failed.setVisible(false);
        this.bar.setProgress(1.0);
        this.statusLabel.setText(DefaultI18nContext.getInstance().i18n("Completed"));
    }

    @EventListener
    public void onTaskFailed(TaskExecutionFailedEvent event) {
        this.open.setVisible(false);
        this.failed.setVisible(true);
        this.bar.setProgress(1.0);
        this.statusLabel.setText(DefaultI18nContext.getInstance().i18n("Failed"));
    }

    @EventListener
    public void onProgress(PercentageOfWorkDoneChangedEvent event) {
        this.open.setVisible(false);
        this.failed.setVisible(false);
        if (event.isUndetermined()) {
            this.statusLabel.setText(DefaultI18nContext.getInstance().i18n("Running"));
            this.bar.setProgress(-1.0);
        } else {
            this.statusLabel.setText(String.format("%d %%", event.getPercentage().intValue()));
            this.bar.setProgress(event.getPercentage().divide(new BigDecimal(100)).doubleValue());
        }
    }
}

