/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.workarea;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.module.Module;
import org.pdfsam.module.UsageService;
import org.pdfsam.ui.workarea.ModuleButton;

@Named
class QuickbarModuleButtonsProvider {
    private static final int RECENT_MODULES = 3;
    private static final int MAX_MODULES = 8;
    private UsageService service;
    private List<Module> modules;

    @Inject
    QuickbarModuleButtonsProvider(UsageService service, List<Module> modules) {
        this.service = service;
        this.modules = new ArrayList<Module>(modules);
        this.modules.sort((a, b) -> Integer.compare(a.descriptor().getPriority(), b.descriptor().getPriority()));
    }

    public Set<ModuleButton> buttons() {
        LinkedHashSet<ModuleButton> collected = new LinkedHashSet<ModuleButton>();
        this.fillWithMostRecentlyUsed(collected);
        this.fillWithMostUsed(collected);
        this.fillWithPrioritized(collected);
        return collected;
    }

    private void fillWithMostUsed(Set<ModuleButton> collected) {
        for (Module current : this.service.getMostUsed()) {
            if (collected.size() >= 8) break;
            collected.add(new ModuleButton(current));
        }
    }

    private void fillWithMostRecentlyUsed(Set<ModuleButton> collected) {
        for (Module current : this.service.getMostRecentlyUsed()) {
            if (collected.size() >= 3) break;
            collected.add(new ModuleButton(current));
        }
    }

    private void fillWithPrioritized(Set<ModuleButton> collected) {
        for (Module current : this.modules) {
            if (collected.size() >= 8) break;
            collected.add(new ModuleButton(current));
        }
    }
}

