/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.core.writer.model.ImageOptimizer;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.OptimizeParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.filter.MissingImageReaderException;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizeTask
extends BaseTask<OptimizeParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizeTask.class);
    private int totalSteps;
    private PDDocumentHandler documentHandler = null;
    private MultipleOutputWriter outputWriter;
    private OptimizeParameters parameters;
    private Map<String, SoftReference<PDImageXObject>> cache = new HashMap<String, SoftReference<PDImageXObject>>();
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    @Override
    public void before(OptimizeParameters parameters) {
        this.parameters = parameters;
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter(parameters.getExistingOutputPolicy());
    }

    @Override
    public void execute(OptimizeParameters parameters) throws TaskException {
        int currentStep = 0;
        for (PdfSource source : parameters.getSourceList()) {
            ++currentStep;
            LOG.debug("Opening {}", (Object)source);
            this.documentHandler = source.open(this.documentLoader);
            this.documentHandler.setCreatorOnPDDocument();
            File tmpFile = IOUtils.createTemporaryPdfBuffer();
            LOG.debug("Created output on temporary buffer {}", (Object)tmpFile);
            for (int i = 1; i <= this.documentHandler.getNumberOfPages(); ++i) {
                LOG.debug("Optimizing page {}", (Object)i);
                PDPage page = this.documentHandler.getPage(i);
                try {
                    if (!parameters.isCompressImages()) continue;
                    this.optimizeImages(page);
                    continue;
                }
                catch (MissingImageReaderException e) {
                    LOG.warn(e.getLocalizedMessage());
                    continue;
                }
                catch (IOException e) {
                    throw new TaskException(e);
                }
            }
            this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
            this.documentHandler.setCompress(parameters.isCompress());
            this.documentHandler.savePDDocument(tmpFile);
            String outName = NameGenerator.nameGenerator(parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(source.getName()).fileNumber(currentStep));
            this.outputWriter.addOutput(FileOutput.file(tmpFile).name(outName));
            ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
            ApplicationEventsNotifier.notifyEvent(this.getNotifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Input documents optimized and written to {}", (Object)parameters.getOutput());
    }

    private void optimizeImages(PDPage page) throws IOException, TaskException {
        PDResources pageResources = page.getResources();
        ArrayList xObjectNames = Lists.newArrayList(pageResources.getXObjectNames());
        for (COSName xObjectName : xObjectNames) {
            this.stopTaskIfCancelled();
            try {
                PDImageXObject newImage;
                PDXObject obj = pageResources.getXObject(xObjectName);
                if (!(obj instanceof PDImageXObject)) continue;
                PDImageXObject imageXObject = (PDImageXObject)obj;
                LOG.debug("Found image {}x{}", (Object)imageXObject.getHeight(), (Object)imageXObject.getWidth());
                File tmpImageFile = ImageOptimizer.optimize(imageXObject.getImage(), this.parameters.getImageQuality(), this.parameters.getImageDpi(), this.parameters.getImageMaxWidthOrHeight());
                long optimizedSize = tmpImageFile.length();
                int originalSize = imageXObject.getStream().getLength();
                if ((long)originalSize <= optimizedSize) continue;
                LOG.debug(String.format("Compressed image to %.2f percent of original size", (double)optimizedSize * 100.0 / (double)originalSize));
                String hash = Files.hash((File)tmpImageFile, (HashFunction)Hashing.md5()).toString();
                if (this.cache.containsKey(hash)) {
                    newImage = this.cache.get(hash).get();
                } else {
                    newImage = PDImageXObject.createFromFile(tmpImageFile);
                    this.cache.put(hash, new SoftReference<PDImageXObject>(newImage));
                }
                pageResources.put(xObjectName, newImage);
            }
            catch (IOException | RuntimeException ex) {
                LOG.warn("Failed to optimize image, skipping and continuing with next.", ex);
            }
        }
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
    }
}

