/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import org.sejda.common.ComponentsUtility;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.SamboxOutlineLevelsHandler;
import org.sejda.impl.sambox.component.split.PageDestinationsLevelPdfSplitter;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.outline.OutlinePageDestinations;
import org.sejda.model.parameter.SplitByOutlineLevelParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.sambox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitByOutlineLevelTask
extends BaseTask<SplitByOutlineLevelParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(SplitByOutlineLevelTask.class);
    private PDDocument document = null;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private PageDestinationsLevelPdfSplitter splitter;

    @Override
    public void before(SplitByOutlineLevelParameters parameters) {
        this.documentLoader = new DefaultPdfSourceOpener();
    }

    @Override
    public void execute(SplitByOutlineLevelParameters parameters) throws TaskException {
        LOG.debug("Opening {} ", (Object)parameters.getSource());
        this.document = parameters.getSource().open(this.documentLoader).getUnderlyingPDDocument();
        LOG.debug("Retrieving outline information for level {}", (Object)parameters.getLevelToSplitAt());
        OutlinePageDestinations pagesDestination = new SamboxOutlineLevelsHandler(this.document, parameters.getMatchingTitleRegEx()).getPageDestinationsForLevel(parameters.getLevelToSplitAt());
        this.splitter = new PageDestinationsLevelPdfSplitter(this.document, parameters, pagesDestination);
        LOG.debug("Starting split by outline level for {} ", (Object)parameters);
        this.splitter.split(this.getNotifiableTaskMetadata());
        LOG.debug("Input documents splitted and written to {}", (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.document);
        this.splitter = null;
    }
}

