/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import org.sejda.io.SeekableSourceInputStream;

public interface SeekableSource
extends ReadableByteChannel {
    public String id();

    public long position() throws IOException;

    public SeekableSource position(long var1) throws IOException;

    public long size();

    public int read() throws IOException;

    public SeekableSource view(long var1, long var3) throws IOException;

    default public SeekableSource back(long offset) throws IOException {
        long newPosition = this.position() - offset;
        if (newPosition < 0L || newPosition > this.size()) {
            throw new IllegalArgumentException("Going back would move to " + newPosition + ", outside of source boundaries");
        }
        this.position(newPosition);
        return this;
    }

    default public SeekableSource back() throws IOException {
        return this.back(1L);
    }

    default public SeekableSource forward(long offset) throws IOException {
        return this.back(-offset);
    }

    default public int peek() throws IOException {
        int val = this.read();
        if (val != -1) {
            this.back(1L);
        }
        return val;
    }

    default public InputStream asInputStream() {
        return new SeekableSourceInputStream(this);
    }
}

