/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSources;
import org.sejda.sambox.contentstream.PDContentStream;
import org.sejda.sambox.contentstream.operator.Operator;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.input.ContentStreamCOSParser;
import org.sejda.sambox.input.SourceReader;
import org.sejda.sambox.util.CharUtils;
import org.sejda.util.IOUtils;

public class ContentStreamParser
extends SourceReader {
    private ContentStreamCOSParser cosParser;
    private List<Object> tokens = new ArrayList<Object>();

    public ContentStreamParser(PDContentStream stream) throws IOException {
        this(SeekableSources.inMemorySeekableSourceFrom(stream.getContents()));
    }

    public ContentStreamParser(SeekableSource source) {
        super(source);
        this.cosParser = new ContentStreamCOSParser(this.source());
    }

    public List<Object> tokens() throws IOException {
        Object token;
        this.tokens.clear();
        while ((token = this.nextParsedToken()) != null) {
            this.tokens.add(token);
        }
        return Collections.unmodifiableList(this.tokens);
    }

    public Object nextParsedToken() throws IOException {
        this.skipSpaces();
        COSBase token = this.cosParser.nextParsedToken();
        if (token != null) {
            return token;
        }
        return this.nextOperator();
    }

    private Object nextOperator() throws IOException {
        if ('B' == (char)this.source().peek()) {
            Operator operator = Operator.getOperator(this.readToken());
            if ("BI".equals(operator.getName())) {
                this.nextInlineImage(operator);
            }
            return operator;
        }
        return Optional.ofNullable(this.readToken()).filter(s -> s.length() > 0).map(Operator::getOperator).orElse(null);
    }

    private void nextInlineImage(Operator operator) throws IOException {
        COSDictionary imageParams = new COSDictionary();
        operator.setImageParameters(imageParams);
        COSBase nextToken = null;
        while ((nextToken = this.cosParser.nextParsedToken()) instanceof COSName) {
            imageParams.setItem((COSName)nextToken, this.cosParser.nextParsedToken());
        }
        operator.setImageData(this.nextImageData());
    }

    private byte[] nextImageData() throws IOException {
        int current;
        this.skipSpaces();
        this.skipExpected("ID");
        if (!CharUtils.isWhitespace(this.source().read())) {
            this.source().back();
        }
        ByteArrayOutputStream imageData = new ByteArrayOutputStream();
        while ((current = this.source().read()) != -1) {
            long position = this.source().position();
            if (current == 69 && this.isEndOfImageFrom(position - 1L) || CharUtils.isWhitespace(current) && this.isEndOfImageFrom(position)) break;
            imageData.write(current);
        }
        return imageData.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEndOfImageFrom(long position) throws IOException {
        long currentPosition = this.source().position();
        try {
            this.source().position(position);
            int current = this.source().read();
            if (current == 69) {
                current = this.source().read();
                boolean bl = current == 73 && (CharUtils.isWhitespace(this.source().peek()) || CharUtils.isEOF(this.source().peek()));
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.source().position(currentPosition);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        IOUtils.closeQuietly(this.cosParser);
    }
}

