/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.input.AbstractXrefStreamParser;
import org.sejda.sambox.input.AbstractXrefTableParser;
import org.sejda.sambox.input.COSParser;
import org.sejda.sambox.xref.XrefEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XrefFullScanner {
    private static final Logger LOG = LoggerFactory.getLogger(XrefFullScanner.class);
    private COSDictionary trailer = new COSDictionary();
    private AbstractXrefStreamParser xrefStreamParser;
    private AbstractXrefTableParser xrefTableParser;
    private COSParser parser;
    private Pattern objectDefPatter = Pattern.compile("^(\\d+)[\\s](\\d+)[\\s]obj");
    private boolean xrefFound = false;

    XrefFullScanner(final COSParser parser) {
        this.parser = parser;
        this.xrefStreamParser = new AbstractXrefStreamParser(parser){

            @Override
            void onTrailerFound(COSDictionary found) {
                XrefFullScanner.this.trailer.merge(found);
            }

            @Override
            void onEntryFound(XrefEntry entry) {
                parser.provider().addEntry(entry);
            }
        };
        this.xrefTableParser = new AbstractXrefTableParser(parser){

            @Override
            void onTrailerFound(COSDictionary found) {
                XrefFullScanner.this.trailer.merge(found);
            }

            @Override
            void onEntryFound(XrefEntry entry) {
                parser.provider().addEntry(entry);
            }
        };
    }

    boolean scan() throws IOException {
        LOG.info("Performing full scan looking for xrefs");
        long savedPos = this.parser.position();
        this.parser.position(0L);
        this.parser.skipSpaces();
        while (this.parser.source().peek() != -1) {
            Matcher matcher;
            long offset = this.parser.position();
            String line = this.parser.readLine();
            if (line.startsWith("xref")) {
                this.xrefFound = true;
                this.parseFoundXrefTable(offset);
            }
            if ((matcher = this.objectDefPatter.matcher(line)).find()) {
                this.parseFoundObject(offset);
            }
            this.parser.skipSpaces();
        }
        this.parser.position(savedPos);
        return this.xrefFound;
    }

    private void parseFoundXrefTable(long offset) throws IOException {
        LOG.debug("Found xref table at " + offset);
        this.xrefTableParser.parse(offset);
    }

    COSDictionary trailer() {
        return this.trailer;
    }

    private void parseFoundObject(long offset) throws IOException {
        this.parser.position(offset);
        this.parser.skipIndirectObjectDefinition();
        this.parser.skipSpaces();
        COSBase found = this.parser.nextParsedToken();
        if (found instanceof COSDictionary && COSName.XREF.equals(((COSDictionary)found).getItem(COSName.TYPE))) {
            LOG.debug("Found xref stream at " + offset);
            this.parseFoundXrefStream((COSDictionary)found);
        }
    }

    private void parseFoundXrefStream(COSDictionary trailer) throws IOException {
        this.xrefFound = true;
        try (COSStream xrefStream = this.parser.nextStream(trailer);){
            this.xrefStreamParser.onTrailerFound(trailer);
            this.xrefStreamParser.parseStream(xrefStream);
        }
        LOG.debug("Done parsing xref stream");
    }
}

