/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel;

import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.PDDestinationNameTreeNode;
import org.sejda.sambox.pdmodel.PDDocumentCatalog;
import org.sejda.sambox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.sejda.sambox.pdmodel.PDJavascriptNameTreeNode;

public class PDDocumentNameDictionary
implements COSObjectable {
    private final COSDictionary nameDictionary;

    public PDDocumentNameDictionary(PDDocumentCatalog cat) {
        COSBase names = cat.getCOSObject().getDictionaryObject(COSName.NAMES);
        if (names != null) {
            this.nameDictionary = (COSDictionary)names;
        } else {
            this.nameDictionary = new COSDictionary();
            cat.getCOSObject().setItem(COSName.NAMES, (COSBase)this.nameDictionary);
        }
    }

    public PDDocumentNameDictionary(COSDictionary names) {
        this.nameDictionary = names;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.nameDictionary;
    }

    public PDDestinationNameTreeNode getDests() {
        COSDictionary dic = (COSDictionary)this.nameDictionary.getDictionaryObject(COSName.DESTS);
        if (dic != null) {
            return new PDDestinationNameTreeNode(dic);
        }
        return null;
    }

    public void setDests(PDDestinationNameTreeNode dests) {
        this.nameDictionary.setItem(COSName.DESTS, (COSObjectable)dests);
    }

    public PDEmbeddedFilesNameTreeNode getEmbeddedFiles() {
        PDEmbeddedFilesNameTreeNode retval = null;
        COSDictionary dic = (COSDictionary)this.nameDictionary.getDictionaryObject(COSName.EMBEDDED_FILES);
        if (dic != null) {
            retval = new PDEmbeddedFilesNameTreeNode(dic);
        }
        return retval;
    }

    public void setEmbeddedFiles(PDEmbeddedFilesNameTreeNode ef) {
        this.nameDictionary.setItem(COSName.EMBEDDED_FILES, (COSObjectable)ef);
    }

    public PDJavascriptNameTreeNode getJavaScript() {
        PDJavascriptNameTreeNode retval = null;
        COSDictionary dic = (COSDictionary)this.nameDictionary.getDictionaryObject(COSName.JAVA_SCRIPT);
        if (dic != null) {
            retval = new PDJavascriptNameTreeNode(dic);
        }
        return retval;
    }

    public void setJavascript(PDJavascriptNameTreeNode js) {
        this.nameDictionary.setItem(COSName.JAVA_SCRIPT, (COSObjectable)js);
    }
}

