/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.font;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.sejda.sambox.contentstream.PDContentStream;
import org.sejda.sambox.contentstream.operator.Operator;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.input.ContentStreamParser;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.common.PDStream;
import org.sejda.sambox.pdmodel.font.PDType3Font;
import org.sejda.sambox.util.Matrix;

public final class PDType3CharProc
implements COSObjectable,
PDContentStream {
    private final PDType3Font font;
    private final COSStream charStream;

    public PDType3CharProc(PDType3Font font, COSStream charStream) {
        this.font = font;
        this.charStream = charStream;
    }

    @Override
    public COSStream getCOSObject() {
        return this.charStream;
    }

    public PDType3Font getFont() {
        return this.font;
    }

    public PDStream getContentStream() {
        return new PDStream(this.charStream);
    }

    @Override
    public InputStream getContents() throws IOException {
        return this.charStream.getUnfilteredStream();
    }

    @Override
    public PDResources getResources() {
        return this.font.getResources();
    }

    @Override
    public PDRectangle getBBox() {
        return this.font.getFontBBox();
    }

    public PDRectangle getGlyphBBox() throws IOException {
        ArrayList<COSBase> arguments = new ArrayList<COSBase>();
        ContentStreamParser parser = new ContentStreamParser(this);
        Object token = null;
        while ((token = parser.nextParsedToken()) != null) {
            if (token instanceof Operator) {
                if (((Operator)token).getName().equals("d1") && arguments.size() == 6) {
                    for (int i = 0; i < 6; ++i) {
                        if (arguments.get(i) instanceof COSNumber) continue;
                        return null;
                    }
                    return new PDRectangle(((COSNumber)arguments.get(2)).floatValue(), ((COSNumber)arguments.get(3)).floatValue(), ((COSNumber)arguments.get(4)).floatValue() - ((COSNumber)arguments.get(2)).floatValue(), ((COSNumber)arguments.get(5)).floatValue() - ((COSNumber)arguments.get(3)).floatValue());
                }
                return null;
            }
            arguments.add((COSBase)token);
        }
        return null;
    }

    @Override
    public Matrix getMatrix() {
        return this.font.getFontMatrix();
    }

    public float getWidth() throws IOException {
        ArrayList<COSBase> arguments = new ArrayList<COSBase>();
        ContentStreamParser parser = new ContentStreamParser(this);
        Object token = null;
        while ((token = parser.nextParsedToken()) != null) {
            if (token instanceof Operator) {
                return this.parseWidth((Operator)token, arguments);
            }
            arguments.add(((COSBase)token).getCOSObject());
        }
        throw new IOException("Unexpected end of stream");
    }

    private float parseWidth(Operator operator, List arguments) throws IOException {
        if (operator.getName().equals("d0") || operator.getName().equals("d1")) {
            Object obj = arguments.get(0);
            if (obj instanceof Number) {
                return ((Number)obj).floatValue();
            }
            if (obj instanceof COSNumber) {
                return ((COSNumber)obj).floatValue();
            }
            throw new IOException("Unexpected argument type: " + obj.getClass().getName());
        }
        throw new IOException("First operator must be d0 or d1");
    }
}

