/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSArrayList;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageContentStream;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.graphics.form.PDFormXObject;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.sejda.sambox.pdmodel.interactive.form.PDField;
import org.sejda.sambox.pdmodel.interactive.form.PDFieldTree;
import org.sejda.sambox.pdmodel.interactive.form.PDTerminalField;
import org.sejda.sambox.pdmodel.interactive.form.PDXFAResource;
import org.sejda.sambox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PDAcroForm
implements COSObjectable {
    private static final Logger LOG = LoggerFactory.getLogger(PDAcroForm.class);
    private static final int FLAG_SIGNATURES_EXIST = 1;
    private static final int FLAG_APPEND_ONLY = 2;
    private final PDDocument document;
    private final COSDictionary dictionary;
    private Map<String, PDField> fieldCache;

    public PDAcroForm(PDDocument doc) {
        this.document = doc;
        this.dictionary = new COSDictionary();
        this.dictionary.setItem(COSName.FIELDS, (COSBase)new COSArray());
    }

    public PDAcroForm(PDDocument doc, COSDictionary form) {
        this.document = doc;
        this.dictionary = form;
    }

    PDDocument getDocument() {
        return this.document;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.dictionary;
    }

    public void flatten() throws IOException {
        if (this.xfaIsDynamic()) {
            LOG.warn("Flatten for a dynamic XFA form is not supported");
            return;
        }
        ArrayList<PDField> fields = new ArrayList<PDField>();
        for (PDField field : this.getFieldTree()) {
            fields.add(field);
        }
        this.flatten(fields, false);
    }

    public void flatten(List<PDField> fields, boolean refreshAppearances) throws IOException {
        if (this.xfaIsDynamic()) {
            LOG.warn("Flatten for a dynamic XFA form is not supported");
            return;
        }
        if (refreshAppearances) {
            this.refreshAppearances();
        }
        boolean isContentStreamWrapped = false;
        for (PDField field : fields) {
            for (PDAnnotationWidget widget : field.getWidgets()) {
                PDPageContentStream contentStream;
                if (widget.getNormalAppearanceStream() == null) continue;
                PDPage page = widget.getPage();
                if (!isContentStreamWrapped) {
                    contentStream = new PDPageContentStream(this.document, page, true, true, true);
                    isContentStreamWrapped = true;
                } else {
                    contentStream = new PDPageContentStream(this.document, page, true, true);
                }
                PDFormXObject fieldObject = new PDFormXObject(widget.getNormalAppearanceStream().getCOSStream());
                Matrix translationMatrix = Matrix.getTranslateInstance(widget.getRectangle().getLowerLeftX(), widget.getRectangle().getLowerLeftY());
                contentStream.saveGraphicsState();
                contentStream.transform(translationMatrix);
                contentStream.drawForm(fieldObject);
                contentStream.restoreGraphicsState();
                contentStream.close();
            }
        }
        for (PDPage page : this.document.getPages()) {
            ArrayList<PDAnnotation> annotations = new ArrayList<PDAnnotation>();
            for (PDAnnotation annotation : page.getAnnotations()) {
                if (annotation instanceof PDAnnotationWidget) continue;
                annotations.add(annotation);
            }
            page.setAnnotations(annotations);
        }
        this.setFields(Collections.emptyList());
        this.dictionary.removeItem(COSName.XFA);
    }

    public void refreshAppearances() throws IOException {
        for (PDField field : this.getFieldTree()) {
            if (!(field instanceof PDTerminalField)) continue;
            ((PDTerminalField)field).constructAppearances();
        }
    }

    public void refreshAppearances(List<PDField> fields) throws IOException {
        for (PDField field : fields) {
            if (!(field instanceof PDTerminalField)) continue;
            ((PDTerminalField)field).constructAppearances();
        }
    }

    public List<PDField> getFields() {
        ArrayList<PDField> pdFields = new ArrayList<PDField>();
        COSArray fields = (COSArray)this.getCOSObject().getDictionaryObject(COSName.FIELDS);
        if (fields != null) {
            for (COSBase field : fields) {
                if (COSNull.NULL.equals(field) || !Objects.nonNull(field)) continue;
                pdFields.add(PDField.fromDictionary(this, (COSDictionary)field.getCOSObject(), null));
            }
        }
        return pdFields;
    }

    public void addFields(List<PDField> toAdd) {
        COSArray fields = (COSArray)this.getCOSObject().getDictionaryObject(COSName.FIELDS);
        if (fields == null) {
            fields = new COSArray();
        }
        for (PDField field : toAdd) {
            fields.add(field);
        }
        this.getCOSObject().setItem(COSName.FIELDS, (COSBase)fields);
        Optional.ofNullable(this.fieldCache).ifPresent(c -> c.clear());
    }

    public void removeField(PDField remove) {
        COSArray fields = (COSArray)this.getCOSObject().getDictionaryObject(COSName.FIELDS);
        if (fields != null && fields.contains(remove)) {
            fields.remove(remove);
            Optional.ofNullable(this.fieldCache).ifPresent(c -> c.clear());
        }
    }

    public void setFields(List<PDField> fields) {
        this.dictionary.setItem(COSName.FIELDS, (COSBase)COSArrayList.converterToCOSArray(fields));
    }

    public Iterator<PDField> getFieldIterator() {
        return new PDFieldTree(this).iterator();
    }

    public PDFieldTree getFieldTree() {
        return new PDFieldTree(this);
    }

    public void setCacheFields(boolean cache) {
        if (cache) {
            this.fieldCache = new HashMap<String, PDField>();
            for (PDField field : this.getFieldTree()) {
                this.fieldCache.put(field.getFullyQualifiedName(), field);
            }
        } else {
            this.fieldCache = null;
        }
    }

    public boolean isCachingFields() {
        return this.fieldCache != null;
    }

    public PDField getField(String fullyQualifiedName) {
        PDField retval = null;
        if (this.fieldCache != null) {
            retval = this.fieldCache.get(fullyQualifiedName);
        } else {
            String[] nameSubSection = fullyQualifiedName.split("\\.");
            COSArray fields = (COSArray)this.dictionary.getDictionaryObject(COSName.FIELDS);
            if (fields != null) {
                for (int i = 0; i < fields.size() && retval == null; ++i) {
                    PDField root;
                    COSString fieldName;
                    COSDictionary element = (COSDictionary)fields.getObject(i);
                    if (element == null || !(fieldName = (COSString)element.getDictionaryObject(COSName.T)).getString().equals(fullyQualifiedName) && !fieldName.getString().equals(nameSubSection[0]) || (root = PDField.fromDictionary(this, element, null)) == null) continue;
                    if (nameSubSection.length > 1) {
                        PDField kid = root.findKid(nameSubSection, 1);
                        if (kid != null) {
                            retval = kid;
                            continue;
                        }
                        retval = root;
                        continue;
                    }
                    retval = root;
                }
            }
        }
        return retval;
    }

    public String getDefaultAppearance() {
        return Optional.ofNullable(this.dictionary.getItem(COSName.DA)).map(i -> (COSString)i).map(COSString::getString).orElse("");
    }

    public void setDefaultAppearance(String daValue) {
        this.dictionary.setString(COSName.DA, daValue);
    }

    public boolean isNeedAppearances() {
        return this.dictionary.getBoolean(COSName.NEED_APPEARANCES, false);
    }

    public void setNeedAppearances(Boolean value) {
        this.dictionary.setBoolean(COSName.NEED_APPEARANCES, (boolean)value);
    }

    public PDResources getDefaultResources() {
        PDResources retval = null;
        COSDictionary dr = (COSDictionary)this.dictionary.getDictionaryObject(COSName.DR);
        if (dr != null) {
            retval = new PDResources(dr);
        }
        return retval;
    }

    public void setDefaultResources(PDResources dr) {
        this.dictionary.setItem(COSName.DR, (COSObjectable)dr);
    }

    public boolean hasXFA() {
        return this.dictionary.containsKey(COSName.XFA);
    }

    public boolean xfaIsDynamic() {
        return this.hasXFA() && this.getFields().isEmpty();
    }

    public PDXFAResource getXFA() {
        PDXFAResource xfa = null;
        COSBase base = this.dictionary.getDictionaryObject(COSName.XFA);
        if (base != null) {
            xfa = new PDXFAResource(base);
        }
        return xfa;
    }

    public void setXFA(PDXFAResource xfa) {
        this.dictionary.setItem(COSName.XFA, (COSObjectable)xfa);
    }

    public int getQuadding() {
        return this.dictionary.getInt(COSName.Q, 0);
    }

    public void setQuadding(int q) {
        this.dictionary.setInt(COSName.Q, q);
    }

    public boolean isSignaturesExist() {
        return this.dictionary.getFlag(COSName.SIG_FLAGS, 1);
    }

    public void setSignaturesExist(boolean signaturesExist) {
        this.dictionary.setFlag(COSName.SIG_FLAGS, 1, signaturesExist);
    }

    public boolean isAppendOnly() {
        return this.dictionary.getFlag(COSName.SIG_FLAGS, 2);
    }

    public void setAppendOnly(boolean appendOnly) {
        this.dictionary.setFlag(COSName.SIG_FLAGS, 2, appendOnly);
    }
}

