/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.extension.Extension;
import org.zaproxy.zap.Version;
import org.zaproxy.zap.control.AddOnClassnames;
import org.zaproxy.zap.control.BaseZapAddOnXmlData;
import org.zaproxy.zap.control.ZapAddOnXmlFile;
import org.zaproxy.zap.control.ZapRelease;
import org.zaproxy.zap.control.ZapReleaseComparitor;
import org.zaproxy.zap.control.ZapVersionsAddOnEntry;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;

public class AddOn {
    private static ZapRelease v2_4 = new ZapRelease("2.4.0");
    private String id;
    private String name;
    private String description;
    private String author;
    private int fileVersion;
    private Version version;
    private Status status;
    private String changes;
    private File file;
    private URL url;
    private URL info;
    private long size;
    private boolean hasZapAddOnEntry;
    private boolean manifestRead;
    private String notBeforeVersion;
    private String notFromVersion;
    private String hash;
    private InstallationStatus installationStatus;
    private List<String> extensions;
    private List<BaseZapAddOnXmlData.ExtensionWithDeps> extensionsWithDeps;
    private List<Extension> loadedExtensions;
    private List<String> ascanrules;
    private List<AbstractPlugin> loadedAscanrules;
    private boolean loadedAscanRulesSet;
    private List<String> pscanrules;
    private List<PluginPassiveScanner> loadedPscanrules;
    private boolean loadedPscanRulesSet;
    private List<String> files;
    private AddOnClassnames addOnClassnames;
    private BaseZapAddOnXmlData.Dependencies dependencies;
    private static final Logger logger = Logger.getLogger(AddOn.class);

    public static boolean isAddOn(String string) {
        if (!string.toLowerCase().endsWith(".zap")) {
            return false;
        }
        if (string.substring(0, string.indexOf(".")).split("-").length < 3) {
            return false;
        }
        String[] stringArray = string.substring(0, string.indexOf(".")).split("-");
        try {
            Status.valueOf(stringArray[1]);
            Integer.parseInt(stringArray[2]);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isAddOn(File file) {
        if (!file.exists()) {
            return false;
        }
        return AddOn.isAddOn(file.getName());
    }

    public AddOn(String string) throws Exception {
        this.description = "";
        this.author = "";
        this.changes = "";
        this.file = null;
        this.url = null;
        this.info = null;
        this.size = 0L;
        this.hasZapAddOnEntry = false;
        this.notBeforeVersion = null;
        this.notFromVersion = null;
        this.hash = null;
        this.installationStatus = InstallationStatus.NOT_INSTALLED;
        this.extensions = Collections.emptyList();
        this.extensionsWithDeps = Collections.emptyList();
        this.ascanrules = Collections.emptyList();
        this.loadedAscanrules = Collections.emptyList();
        this.pscanrules = Collections.emptyList();
        this.loadedPscanrules = Collections.emptyList();
        this.files = Collections.emptyList();
        this.addOnClassnames = AddOnClassnames.ALL_ALLOWED;
        if (!AddOn.isAddOn(string)) {
            throw new Exception("Invalid ZAP add-on file " + string);
        }
        String[] stringArray = string.substring(0, string.indexOf(".")).split("-");
        this.name = this.id = stringArray[0];
        this.status = Status.valueOf(stringArray[1]);
        this.fileVersion = Integer.parseInt(stringArray[2]);
    }

    public AddOn(File file) throws Exception {
        this(file.getName());
        if (!AddOn.isAddOn(file)) {
            throw new Exception("Invalid ZAP add-on file " + file.getAbsolutePath());
        }
        this.file = file;
        this.loadManifestFile();
    }

    private void loadManifestFile() throws IOException {
        block25: {
            this.manifestRead = true;
            if (this.file.exists()) {
                try (ZipFile zipFile = new ZipFile(this.file);){
                    ZipEntry zipEntry = zipFile.getEntry("ZapAddOn.xml");
                    if (zipEntry == null) break block25;
                    try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                        ZapAddOnXmlFile zapAddOnXmlFile = new ZapAddOnXmlFile(inputStream);
                        this.name = zapAddOnXmlFile.getName();
                        this.version = zapAddOnXmlFile.getVersion();
                        this.description = zapAddOnXmlFile.getDescription();
                        this.changes = zapAddOnXmlFile.getChanges();
                        this.author = zapAddOnXmlFile.getAuthor();
                        this.notBeforeVersion = zapAddOnXmlFile.getNotBeforeVersion();
                        this.notFromVersion = zapAddOnXmlFile.getNotFromVersion();
                        this.dependencies = zapAddOnXmlFile.getDependencies();
                        this.ascanrules = zapAddOnXmlFile.getAscanrules();
                        this.extensions = zapAddOnXmlFile.getExtensions();
                        this.extensionsWithDeps = zapAddOnXmlFile.getExtensionsWithDeps();
                        this.files = zapAddOnXmlFile.getFiles();
                        this.pscanrules = zapAddOnXmlFile.getPscanrules();
                        this.addOnClassnames = zapAddOnXmlFile.getAddOnClassnames();
                        this.hasZapAddOnEntry = true;
                    }
                }
            }
        }
    }

    public AddOn(String string, File file, SubnodeConfiguration subnodeConfiguration) throws MalformedURLException, IOException {
        ZapVersionsAddOnEntry zapVersionsAddOnEntry;
        block3: {
            this.description = "";
            this.author = "";
            this.changes = "";
            this.file = null;
            this.url = null;
            this.info = null;
            this.size = 0L;
            this.hasZapAddOnEntry = false;
            this.notBeforeVersion = null;
            this.notFromVersion = null;
            this.hash = null;
            this.installationStatus = InstallationStatus.NOT_INSTALLED;
            this.extensions = Collections.emptyList();
            this.extensionsWithDeps = Collections.emptyList();
            this.ascanrules = Collections.emptyList();
            this.loadedAscanrules = Collections.emptyList();
            this.pscanrules = Collections.emptyList();
            this.loadedPscanrules = Collections.emptyList();
            this.files = Collections.emptyList();
            this.addOnClassnames = AddOnClassnames.ALL_ALLOWED;
            this.id = string;
            zapVersionsAddOnEntry = new ZapVersionsAddOnEntry((HierarchicalConfiguration)subnodeConfiguration);
            this.name = zapVersionsAddOnEntry.getName();
            this.description = zapVersionsAddOnEntry.getDescription();
            this.author = zapVersionsAddOnEntry.getAuthor();
            this.fileVersion = zapVersionsAddOnEntry.getPackageVersion();
            this.dependencies = zapVersionsAddOnEntry.getDependencies();
            this.extensionsWithDeps = zapVersionsAddOnEntry.getExtensionsWithDeps();
            this.version = zapVersionsAddOnEntry.getVersion();
            this.status = Status.valueOf(zapVersionsAddOnEntry.getStatus());
            this.changes = zapVersionsAddOnEntry.getChanges();
            this.url = new URL(zapVersionsAddOnEntry.getUrl());
            this.file = new File(file, zapVersionsAddOnEntry.getFile());
            this.size = zapVersionsAddOnEntry.getSize();
            this.notBeforeVersion = zapVersionsAddOnEntry.getNotBeforeVersion();
            this.notFromVersion = zapVersionsAddOnEntry.getNotFromVersion();
            if (zapVersionsAddOnEntry.getInfo() != null && !zapVersionsAddOnEntry.getInfo().isEmpty()) {
                try {
                    this.info = new URL(zapVersionsAddOnEntry.getInfo());
                }
                catch (Exception exception) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)("Wrong info URL for add-on \"" + this.name + "\":"), (Throwable)exception);
                }
            }
        }
        this.hash = zapVersionsAddOnEntry.getHash();
        this.loadManifestFile();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public int getFileVersion() {
        return this.fileVersion;
    }

    public Version getVersion() {
        return this.version;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getChanges() {
        return this.changes;
    }

    public void setChanges(String string) {
        this.changes = string;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long l) {
        this.size = l;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public void setInstallationStatus(InstallationStatus installationStatus) {
        if (installationStatus == null) {
            throw new IllegalArgumentException("Parameter installationStatus must not be null.");
        }
        this.installationStatus = installationStatus;
    }

    public InstallationStatus getInstallationStatus() {
        return this.installationStatus;
    }

    public boolean hasZapAddOnEntry() {
        block3: {
            if (!this.hasZapAddOnEntry && !this.manifestRead) {
                try {
                    this.loadManifestFile();
                }
                catch (IOException iOException) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)("Failed to read the ZapAddOn.xml file of " + this.id + ":"), (Throwable)iOException);
                }
            }
        }
        return this.hasZapAddOnEntry;
    }

    public AddOnClassnames getAddOnClassnames() {
        return this.addOnClassnames;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public List<String> getExtensionsWithDeps() {
        if (this.extensionsWithDeps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.extensionsWithDeps.size());
        for (BaseZapAddOnXmlData.ExtensionWithDeps extensionWithDeps : this.extensionsWithDeps) {
            arrayList.add(extensionWithDeps.getClassname());
        }
        return arrayList;
    }

    public AddOnClassnames getExtensionAddOnClassnames(String string) {
        if (this.extensionsWithDeps.isEmpty() || string == null || string.isEmpty()) {
            return AddOnClassnames.ALL_ALLOWED;
        }
        for (BaseZapAddOnXmlData.ExtensionWithDeps extensionWithDeps : this.extensionsWithDeps) {
            if (!string.equals(extensionWithDeps.getClassname())) continue;
            return extensionWithDeps.getAddOnClassnames();
        }
        return AddOnClassnames.ALL_ALLOWED;
    }

    public boolean hasExtensionsWithDeps() {
        return !this.extensionsWithDeps.isEmpty();
    }

    public List<Extension> getLoadedExtensionsWithDeps() {
        List<String> list = this.getExtensionsWithDeps();
        ArrayList<Extension> arrayList = new ArrayList<Extension>(this.extensionsWithDeps.size());
        for (Extension extension : this.getLoadedExtensions()) {
            if (!list.contains(extension.getClass().getCanonicalName())) continue;
            arrayList.add(extension);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public List<Extension> getLoadedExtensions() {
        if (this.loadedExtensions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.loadedExtensions);
    }

    public void addLoadedExtension(Extension extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Parameter extension must not be null.");
        }
        if (this.loadedExtensions == null) {
            this.loadedExtensions = new ArrayList<Extension>(1);
        }
        if (!this.loadedExtensions.contains(extension)) {
            this.loadedExtensions.add(extension);
            extension.setAddOn(this);
        }
    }

    public void removeLoadedExtension(Extension extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Parameter extension must not be null.");
        }
        if (this.loadedExtensions != null && this.loadedExtensions.contains(extension)) {
            this.loadedExtensions.remove(extension);
            extension.setAddOn(null);
        }
    }

    public List<String> getAscanrules() {
        return this.ascanrules;
    }

    public List<AbstractPlugin> getLoadedAscanrules() {
        return this.loadedAscanrules;
    }

    void setLoadedAscanrules(List<AbstractPlugin> list) {
        if (list == null) {
            throw new IllegalArgumentException("Parameter ascanrules must not be null.");
        }
        if (list.isEmpty()) {
            this.loadedAscanrules = Collections.emptyList();
            return;
        }
        for (AbstractPlugin abstractPlugin : list) {
            abstractPlugin.setStatus(this.getStatus());
        }
        this.loadedAscanrules = Collections.unmodifiableList(new ArrayList<AbstractPlugin>(list));
    }

    boolean isLoadedAscanrulesSet() {
        return this.loadedAscanRulesSet;
    }

    void setLoadedAscanrulesSet(boolean bl) {
        this.loadedAscanRulesSet = bl;
    }

    public List<String> getPscanrules() {
        return this.pscanrules;
    }

    public List<PluginPassiveScanner> getLoadedPscanrules() {
        return this.loadedPscanrules;
    }

    void setLoadedPscanrules(List<PluginPassiveScanner> list) {
        if (list == null) {
            throw new IllegalArgumentException("Parameter pscanrules must not be null.");
        }
        if (list.isEmpty()) {
            this.loadedPscanrules = Collections.emptyList();
            return;
        }
        for (PluginPassiveScanner pluginPassiveScanner : list) {
            pluginPassiveScanner.setStatus(this.getStatus());
        }
        this.loadedPscanrules = Collections.unmodifiableList(new ArrayList<PluginPassiveScanner>(list));
    }

    boolean isLoadedPscanrulesSet() {
        return this.loadedPscanRulesSet;
    }

    void setLoadedPscanrulesSet(boolean bl) {
        this.loadedPscanRulesSet = bl;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public boolean isSameAddOn(AddOn addOn) {
        return this.getId().equals(addOn.getId());
    }

    public boolean isUpdateTo(AddOn addOn) throws IllegalArgumentException {
        if (!this.isSameAddOn(addOn)) {
            throw new IllegalArgumentException("Different addons: " + this.getId() + " != " + addOn.getId());
        }
        if (this.getFileVersion() > addOn.getFileVersion()) {
            return true;
        }
        return this.getStatus().ordinal() > addOn.getStatus().ordinal();
    }

    @Deprecated
    public boolean canLoad() {
        return false;
    }

    public boolean canLoadInCurrentVersion() {
        return this.canLoadInVersion(Constant.PROGRAM_VERSION);
    }

    public boolean canRunInCurrentJavaVersion() {
        return this.canRunInJavaVersion(SystemUtils.JAVA_VERSION);
    }

    public boolean canRunInJavaVersion(String string) {
        if (this.dependencies == null) {
            return true;
        }
        String string2 = this.dependencies.getJavaVersion();
        if (string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return AddOn.getJavaVersion(string) >= AddOn.getJavaVersion(string2);
    }

    public AddOnRunRequirements calculateRunRequirements(Collection<AddOn> collection) {
        AddOnRunRequirements addOnRunRequirements = new AddOnRunRequirements(this);
        AddOn.calculateRunRequirementsImpl(collection, addOnRunRequirements, null, this);
        if (addOnRunRequirements.isRunnable()) {
            AddOn.checkExtensionsWithDeps(collection, addOnRunRequirements, this);
        }
        return addOnRunRequirements;
    }

    private static void calculateRunRequirementsImpl(Collection<AddOn> collection, BaseRunRequirements baseRunRequirements, AddOn addOn, AddOn addOn2) {
        AddOn addOn3 = AddOn.getAddOn(collection, addOn2.getId());
        if (addOn3 != null && !addOn2.equals(addOn3)) {
            baseRunRequirements.setIssue(BaseRunRequirements.DependencyIssue.OLDER_VERSION, addOn3);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add-on " + addOn2 + " not runnable, old version still installed: " + addOn3));
            }
            return;
        }
        if (!baseRunRequirements.addDependency(addOn, addOn2)) {
            logger.warn((Object)("Cyclic dependency detected with: " + baseRunRequirements.getDependencies()));
            baseRunRequirements.setIssue(BaseRunRequirements.DependencyIssue.CYCLIC, baseRunRequirements.getDependencies());
            return;
        }
        if (addOn2.dependencies == null) {
            return;
        }
        if (!addOn2.canRunInCurrentJavaVersion()) {
            baseRunRequirements.setMinimumJavaVersionIssue(addOn2, addOn2.dependencies.getJavaVersion());
        }
        for (BaseZapAddOnXmlData.AddOnDep addOnDep : addOn2.dependencies.getAddOns()) {
            String string = addOnDep.getId();
            if (string == null) continue;
            AddOn addOn4 = AddOn.getAddOn(collection, string);
            if (addOn4 == null) {
                baseRunRequirements.setIssue(BaseRunRequirements.DependencyIssue.MISSING, string);
                return;
            }
            if (addOnDep.getNotBeforeVersion() > -1 && addOn4.fileVersion < addOnDep.getNotBeforeVersion()) {
                baseRunRequirements.setIssue(BaseRunRequirements.DependencyIssue.PACKAGE_VERSION_NOT_BEFORE, addOn4, addOnDep.getNotBeforeVersion());
                return;
            }
            if (addOnDep.getNotFromVersion() > -1 && addOn4.fileVersion > addOnDep.getNotFromVersion()) {
                baseRunRequirements.setIssue(BaseRunRequirements.DependencyIssue.PACKAGE_VERSION_NOT_FROM, addOn4, addOnDep.getNotFromVersion());
                return;
            }
            if (!(addOnDep.getSemVer().isEmpty() || addOn4.version != null && addOn4.version.matches(addOnDep.getSemVer()))) {
                baseRunRequirements.setIssue(BaseRunRequirements.DependencyIssue.VERSION, addOn4, addOnDep.getSemVer());
                return;
            }
            AddOn.calculateRunRequirementsImpl(collection, baseRunRequirements, addOn2, addOn4);
            if (!baseRunRequirements.hasDependencyIssue()) continue;
            return;
        }
    }

    private static void checkExtensionsWithDeps(Collection<AddOn> collection, AddOnRunRequirements addOnRunRequirements, AddOn addOn) {
        if (addOn.extensionsWithDeps.isEmpty()) {
            return;
        }
        for (BaseZapAddOnXmlData.ExtensionWithDeps extensionWithDeps : addOn.extensionsWithDeps) {
            AddOn.calculateExtensionRunRequirements(extensionWithDeps, collection, addOnRunRequirements, addOn);
        }
    }

    private static void calculateExtensionRunRequirements(BaseZapAddOnXmlData.ExtensionWithDeps extensionWithDeps, Collection<AddOn> collection, AddOnRunRequirements addOnRunRequirements, AddOn addOn) {
        ExtensionRunRequirements extensionRunRequirements = new ExtensionRunRequirements(addOn, extensionWithDeps.getClassname());
        addOnRunRequirements.addExtensionRequirements(extensionRunRequirements);
        for (BaseZapAddOnXmlData.AddOnDep addOnDep : extensionWithDeps.getDependencies()) {
            String string = addOnDep.getId();
            if (string == null) continue;
            AddOn addOn2 = AddOn.getAddOn(collection, string);
            if (addOn2 == null) {
                if (addOn.hasOnlyOneExtensionWithDependencies()) {
                    addOnRunRequirements.setIssue(BaseRunRequirements.DependencyIssue.MISSING, string);
                    return;
                }
                extensionRunRequirements.setIssue(BaseRunRequirements.DependencyIssue.MISSING, string);
                continue;
            }
            if (addOnDep.getNotBeforeVersion() > -1 && addOn2.fileVersion < addOnDep.getNotBeforeVersion()) {
                if (addOn.hasOnlyOneExtensionWithDependencies()) {
                    addOnRunRequirements.setIssue(BaseRunRequirements.DependencyIssue.PACKAGE_VERSION_NOT_BEFORE, addOn2, addOnDep.getNotBeforeVersion());
                    return;
                }
                extensionRunRequirements.setIssue(BaseRunRequirements.DependencyIssue.PACKAGE_VERSION_NOT_BEFORE, addOn2, addOnDep.getNotBeforeVersion());
                continue;
            }
            if (addOnDep.getNotFromVersion() > -1 && addOn2.fileVersion > addOnDep.getNotFromVersion()) {
                if (addOn.hasOnlyOneExtensionWithDependencies()) {
                    addOnRunRequirements.setIssue(BaseRunRequirements.DependencyIssue.PACKAGE_VERSION_NOT_FROM, addOn2, addOnDep.getNotFromVersion());
                    return;
                }
                extensionRunRequirements.setIssue(BaseRunRequirements.DependencyIssue.PACKAGE_VERSION_NOT_FROM, addOn2, addOnDep.getNotFromVersion());
                continue;
            }
            if (!(addOnDep.getSemVer().isEmpty() || addOn2.version != null && addOn2.version.matches(addOnDep.getSemVer()))) {
                if (addOn.hasOnlyOneExtensionWithDependencies()) {
                    addOnRunRequirements.setIssue(BaseRunRequirements.DependencyIssue.VERSION, addOn2, addOnDep.getSemVer());
                    return;
                }
                extensionRunRequirements.setIssue(BaseRunRequirements.DependencyIssue.VERSION, addOn2, addOnDep.getSemVer());
                continue;
            }
            AddOn.calculateRunRequirementsImpl(collection, extensionRunRequirements, addOn, addOn2);
        }
    }

    private boolean hasOnlyOneExtensionWithDependencies() {
        if (this.extensionsWithDeps.size() != 1) {
            return false;
        }
        return this.extensions.isEmpty() && this.files.isEmpty() && this.pscanrules.isEmpty() && this.ascanrules.isEmpty();
    }

    public AddOnRunRequirements calculateExtensionRunRequirements(Extension extension, Collection<AddOn> collection) {
        return this.calculateExtensionRunRequirements(extension.getClass().getCanonicalName(), collection);
    }

    public AddOnRunRequirements calculateExtensionRunRequirements(String string, Collection<AddOn> collection) {
        AddOnRunRequirements addOnRunRequirements = new AddOnRunRequirements(this);
        for (BaseZapAddOnXmlData.ExtensionWithDeps extensionWithDeps : this.extensionsWithDeps) {
            if (!extensionWithDeps.getClassname().equals(string)) continue;
            AddOn.calculateExtensionRunRequirements(extensionWithDeps, collection, addOnRunRequirements, this);
            break;
        }
        return addOnRunRequirements;
    }

    public boolean dependsOn(Extension extension, AddOn addOn) {
        String string = extension.getClass().getCanonicalName();
        for (BaseZapAddOnXmlData.ExtensionWithDeps extensionWithDeps : this.extensionsWithDeps) {
            if (!extensionWithDeps.getClassname().equals(string)) continue;
            return AddOn.dependsOn(extensionWithDeps.getDependencies(), addOn);
        }
        return false;
    }

    private static boolean dependsOn(List<BaseZapAddOnXmlData.AddOnDep> list, AddOn addOn) {
        for (BaseZapAddOnXmlData.AddOnDep addOnDep : list) {
            if (!addOnDep.getId().equals(addOn.id)) continue;
            if (addOnDep.getNotBeforeVersion() > -1 && addOn.fileVersion < addOnDep.getNotBeforeVersion()) {
                return false;
            }
            if (addOnDep.getNotFromVersion() > -1 && addOn.fileVersion > addOnDep.getNotFromVersion()) {
                return false;
            }
            if (!addOnDep.getSemVer().isEmpty()) {
                if (addOn.version == null) {
                    return false;
                }
                if (!addOn.version.matches(addOnDep.getSemVer())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isExtensionLoaded(String string) {
        ArrayList<Extension> arrayList = new ArrayList<Extension>(this.getLoadedExtensions().size() + this.getLoadedExtensionsWithDeps().size());
        arrayList.addAll(this.getLoadedExtensions());
        arrayList.addAll(this.getLoadedExtensionsWithDeps());
        for (Extension extension : this.getLoadedExtensions()) {
            if (!string.equals(extension.getClass().getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    public String getMinimumJavaVersion() {
        if (this.dependencies == null) {
            return "";
        }
        return this.dependencies.getJavaVersion();
    }

    private static AddOn getAddOn(Collection<AddOn> collection, String string) {
        for (AddOn addOn : collection) {
            if (!addOn.getId().equals(string)) continue;
            return addOn;
        }
        return null;
    }

    public boolean canLoadInVersion(String string) {
        if (this.notBeforeVersion == null || this.notBeforeVersion.isEmpty()) {
            return false;
        }
        ZapReleaseComparitor zapReleaseComparitor = new ZapReleaseComparitor();
        ZapRelease zapRelease = new ZapRelease(string);
        ZapRelease zapRelease2 = new ZapRelease(this.notBeforeVersion);
        if (zapReleaseComparitor.compare(zapRelease, zapRelease2) < 0) {
            return false;
        }
        if (zapReleaseComparitor.compare(zapRelease2, v2_4) < 0) {
            return false;
        }
        if (this.notFromVersion != null && this.notFromVersion.length() > 0) {
            ZapRelease zapRelease3 = new ZapRelease(this.notFromVersion);
            return zapReleaseComparitor.compare(zapRelease, zapRelease3) < 0;
        }
        return true;
    }

    public void setNotBeforeVersion(String string) {
        this.notBeforeVersion = string;
    }

    public void setNotFromVersion(String string) {
        this.notFromVersion = string;
    }

    public String getNotBeforeVersion() {
        return this.notBeforeVersion;
    }

    public String getNotFromVersion() {
        return this.notFromVersion;
    }

    public URL getInfo() {
        return this.info;
    }

    public void setInfo(URL uRL) {
        this.info = uRL;
    }

    public String getHash() {
        return this.hash;
    }

    public List<String> getIdsAddOnDependencies() {
        if (this.dependencies == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.dependencies.getAddOns().size());
        for (BaseZapAddOnXmlData.AddOnDep addOnDep : this.dependencies.getAddOns()) {
            arrayList.add(addOnDep.getId());
        }
        return arrayList;
    }

    public boolean dependsOn(AddOn addOn) {
        if (this.dependencies == null || this.dependencies.getAddOns().isEmpty()) {
            return false;
        }
        return AddOn.dependsOn(this.dependencies.getAddOns(), addOn);
    }

    public boolean dependsOn(Collection<AddOn> collection) {
        if (this.dependencies == null || this.dependencies.getAddOns().isEmpty()) {
            return false;
        }
        for (AddOn addOn : collection) {
            if (!this.dependsOn(addOn)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[id=").append(this.id);
        stringBuilder.append(", fileVersion=").append(this.fileVersion);
        if (this.version != null) {
            stringBuilder.append(", version=").append(this.version);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
        n = 31 * n + this.fileVersion;
        n = 31 * n + (this.version == null ? 0 : this.version.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AddOn addOn = (AddOn)object;
        if (this.id == null ? addOn.id != null : !this.id.equals(addOn.id)) {
            return false;
        }
        if (this.fileVersion != addOn.fileVersion) {
            return false;
        }
        return !(this.version == null ? addOn.version != null : !this.version.equals(addOn.version));
    }

    private static int getJavaVersion(String string) {
        return AddOn.toVersionInt(AddOn.toJavaVersionIntArray(string, 2));
    }

    private static int[] toJavaVersionIntArray(String string, int n) {
        if (string == null) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        String[] stringArray = StringUtils.split(string, "._- ");
        int[] nArray = new int[Math.min(n, stringArray.length)];
        int n2 = 0;
        for (int i = 0; i < stringArray.length && n2 < n; ++i) {
            String string2 = stringArray[i];
            if (string2.length() <= 0) continue;
            try {
                nArray[n2] = Integer.parseInt(string2);
                ++n2;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (nArray.length > n2) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            nArray = nArray2;
        }
        return nArray;
    }

    private static int toVersionInt(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = nArray.length;
        if (n2 >= 1) {
            n = nArray[0] * 100;
        }
        if (n2 >= 2) {
            n += nArray[1] * 10;
        }
        if (n2 >= 3) {
            n += nArray[2];
        }
        return n;
    }

    public static class ExtensionRunRequirements
    extends BaseRunRequirements {
        private final String classname;

        private ExtensionRunRequirements(AddOn addOn, String string) {
            super(addOn);
            this.classname = string;
        }

        public String getClassname() {
            return this.classname;
        }
    }

    public static class AddOnRunRequirements
    extends BaseRunRequirements {
        private List<ExtensionRunRequirements> addExtensionsRequirements;

        private AddOnRunRequirements(AddOn addOn) {
            super(addOn);
        }

        public List<ExtensionRunRequirements> getExtensionRequirements() {
            if (this.addExtensionsRequirements == null) {
                this.addExtensionsRequirements = Collections.emptyList();
            }
            return this.addExtensionsRequirements;
        }

        public boolean hasExtensionsWithRunningIssues() {
            for (ExtensionRunRequirements extensionRunRequirements : this.getExtensionRequirements()) {
                if (extensionRunRequirements.isRunnable()) continue;
                return true;
            }
            return false;
        }

        protected void addExtensionRequirements(ExtensionRunRequirements extensionRunRequirements) {
            if (this.addExtensionsRequirements == null) {
                this.addExtensionsRequirements = new ArrayList<ExtensionRunRequirements>(5);
            }
            this.addExtensionsRequirements.add(extensionRunRequirements);
        }
    }

    public static abstract class BaseRunRequirements {
        private final AddOn addOn;
        private final DirectedGraph<AddOn, DefaultEdge> dependencyTree;
        private Set<AddOn> dependencies;
        private DependencyIssue depIssue;
        private List<Object> issueDetails;
        private String minimumJavaVersion;
        private AddOn addOnMinimumJavaVersion;
        private boolean runnable;

        private BaseRunRequirements(AddOn addOn) {
            this.addOn = addOn;
            this.dependencyTree = new DefaultDirectedGraph(DefaultEdge.class);
            this.dependencyTree.addVertex((Object)addOn);
            this.runnable = true;
            this.issueDetails = Collections.emptyList();
        }

        public AddOn getAddOn() {
            return this.addOn;
        }

        public boolean hasDependencyIssue() {
            return this.depIssue != null;
        }

        public DependencyIssue getDependencyIssue() {
            return this.depIssue;
        }

        public List<Object> getDependencyIssueDetails() {
            return this.issueDetails;
        }

        public boolean isRunnable() {
            return this.runnable;
        }

        protected void setRunnable(boolean bl) {
            this.runnable = bl;
        }

        public Set<AddOn> getDependencies() {
            if (this.dependencies == null) {
                this.dependencies = new HashSet<AddOn>();
                TopologicalOrderIterator topologicalOrderIterator = new TopologicalOrderIterator(this.dependencyTree);
                while (topologicalOrderIterator.hasNext()) {
                    this.dependencies.add((AddOn)topologicalOrderIterator.next());
                }
                this.dependencies.remove(this.addOn);
            }
            return Collections.unmodifiableSet(this.dependencies);
        }

        protected void setIssue(DependencyIssue dependencyIssue, Object ... objectArray) {
            this.runnable = false;
            this.depIssue = dependencyIssue;
            this.issueDetails = objectArray != null ? Arrays.asList(objectArray) : Collections.emptyList();
        }

        protected boolean addDependency(AddOn addOn, AddOn addOn2) {
            if (addOn == null) {
                return true;
            }
            this.dependencyTree.addVertex((Object)addOn);
            this.dependencyTree.addVertex((Object)addOn2);
            this.dependencyTree.addEdge((Object)addOn, (Object)addOn2);
            CycleDetector cycleDetector = new CycleDetector(this.dependencyTree);
            boolean bl = cycleDetector.detectCycles();
            if (bl) {
                this.dependencies = cycleDetector.findCycles();
                return false;
            }
            return true;
        }

        public boolean isNewerJavaVersionRequired() {
            return this.minimumJavaVersion != null;
        }

        public String getMinimumJavaVersion() {
            return this.minimumJavaVersion;
        }

        public AddOn getAddOnMinimumJavaVersion() {
            return this.addOnMinimumJavaVersion;
        }

        protected void setMinimumJavaVersionIssue(AddOn addOn, String string) {
            this.setRunnable(false);
            if (this.minimumJavaVersion == null) {
                this.setMinimumJavaVersion(addOn, string);
            } else if (AddOn.getJavaVersion(string) > AddOn.getJavaVersion(this.minimumJavaVersion)) {
                this.setMinimumJavaVersion(addOn, string);
            }
        }

        private void setMinimumJavaVersion(AddOn addOn, String string) {
            this.addOnMinimumJavaVersion = addOn;
            this.minimumJavaVersion = string;
        }

        public static enum DependencyIssue {
            CYCLIC,
            OLDER_VERSION,
            MISSING,
            PACKAGE_VERSION_NOT_BEFORE,
            PACKAGE_VERSION_NOT_FROM,
            VERSION;

        }
    }

    public static enum InstallationStatus {
        AVAILABLE,
        NOT_INSTALLED,
        INSTALLED,
        DOWNLOADING,
        UNINSTALLATION_FAILED,
        SOFT_UNINSTALLATION_FAILED;

    }

    public static enum Status {
        unknown,
        example,
        alpha,
        beta,
        weekly,
        release;

    }
}

