/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JSlider;

public class PositiveValuesSlider
extends JSlider {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MINOR_TICK_SPACING = 1;
    private static final int DEFAULT_MAJOR_TICK_SPACING = 5;

    public PositiveValuesSlider(int n) {
        this(1, n);
    }

    public PositiveValuesSlider(int n, int n2) {
        super(new PositiveValuesBoundedRangeModel(n, n2));
        this.setMinorTickSpacing(1);
        this.setMajorTickSpacing(5);
        this.setPaintTicks(true);
        this.setPaintLabels(true);
        this.setSnapToTicks(true);
        this.setPaintTrack(true);
    }

    @Override
    public void setMajorTickSpacing(int n) {
        this.setLabelTable(null);
        super.setMajorTickSpacing(n);
    }

    @Override
    public void setModel(BoundedRangeModel boundedRangeModel) {
        if (!(boundedRangeModel instanceof PositiveValuesBoundedRangeModel)) {
            return;
        }
        super.setModel(boundedRangeModel);
    }

    private static class PositiveValuesBoundedRangeModel
    extends DefaultBoundedRangeModel {
        private static final long serialVersionUID = 1L;

        public PositiveValuesBoundedRangeModel(int n, int n2) {
            super(PositiveValuesBoundedRangeModel.getValueGreaterThanZero(n), 0, 0, n2);
        }

        @Override
        public void setMinimum(int n) {
        }

        @Override
        public void setValue(int n) {
            super.setValue(PositiveValuesBoundedRangeModel.getValueGreaterThanZero(n));
        }

        private static int getValueGreaterThanZero(int n) {
            return Math.max(n, 1);
        }
    }
}

