/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.NamedCharacter;
import org.apache.fop.fonts.SimpleSingleByteEncoding;
import org.apache.fop.fonts.SingleByteEncoding;
import org.apache.fop.fonts.truetype.OpenFont;
import org.apache.xmlgraphics.fonts.Glyphs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleByteFont
extends CustomFont {
    private static Log log = LogFactory.getLog(SingleByteFont.class);
    protected SingleByteEncoding mapping;
    private boolean useNativeEncoding;
    protected int[] width;
    private Rectangle[] boundingBoxes;
    private Map<Character, UnencodedCharacter> unencodedCharacters;
    private List<SimpleSingleByteEncoding> additionalEncodings;
    private Map<Character, Character> alternativeCodes;
    private OpenFont.PostScriptVersion ttPostScriptVersion;
    private int usedGlyphsCount;
    private LinkedHashMap<Integer, String> usedGlyphNames;
    private Map<Integer, Integer> usedGlyphs;
    private Map<Integer, Character> usedCharsIndex;

    public SingleByteFont(InternalResourceResolver resourceResolver) {
        super(resourceResolver);
        this.setEncoding("WinAnsiEncoding");
    }

    public SingleByteFont(InternalResourceResolver resourceResolver, EmbeddingMode embeddingMode) {
        this(resourceResolver);
        this.setEmbeddingMode(embeddingMode);
        if (embeddingMode != EmbeddingMode.FULL) {
            this.usedGlyphNames = new LinkedHashMap();
            this.usedGlyphs = new HashMap<Integer, Integer>();
            this.usedCharsIndex = new HashMap<Integer, Character>();
            this.usedGlyphs.put(0, 0);
            ++this.usedGlyphsCount;
        }
    }

    @Override
    public boolean isEmbeddable() {
        return this.getEmbedFileURI() != null || this.getEmbedResourceName() != null;
    }

    @Override
    public boolean isSubsetEmbedded() {
        return this.getEmbeddingMode() != EmbeddingMode.FULL;
    }

    @Override
    public String getEncodingName() {
        return this.mapping.getName();
    }

    public SingleByteEncoding getEncoding() {
        return this.mapping;
    }

    @Override
    public int getWidth(int i, int size) {
        if (i < 256) {
            int idx = i - this.getFirstChar();
            if (idx >= 0 && idx < this.width.length) {
                return size * this.width[idx];
            }
        } else if (this.additionalEncodings != null) {
            int encodingIndex = i / 256 - 1;
            SimpleSingleByteEncoding encoding = this.getAdditionalEncoding(encodingIndex);
            int codePoint = i % 256;
            NamedCharacter nc = encoding.getCharacterForIndex(codePoint);
            UnencodedCharacter uc = this.unencodedCharacters.get(Character.valueOf(nc.getSingleUnicodeValue()));
            return size * uc.getWidth();
        }
        return 0;
    }

    @Override
    public int[] getWidths() {
        int[] arr = new int[this.width.length];
        System.arraycopy(this.width, 0, arr, 0, this.width.length);
        return arr;
    }

    @Override
    public Rectangle getBoundingBox(int glyphIndex, int size) {
        Rectangle bbox = null;
        if (glyphIndex < 256) {
            int idx = glyphIndex - this.getFirstChar();
            if (idx >= 0 && idx < this.boundingBoxes.length) {
                bbox = this.boundingBoxes[idx];
            }
        } else if (this.additionalEncodings != null) {
            int encodingIndex = glyphIndex / 256 - 1;
            SimpleSingleByteEncoding encoding = this.getAdditionalEncoding(encodingIndex);
            int codePoint = glyphIndex % 256;
            NamedCharacter nc = encoding.getCharacterForIndex(codePoint);
            UnencodedCharacter uc = this.unencodedCharacters.get(Character.valueOf(nc.getSingleUnicodeValue()));
            bbox = uc.getBBox();
        }
        return bbox == null ? null : new Rectangle(bbox.x * size, bbox.y * size, bbox.width * size, bbox.height * size);
    }

    private char findAlternative(char c) {
        if (this.alternativeCodes == null) {
            this.alternativeCodes = new HashMap<Character, Character>();
        } else {
            Character alternative = this.alternativeCodes.get(Character.valueOf(c));
            if (alternative != null) {
                return alternative.charValue();
            }
        }
        String charName = Glyphs.charToGlyphName((char)c);
        String[] charNameAlternatives = Glyphs.getCharNameAlternativesFor((String)charName);
        if (charNameAlternatives != null && charNameAlternatives.length > 0) {
            for (int i = 0; i < charNameAlternatives.length; ++i) {
                char d;
                String s;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Checking alternative for char " + c + " (charname=" + charName + "): " + charNameAlternatives[i]));
                }
                if ((s = Glyphs.getUnicodeSequenceForGlyphName((String)charNameAlternatives[i])) == null || (d = this.lookupChar(s.charAt(0))) == '\u0000') continue;
                this.alternativeCodes.put(Character.valueOf(c), Character.valueOf(d));
                return d;
            }
        }
        return '\u0000';
    }

    private char lookupChar(char c) {
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        d = this.mapUnencodedChar(c);
        return d;
    }

    private boolean isSubset() {
        return this.getEmbeddingMode() == EmbeddingMode.SUBSET;
    }

    @Override
    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.lookupChar(c);
        if (d == '\u0000') {
            d = this.findAlternative(c);
            if (d != '\u0000') {
                return d;
            }
            this.warnMissingGlyph(c);
            return '#';
        }
        if (this.isEmbeddable() && this.isSubset()) {
            this.mapChar(d, c);
        }
        return d;
    }

    private int mapChar(int glyphIndex, char unicode) {
        Integer subsetCharSelector = this.usedGlyphs.get(glyphIndex);
        if (subsetCharSelector == null) {
            int selector = this.usedGlyphsCount++;
            this.usedGlyphs.put(glyphIndex, selector);
            this.usedCharsIndex.put(selector, Character.valueOf(unicode));
            return selector;
        }
        return subsetCharSelector;
    }

    private char getUnicode(int index) {
        Character mapValue = this.usedCharsIndex.get(index);
        if (mapValue != null) {
            return mapValue.charValue();
        }
        return '\uffff';
    }

    private char mapUnencodedChar(char ch) {
        UnencodedCharacter unencoded;
        if (this.unencodedCharacters != null && (unencoded = this.unencodedCharacters.get(Character.valueOf(ch))) != null) {
            if (this.additionalEncodings == null) {
                this.additionalEncodings = new ArrayList<SimpleSingleByteEncoding>();
            }
            SimpleSingleByteEncoding encoding = null;
            int mappedStart = 0;
            int additionalsCount = this.additionalEncodings.size();
            for (int i = 0; i < additionalsCount; ++i) {
                mappedStart = (char)(mappedStart + 256);
                encoding = this.getAdditionalEncoding(i);
                char alt = encoding.mapChar(ch);
                if (alt == '\u0000') continue;
                return (char)(mappedStart + alt);
            }
            if (encoding != null && encoding.isFull()) {
                encoding = null;
            }
            if (encoding == null) {
                encoding = new SimpleSingleByteEncoding(this.getFontName() + "EncodingSupp" + (additionalsCount + 1));
                this.additionalEncodings.add(encoding);
                mappedStart = (char)(mappedStart + 256);
            }
            return (char)(mappedStart + encoding.addCharacter(unencoded.getCharacter()));
        }
        return '\u0000';
    }

    @Override
    public boolean hasChar(char c) {
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return true;
        }
        d = this.mapUnencodedChar(c);
        if (d != '\u0000') {
            return true;
        }
        d = this.findAlternative(c);
        return d != '\u0000';
    }

    protected void updateMapping(String encoding) {
        try {
            this.mapping = CodePointMapping.getMapping(encoding);
        }
        catch (UnsupportedOperationException e) {
            log.error((Object)("Font '" + super.getFontName() + "': " + e.getMessage()));
        }
    }

    public void setEncoding(String encoding) {
        this.updateMapping(encoding);
    }

    public void setEncoding(CodePointMapping encoding) {
        this.mapping = encoding;
    }

    public void setUseNativeEncoding(boolean value) {
        this.useNativeEncoding = value;
    }

    public boolean isUsingNativeEncoding() {
        return this.useNativeEncoding;
    }

    public void setWidth(int index, int w) {
        if (this.width == null) {
            this.width = new int[this.getLastChar() - this.getFirstChar() + 1];
        }
        this.width[index - this.getFirstChar()] = w;
    }

    public void setBoundingBox(int index, Rectangle bbox) {
        if (this.boundingBoxes == null) {
            this.boundingBoxes = new Rectangle[this.getLastChar() - this.getFirstChar() + 1];
        }
        this.boundingBoxes[index - this.getFirstChar()] = bbox;
    }

    public void addUnencodedCharacter(NamedCharacter ch, int width, Rectangle bbox) {
        if (this.unencodedCharacters == null) {
            this.unencodedCharacters = new HashMap<Character, UnencodedCharacter>();
        }
        if (ch.hasSingleUnicodeValue()) {
            UnencodedCharacter uc = new UnencodedCharacter(ch, width, bbox);
            this.unencodedCharacters.put(Character.valueOf(ch.getSingleUnicodeValue()), uc);
        }
    }

    public void encodeAllUnencodedCharacters() {
        if (this.unencodedCharacters != null) {
            TreeSet<Character> sortedKeys = new TreeSet<Character>(this.unencodedCharacters.keySet());
            for (Character ch : sortedKeys) {
                char mapped = this.mapChar(ch.charValue());
                assert (mapped != '#');
            }
        }
    }

    public boolean hasAdditionalEncodings() {
        return this.additionalEncodings != null && this.additionalEncodings.size() > 0;
    }

    public int getAdditionalEncodingCount() {
        if (this.hasAdditionalEncodings()) {
            return this.additionalEncodings.size();
        }
        return 0;
    }

    public SimpleSingleByteEncoding getAdditionalEncoding(int index) throws IndexOutOfBoundsException {
        if (this.hasAdditionalEncodings()) {
            return this.additionalEncodings.get(index);
        }
        throw new IndexOutOfBoundsException("No additional encodings available");
    }

    public int[] getAdditionalWidths(int index) {
        SimpleSingleByteEncoding enc = this.getAdditionalEncoding(index);
        int[] arr = new int[enc.getLastChar() - enc.getFirstChar() + 1];
        int c = arr.length;
        for (int i = 0; i < c; ++i) {
            NamedCharacter nc = enc.getCharacterForIndex(enc.getFirstChar() + i);
            UnencodedCharacter uc = this.unencodedCharacters.get(Character.valueOf(nc.getSingleUnicodeValue()));
            arr[i] = uc.getWidth();
        }
        return arr;
    }

    public void setTrueTypePostScriptVersion(OpenFont.PostScriptVersion version) {
        this.ttPostScriptVersion = version;
    }

    public OpenFont.PostScriptVersion getTrueTypePostScriptVersion() {
        assert (this.getFontType() == FontType.TRUETYPE);
        return this.ttPostScriptVersion;
    }

    public Map<Integer, Integer> getUsedGlyphs() {
        return Collections.unmodifiableMap(this.usedGlyphs);
    }

    public char getUnicodeFromSelector(int selector) {
        return this.getUnicode(selector);
    }

    public void mapUsedGlyphName(int gid, String value) {
        this.usedGlyphNames.put(gid, value);
    }

    public Map<Integer, String> getUsedGlyphNames() {
        return this.usedGlyphNames;
    }

    public String getGlyphName(int idx) {
        if (idx < this.mapping.getCharNameMap().length) {
            return this.mapping.getCharNameMap()[idx];
        }
        int selector = this.usedGlyphs.get(idx);
        char theChar = this.usedCharsIndex.get(selector).charValue();
        return this.unencodedCharacters.get(Character.valueOf(theChar)).getCharacter().getName();
    }

    private static final class UnencodedCharacter {
        private final NamedCharacter character;
        private final int width;
        private final Rectangle bbox;

        public UnencodedCharacter(NamedCharacter character, int width, Rectangle bbox) {
            this.character = character;
            this.width = width;
            this.bbox = bbox;
        }

        public NamedCharacter getCharacter() {
            return this.character;
        }

        public int getWidth() {
            return this.width;
        }

        public Rectangle getBBox() {
            return this.bbox;
        }

        public String toString() {
            return this.getCharacter().toString();
        }
    }
}

