/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.CachedObjectAccessNode;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignObjectAccessHeadNode;
import com.oracle.truffle.api.interop.GenericObjectAccessNode;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.ObjectAccessNode;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.NodeUtil;

final class UnresolvedObjectAccessNode
extends ObjectAccessNode {
    private static final int CACHE_SIZE = 8;
    private int cacheLength = 1;

    UnresolvedObjectAccessNode() {
    }

    @Override
    public Object executeWith(VirtualFrame frame, TruffleObject receiver, Object[] arguments) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        ForeignObjectAccessHeadNode nthParent = (ForeignObjectAccessHeadNode)NodeUtil.getNthParent(this, this.cacheLength);
        ObjectAccessNode first = nthParent.getFirst();
        if (this.cacheLength < 8) {
            CachedObjectAccessNode createCachedAccess = UnresolvedObjectAccessNode.createCachedAccess(receiver, nthParent.getAccessTree(), first);
            ++this.cacheLength;
            return first.replace(createCachedAccess).executeWith(frame, receiver, arguments);
        }
        return first.replace(UnresolvedObjectAccessNode.createGenericAccess(nthParent.getAccessTree())).executeWith(frame, receiver, arguments);
    }

    private static CachedObjectAccessNode createCachedAccess(TruffleObject receiver, Message accessTree, ObjectAccessNode next) {
        ForeignAccess fa = receiver.getForeignAccess();
        CallTarget ct = fa.access(accessTree);
        if (ct == null) {
            throw new IllegalArgumentException("Message " + accessTree + " not recognized by " + fa);
        }
        return new CachedObjectAccessNode(Truffle.getRuntime().createDirectCallNode(ct), next, fa);
    }

    private static GenericObjectAccessNode createGenericAccess(Message access) {
        return new GenericObjectAccessNode(access);
    }
}

