/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.write;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.runtime.exceptions.RangeException;
import org.jruby.truffle.runtime.RubyContext;

@NodeChildren(value={@NodeChild(value="value", type=PackNode.class)})
public abstract class WriteUTF8CharacterNode
extends PackNode {
    public WriteUTF8CharacterNode(RubyContext context) {
        super(context);
    }

    @Specialization(guards={"value >= 0", "value <= 0x7f"})
    public Object writeSingleByte(VirtualFrame frame, long value) {
        this.writeByte(frame, (byte)value);
        return null;
    }

    @Specialization(guards={"value > 0x7f", "value <= 0x7ff"})
    public Object writeTwoBytes(VirtualFrame frame, long value) {
        this.writeBytes(frame, (byte)(value >>> 6 & 0xFFL | 0xC0L), (byte)(value & 0x3FL | 0x80L));
        return null;
    }

    @Specialization(guards={"value > 0x7ff", "value <= 0xffff"})
    public Object writeThreeBytes(VirtualFrame frame, long value) {
        this.writeBytes(frame, (byte)(value >>> 12 & 0xFFL | 0xE0L), (byte)(value >>> 6 & 0x3FL | 0x80L), (byte)(value & 0x3FL | 0x80L));
        return null;
    }

    @Specialization(guards={"value > 0xffff", "value <= 0x1fffff"})
    public Object writeFourBytes(VirtualFrame frame, long value) {
        this.writeBytes(frame, (byte)(value >>> 18 & 0xFFL | 0xF0L), (byte)(value >>> 12 & 0x3FL | 0x80L), (byte)(value >>> 6 & 0x3FL | 0x80L), (byte)(value & 0x3FL | 0x80L));
        return null;
    }

    @Specialization(guards={"value > 0x1fffff", "value <= 0x3ffffff"})
    public Object writeFiveBytes(VirtualFrame frame, long value) {
        this.writeBytes(frame, (byte)(value >>> 24 & 0xFFL | 0xF8L), (byte)(value >>> 18 & 0x3FL | 0x80L), (byte)(value >>> 12 & 0x3FL | 0x80L), (byte)(value >>> 6 & 0x3FL | 0x80L), (byte)(value & 0x3FL | 0x80L));
        return null;
    }

    @Specialization(guards={"value > 0x3ffffff", "value <= 0x7fffffff"})
    public Object writeSixBytes(VirtualFrame frame, long value) {
        this.writeBytes(frame, (byte)(value >>> 30 & 0xFFL | 0xFCL), (byte)(value >>> 24 & 0x3FL | 0x80L), (byte)(value >>> 18 & 0x3FL | 0x80L), (byte)(value >>> 12 & 0x3FL | 0x80L), (byte)(value >>> 6 & 0x3FL | 0x80L), (byte)(value & 0x3FL | 0x80L));
        return null;
    }

    @Specialization(guards={"value < 0"})
    public Object writeNegative(VirtualFrame frame, long value) {
        CompilerDirectives.transferToInterpreter();
        throw new RangeException("pack(U): value out of range");
    }

    @Specialization(guards={"value > 0x7fffffff"})
    public Object writeOutOfRange(VirtualFrame frame, long value) {
        CompilerDirectives.transferToInterpreter();
        throw new RangeException("pack(U): value out of range");
    }
}

