/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.List;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.interop.IndexLabelToRubyNode;
import org.jruby.truffle.nodes.interop.IndexLabelToRubyNodeGen;
import org.jruby.truffle.nodes.interop.InteropNodeFactory;
import org.jruby.truffle.nodes.methods.DeclarationContext;
import org.jruby.truffle.nodes.objects.ReadInstanceVariableNode;
import org.jruby.truffle.nodes.objects.WriteInstanceVariableNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.InternalMethod;

public abstract class InteropNode
extends RubyNode {
    public InteropNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public static InteropNode createRead(RubyContext context, SourceSection sourceSection) {
        return new UnresolvedInteropReadNode(context, sourceSection);
    }

    public static InteropNode createWrite(RubyContext context, SourceSection sourceSection) {
        return new UnresolvedInteropWriteNode(context, sourceSection);
    }

    public static InteropNode createExecuteAfterRead(RubyContext context, SourceSection sourceSection, int arity) {
        return new UnresolvedInteropExecuteAfterReadNode(context, sourceSection, arity);
    }

    public static InteropNode createIsExecutable(RubyContext context, SourceSection sourceSection) {
        return new InteropIsExecutable(context, sourceSection);
    }

    public static InteropNode createExecute(RubyContext context, SourceSection sourceSection) {
        return new InteropExecute(context, sourceSection);
    }

    public static InteropNode createIsBoxedPrimitive(RubyContext context, SourceSection sourceSection) {
        return new InteropIsBoxedPrimitive(context, sourceSection);
    }

    public static InteropNode createIsNull(RubyContext context, SourceSection sourceSection) {
        return new InteropIsNull(context, sourceSection);
    }

    public static InteropNode createHasSizePropertyFalse(RubyContext context, SourceSection sourceSection) {
        return new InteropHasSizePropertyFalse(context, sourceSection);
    }

    public static InteropNode createHasSizePropertyTrue(RubyContext context, SourceSection sourceSection) {
        return new InteropHasSizePropertyTrue(context, sourceSection);
    }

    public static RubyNode createGetSize(RubyContext context, SourceSection sourceSection) {
        return new InteropGetSizeProperty(context, sourceSection);
    }

    public static RubyNode createStringIsBoxed(RubyContext context, SourceSection sourceSection) {
        return new InteropStringIsBoxed(context, sourceSection);
    }

    public static RubyNode createStringRead(RubyContext context, SourceSection sourceSection) {
        return new UnresolvedInteropStringReadNode(context, sourceSection);
    }

    public static RubyNode createStringUnbox(RubyContext context, SourceSection sourceSection) {
        return new InteropStringUnboxNode(context, sourceSection);
    }

    private static class InteropArgumentsNode
    extends RubyNode {
        @Node.Children
        private final InteropArgumentNode[] arguments;

        public InteropArgumentsNode(RubyContext context, SourceSection sourceSection, int arity) {
            super(context, sourceSection);
            this.arguments = new InteropArgumentNode[arity];
            for (int i = 1; i < 1 + arity; ++i) {
                this.arguments[i - 1] = new InteropArgumentNode(context, sourceSection, i);
            }
        }

        public int getCount(VirtualFrame frame) {
            return this.arguments.length;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException();
        }

        @ExplodeLoop
        public void executeFillObjectArray(VirtualFrame frame, Object[] args) {
            for (int i = 0; i < this.arguments.length; ++i) {
                args[i] = this.arguments[i].execute(frame);
            }
        }
    }

    private static class InteropArgumentNode
    extends RubyNode {
        private final int index;

        public InteropArgumentNode(RubyContext context, SourceSection sourceSection, int index) {
            super(context, sourceSection);
            this.index = index;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return ForeignAccess.getArguments(frame).get(this.index);
        }
    }

    private static class ResolvedInteropExecuteAfterReadNode
    extends InteropNode {
        @Node.Child
        private DispatchHeadNode head;
        @Node.Child
        private InteropArgumentsNode arguments;
        private final String name;
        private final int labelIndex;
        private final int receiverIndex;

        public ResolvedInteropExecuteAfterReadNode(RubyContext context, SourceSection sourceSection, String name, int arity) {
            super(context, sourceSection);
            this.name = name;
            this.head = new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD);
            this.arguments = new InteropArgumentsNode(context, sourceSection, arity);
            this.labelIndex = 1;
            this.receiverIndex = 0;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (this.name.equals(frame.getArguments()[this.labelIndex])) {
                Object[] args = new Object[this.arguments.getCount(frame)];
                this.arguments.executeFillObjectArray(frame, args);
                return this.head.dispatch(frame, frame.getArguments()[this.receiverIndex], frame.getArguments()[this.labelIndex], null, args);
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Name changed");
        }
    }

    private static class UnresolvedInteropExecuteAfterReadNode
    extends InteropNode {
        private final int arity;
        private final int labelIndex;

        public UnresolvedInteropExecuteAfterReadNode(RubyContext context, SourceSection sourceSection, int arity) {
            super(context, sourceSection);
            this.arity = arity;
            this.labelIndex = 0;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (ForeignAccess.getArguments(frame).get(this.labelIndex) instanceof String) {
                return this.replace(new ResolvedInteropExecuteAfterReadNode(this.getContext(), this.getSourceSection(), (String)ForeignAccess.getArguments(frame).get(this.labelIndex), this.arity)).execute(frame);
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(ForeignAccess.getArguments(frame).get(0) + " not allowed as name");
        }
    }

    private static class ResolvedInteropWriteToSymbolNode
    extends InteropNode {
        @Node.Child
        private DispatchHeadNode head;
        private final DynamicObject name;
        private final DynamicObject accessName;
        private final int labelIndex;
        private final int valueIndex;

        public ResolvedInteropWriteToSymbolNode(RubyContext context, SourceSection sourceSection, DynamicObject name, int labelIndex, int valueIndex) {
            super(context, sourceSection);
            this.name = name;
            this.accessName = context.getSymbol(Layouts.SYMBOL.getString(name) + "=");
            this.head = new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD);
            this.labelIndex = labelIndex;
            this.valueIndex = valueIndex;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (this.name.equals(ForeignAccess.getArguments(frame).get(this.labelIndex))) {
                Object value = ForeignAccess.getArguments(frame).get(this.valueIndex);
                return this.head.dispatch(frame, ForeignAccess.getReceiver(frame), this.accessName, null, new Object[]{value});
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Name changed");
        }
    }

    private static class ResolvedInteropWriteNode
    extends InteropNode {
        @Node.Child
        private DispatchHeadNode head;
        private final String name;
        private final String accessName;
        private final int labelIndex;
        private final int valueIndex;

        public ResolvedInteropWriteNode(RubyContext context, SourceSection sourceSection, String name, int labelIndex, int valueIndex) {
            super(context, sourceSection);
            this.name = name;
            this.accessName = name + "=";
            this.head = new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD);
            this.labelIndex = labelIndex;
            this.valueIndex = valueIndex;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (this.name.equals(ForeignAccess.getArguments(frame).get(this.labelIndex))) {
                Object value = ForeignAccess.getArguments(frame).get(this.valueIndex);
                return this.head.dispatch(frame, ForeignAccess.getReceiver(frame), this.accessName, null, new Object[]{value});
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Name changed");
        }
    }

    private static class ResolvedInteropIndexedWriteNode
    extends RubyNode {
        private final String name;
        @Node.Child
        private DispatchHeadNode head;
        @Node.Child
        private IndexLabelToRubyNode toRubyIndex;
        private final int indexIndex;
        private final int valueIndex;

        public ResolvedInteropIndexedWriteNode(RubyContext context, SourceSection sourceSection, int indexIndex, int valueIndex) {
            super(context, sourceSection);
            this.name = "[]=";
            this.indexIndex = indexIndex;
            this.valueIndex = valueIndex;
            this.head = new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD);
            this.toRubyIndex = IndexLabelToRubyNodeGen.create(context, sourceSection, null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object index = this.toRubyIndex.executeWithTarget(frame, ForeignAccess.getArguments(frame).get(this.indexIndex));
            Object value = ForeignAccess.getArguments(frame).get(this.valueIndex);
            return this.head.dispatch(frame, ForeignAccess.getReceiver(frame), this.name, null, new Object[]{index, value});
        }
    }

    private static class UnresolvedInteropWriteNode
    extends InteropNode {
        private final int labelIndex;
        private final int valueIndex;

        public UnresolvedInteropWriteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.labelIndex = 0;
            this.valueIndex = 1;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object label = ForeignAccess.getArguments(frame).get(this.labelIndex);
            if (label instanceof String || RubyGuards.isRubySymbol(label) || label instanceof Integer) {
                String name;
                if (label instanceof String && (name = (String)label).startsWith("@")) {
                    return this.replace(new InteropInstanceVariableWriteNode(this.getContext(), this.getSourceSection(), name, this.labelIndex, this.valueIndex)).execute(frame);
                }
                DynamicObject receiver = (DynamicObject)ForeignAccess.getReceiver(frame);
                InternalMethod labelMethod = ModuleOperations.lookupMethod(this.getContext().getCoreLibrary().getMetaClass(receiver), label.toString());
                InternalMethod indexedSetter = ModuleOperations.lookupMethod(this.getContext().getCoreLibrary().getMetaClass(receiver), "[]=");
                if (labelMethod == null && indexedSetter != null) {
                    return this.replace(new ResolvedInteropIndexedWriteNode(this.getContext(), this.getSourceSection(), this.labelIndex, this.valueIndex)).execute(frame);
                }
                if (label instanceof String) {
                    return this.replace(new ResolvedInteropWriteNode(this.getContext(), this.getSourceSection(), (String)label, this.labelIndex, this.valueIndex)).execute(frame);
                }
                if (RubyGuards.isRubySymbol(label)) {
                    return this.replace(new ResolvedInteropWriteToSymbolNode(this.getContext(), this.getSourceSection(), (DynamicObject)label, this.labelIndex, this.valueIndex)).execute(frame);
                }
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(label + " not allowed as name");
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(label + " not allowed as name");
        }
    }

    private static class ResolvedInteropReadFromSymbolNode
    extends InteropNode {
        @Node.Child
        private DispatchHeadNode head;
        private final DynamicObject name;
        private final int labelIndex;

        public ResolvedInteropReadFromSymbolNode(RubyContext context, SourceSection sourceSection, DynamicObject name, int labelIndex) {
            super(context, sourceSection);
            this.name = name;
            this.head = new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD);
            this.labelIndex = labelIndex;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (this.name.equals(ForeignAccess.getArguments(frame).get(this.labelIndex))) {
                return this.head.dispatch(frame, ForeignAccess.getReceiver(frame), this.name, null, new Object[0]);
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Name changed");
        }
    }

    private static class ResolvedInteropReadNode
    extends InteropNode {
        @Node.Child
        private DispatchHeadNode head;
        private final String name;
        private final int labelIndex;

        public ResolvedInteropReadNode(RubyContext context, SourceSection sourceSection, String name, int labelIndex) {
            super(context, sourceSection);
            this.name = name;
            this.head = new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD);
            this.labelIndex = labelIndex;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (this.name.equals(ForeignAccess.getArguments(frame).get(this.labelIndex))) {
                return this.head.dispatch(frame, ForeignAccess.getReceiver(frame), this.name, null, new Object[0]);
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Name changed");
        }
    }

    private static class RubyInteropArgumentNode
    extends RubyNode {
        private final int index;

        public RubyInteropArgumentNode(RubyContext context, SourceSection sourceSection, int index) {
            super(context, sourceSection);
            this.index = index;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return ForeignAccess.getArguments(frame).get(this.index);
        }
    }

    private static class RubyInteropReceiverNode
    extends RubyNode {
        public RubyInteropReceiverNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return ForeignAccess.getReceiver(frame);
        }
    }

    private static class InteropInstanceVariableWriteNode
    extends RubyNode {
        @Node.Child
        private WriteInstanceVariableNode write;
        private final String name;
        private final int labelIndex;

        public InteropInstanceVariableWriteNode(RubyContext context, SourceSection sourceSection, String name, int labelIndex, int valueIndex) {
            super(context, sourceSection);
            this.name = name;
            this.labelIndex = labelIndex;
            this.write = new WriteInstanceVariableNode(context, sourceSection, name, new RubyInteropReceiverNode(context, sourceSection), new RubyInteropArgumentNode(context, sourceSection, valueIndex));
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (this.name.equals(ForeignAccess.getArguments(frame).get(this.labelIndex))) {
                return this.write.execute(frame);
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Not implemented");
        }
    }

    private static class InteropInstanceVariableReadNode
    extends InteropNode {
        @Node.Child
        private ReadInstanceVariableNode read;
        private final String name;
        private final int labelIndex;

        public InteropInstanceVariableReadNode(RubyContext context, SourceSection sourceSection, String name, int labelIndex) {
            super(context, sourceSection);
            this.name = name;
            this.read = new ReadInstanceVariableNode(context, sourceSection, name, new RubyInteropReceiverNode(context, sourceSection));
            this.labelIndex = labelIndex;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (this.name.equals(ForeignAccess.getArguments(frame).get(this.labelIndex))) {
                return this.read.execute(frame);
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Not implemented");
        }
    }

    private static class ResolvedInteropIndexedReadNode
    extends RubyNode {
        private final String name;
        @Node.Child
        private DispatchHeadNode head;
        @Node.Child
        private IndexLabelToRubyNode toRubyIndex;
        private final int indexIndex;

        public ResolvedInteropIndexedReadNode(RubyContext context, SourceSection sourceSection, int indexIndex) {
            super(context, sourceSection);
            this.name = "[]";
            this.indexIndex = indexIndex;
            this.head = new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD);
            this.toRubyIndex = IndexLabelToRubyNodeGen.create(context, sourceSection, null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object index = this.toRubyIndex.executeWithTarget(frame, ForeignAccess.getArguments(frame).get(this.indexIndex));
            return this.head.dispatch(frame, ForeignAccess.getReceiver(frame), this.name, null, new Object[]{index});
        }
    }

    static class InteropReadStringByteNode
    extends RubyNode {
        private final int labelIndex;

        public InteropReadStringByteNode(RubyContext context, SourceSection sourceSection, int labelIndex) {
            super(context, sourceSection);
            this.labelIndex = labelIndex;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            if (RubyGuards.isRubyString(ForeignAccess.getReceiver(frame))) {
                DynamicObject string = (DynamicObject)ForeignAccess.getReceiver(frame);
                int index = (Integer)ForeignAccess.getArguments(frame).get(this.labelIndex);
                if (index >= StringOperations.getByteList(string).length()) {
                    return 0;
                }
                return (byte)StringOperations.getByteList(string).get(index);
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException("Not implemented");
        }
    }

    private static class UnresolvedInteropStringReadNode
    extends InteropNode {
        private final int labelIndex;

        public UnresolvedInteropStringReadNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.labelIndex = 0;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object label = ForeignAccess.getArguments(frame).get(this.labelIndex);
            if (label instanceof String || RubyGuards.isRubySymbol(label) || label instanceof Integer) {
                String name;
                if (label instanceof String && (name = (String)label).startsWith("@")) {
                    return this.replace(new InteropInstanceVariableReadNode(this.getContext(), this.getSourceSection(), name, this.labelIndex)).execute(frame);
                }
                if (label instanceof Integer || label instanceof Long) {
                    return this.replace(new InteropReadStringByteNode(this.getContext(), this.getSourceSection(), this.labelIndex)).execute(frame);
                }
                if (label instanceof String) {
                    return this.replace(new ResolvedInteropReadNode(this.getContext(), this.getSourceSection(), (String)label, this.labelIndex)).execute(frame);
                }
                if (RubyGuards.isRubySymbol(label)) {
                    return this.replace(new ResolvedInteropReadFromSymbolNode(this.getContext(), this.getSourceSection(), (DynamicObject)label, this.labelIndex)).execute(frame);
                }
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(label + " not allowed as name");
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(label + " not allowed as name");
        }
    }

    private static class UnresolvedInteropReadNode
    extends InteropNode {
        private final int labelIndex;

        public UnresolvedInteropReadNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.labelIndex = 0;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object label = ForeignAccess.getArguments(frame).get(this.labelIndex);
            if (label instanceof String || RubyGuards.isRubySymbol(label) || label instanceof Integer) {
                String name;
                if (label instanceof String && (name = (String)label).startsWith("@")) {
                    return this.replace(new InteropInstanceVariableReadNode(this.getContext(), this.getSourceSection(), name, this.labelIndex)).execute(frame);
                }
                DynamicObject receiver = (DynamicObject)ForeignAccess.getReceiver(frame);
                InternalMethod labelMethod = ModuleOperations.lookupMethod(this.getContext().getCoreLibrary().getMetaClass(receiver), label.toString());
                InternalMethod indexedSetter = ModuleOperations.lookupMethod(this.getContext().getCoreLibrary().getMetaClass(receiver), "[]=");
                if (labelMethod == null && indexedSetter != null) {
                    return this.replace(new ResolvedInteropIndexedReadNode(this.getContext(), this.getSourceSection(), this.labelIndex)).execute(frame);
                }
                if (label instanceof String) {
                    return this.replace(new ResolvedInteropReadNode(this.getContext(), this.getSourceSection(), (String)label, this.labelIndex)).execute(frame);
                }
                if (RubyGuards.isRubySymbol(label)) {
                    return this.replace(new ResolvedInteropReadFromSymbolNode(this.getContext(), this.getSourceSection(), (DynamicObject)label, this.labelIndex)).execute(frame);
                }
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException(label + " not allowed as name");
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalStateException(label + " not allowed as name");
        }
    }

    private static class InteropStringUnboxNode
    extends RubyNode {
        public InteropStringUnboxNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return StringOperations.getByteList((DynamicObject)ForeignAccess.getReceiver(frame)).get(0);
        }
    }

    private static class InteropStringIsBoxed
    extends InteropNode {
        public InteropStringIsBoxed(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            TruffleObject o = ForeignAccess.getReceiver(frame);
            return RubyGuards.isRubyString(o) && StringOperations.getByteList((DynamicObject)o).length() == 1;
        }
    }

    private static class InteropGetSizeProperty
    extends InteropNode {
        @Node.Child
        private DispatchHeadNode head;

        public InteropGetSizeProperty(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.head = new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.head.dispatch(frame, ForeignAccess.getReceiver(frame), "size", null, new Object[0]);
        }
    }

    private static class InteropHasSizePropertyTrue
    extends InteropNode {
        public InteropHasSizePropertyTrue(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return true;
        }
    }

    private static class InteropHasSizePropertyFalse
    extends InteropNode {
        public InteropHasSizePropertyFalse(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return false;
        }
    }

    private static class InteropIsNull
    extends InteropNode {
        public InteropIsNull(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return ForeignAccess.getReceiver(frame) == this.nil();
        }
    }

    private static class InteropIsBoxedPrimitive
    extends InteropNode {
        public InteropIsBoxedPrimitive(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return false;
        }
    }

    private static class InteropIsExecutable
    extends InteropNode {
        public InteropIsExecutable(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            TruffleObject receiver = ForeignAccess.getReceiver(frame);
            return RubyGuards.isRubyMethod(receiver) || RubyGuards.isRubyProc(receiver);
        }
    }

    @NodeChild(value="method", type=InteropNode.class)
    protected static abstract class ExecuteMethodNode
    extends AbstractExecuteMethodNode {
        @Node.Child
        private IndirectCallNode callNode = Truffle.getRuntime().createIndirectCallNode();

        public ExecuteMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyProc(proc)", "proc == cachedProc"})
        protected Object doCallProc(VirtualFrame frame, DynamicObject proc, @Cached(value="proc") DynamicObject cachedProc, @Cached(value="create(getCallTarget(cachedProc))") DirectCallNode callNode) {
            List<Object> faArgs = ForeignAccess.getArguments(frame);
            Object[] args = faArgs.toArray();
            return callNode.call(frame, RubyArguments.pack(Layouts.PROC.getDeclarationFrame(cachedProc), null, Layouts.PROC.getMethod(cachedProc), DeclarationContext.METHOD, null, Layouts.PROC.getSelf(cachedProc), null, args));
        }

        @Specialization(guards={"isRubyProc(proc)"})
        protected Object doCallProc(VirtualFrame frame, DynamicObject proc) {
            List<Object> faArgs = ForeignAccess.getArguments(frame);
            Object[] args = faArgs.toArray();
            return this.callNode.call(frame, Layouts.PROC.getCallTargetForType(proc), RubyArguments.pack(Layouts.PROC.getDeclarationFrame(proc), null, Layouts.PROC.getMethod(proc), DeclarationContext.METHOD, null, Layouts.PROC.getSelf(proc), null, args));
        }

        @Specialization(guards={"isRubyMethod(method)", "method == cachedMethod"})
        protected Object doCall(VirtualFrame frame, DynamicObject method, @Cached(value="method") DynamicObject cachedMethod, @Cached(value="getMethod(cachedMethod)") InternalMethod internalMethod, @Cached(value="create(getMethod(cachedMethod).getCallTarget())") DirectCallNode callNode) {
            List<Object> faArgs = ForeignAccess.getArguments(frame);
            Object[] args = faArgs.subList(0, faArgs.size()).toArray();
            return callNode.call(frame, RubyArguments.pack(null, null, internalMethod, DeclarationContext.METHOD, null, Layouts.METHOD.getReceiver(cachedMethod), null, args));
        }

        @Specialization(guards={"isRubyMethod(method)"})
        protected Object doCall(VirtualFrame frame, DynamicObject method) {
            InternalMethod internalMethod = Layouts.METHOD.getMethod(method);
            List<Object> faArgs = ForeignAccess.getArguments(frame);
            Object[] args = faArgs.subList(0, faArgs.size()).toArray();
            return this.callNode.call(frame, internalMethod.getCallTarget(), RubyArguments.pack(null, null, internalMethod, DeclarationContext.METHOD, null, Layouts.METHOD.getReceiver(method), null, args));
        }

        protected InternalMethod getMethodFromProc(DynamicObject proc) {
            return Layouts.PROC.getMethod(proc);
        }

        protected CallTarget getCallTarget(DynamicObject proc) {
            return Layouts.PROC.getCallTargetForType(proc);
        }

        protected InternalMethod getMethod(DynamicObject method) {
            return Layouts.METHOD.getMethod(method);
        }
    }

    protected static abstract class AbstractExecuteMethodNode
    extends InteropNode {
        public AbstractExecuteMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2);
    }

    private static class InteropExecute
    extends InteropNode {
        @Node.Child
        private ExecuteMethodNode execute;

        public InteropExecute(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.execute = InteropNodeFactory.ExecuteMethodNodeGen.create(context, sourceSection, null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object result = this.execute.executeWithTarget(frame, ForeignAccess.getReceiver(frame));
            return result;
        }
    }
}

