/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.locals;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.nodes.Node;

public abstract class ReadFrameSlotNode
extends Node {
    protected final FrameSlot frameSlot;

    public ReadFrameSlotNode(FrameSlot slot) {
        assert (slot != null);
        this.frameSlot = slot;
    }

    public abstract Object executeRead(Frame var1);

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    public boolean readBoolean(Frame frame) throws FrameSlotTypeException {
        return frame.getBoolean(this.frameSlot);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    public int readInteger(Frame frame) throws FrameSlotTypeException {
        return frame.getInt(this.frameSlot);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    public long readLong(Frame frame) throws FrameSlotTypeException {
        return frame.getLong(this.frameSlot);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    public double readDouble(Frame frame) throws FrameSlotTypeException {
        return frame.getDouble(this.frameSlot);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    public Object readObject(Frame frame) throws FrameSlotTypeException {
        return frame.getObject(this.frameSlot);
    }

    @Specialization
    public Object doValue(Frame frame) {
        return frame.getValue(this.frameSlot);
    }

    public final FrameSlot getFrameSlot() {
        return this.frameSlot;
    }
}

