/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.community;

import java.io.IOException;
import java.net.URL;
import javafx.fxml.FXMLLoader;
import javafx.scene.Group;
import javafx.scene.image.Image;
import javax.inject.Inject;
import org.pdfsam.Pdfsam;
import org.pdfsam.community.PdfsamCommunity;
import org.pdfsam.configuration.UIConfig;
import org.pdfsam.module.PdfsamModule;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;

@Configuration
@Profile(value={"COMMUNITY"})
@ComponentScan(basePackages={"org.pdfsam"}, includeFilters={@ComponentScan.Filter(value={PdfsamModule.class})})
public class PdfsamCommunityConfig
implements UIConfig {
    @Inject
    private Environment env;

    @Override
    @Bean(name={"logo"})
    public Group logo() throws IOException {
        ClassPathResource resource = new ClassPathResource("/fxml/LogoCommunity.fxml");
        return (Group)FXMLLoader.load((URL)resource.getURL());
    }

    @Bean(name={"logo16"})
    public Image logo16() throws IOException {
        return new Image(new ClassPathResource("/images/community/16x16.png").getInputStream());
    }

    @Bean(name={"logo24"})
    public Image logo24() throws IOException {
        return new Image(new ClassPathResource("/images/community/24x24.png").getInputStream());
    }

    @Bean(name={"logo32"})
    public Image logo32() throws IOException {
        return new Image(new ClassPathResource("/images/community/32x32.png").getInputStream());
    }

    @Bean(name={"logo48"})
    public Image logo48() throws IOException {
        return new Image(new ClassPathResource("/images/community/48x48.png").getInputStream());
    }

    @Bean(name={"logo64"})
    public Image logo64() throws IOException {
        return new Image(new ClassPathResource("/images/community/64x64.png").getInputStream());
    }

    @Bean(name={"logo96"})
    public Image logo96() throws IOException {
        return new Image(new ClassPathResource("/images/community/96x96.png").getInputStream());
    }

    @Bean(name={"logo128"})
    public Image logo128() throws IOException {
        return new Image(new ClassPathResource("/images/community/128x128.png").getInputStream());
    }

    @Bean(name={"logo256"})
    public Image logo256() throws IOException {
        return new Image(new ClassPathResource("/images/community/256x256.png").getInputStream());
    }

    @Bean(name={"logo512"})
    public Image logo512() throws IOException {
        return new Image(new ClassPathResource("/images/community/512x512.png").getInputStream());
    }

    @Override
    @Bean
    public Pdfsam pdfsam() {
        return new PdfsamCommunity("PDF Split and Merge Basic Edition", "PDFsam Basic", this.env);
    }
}

