/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.preference;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javax.inject.Inject;
import org.pdfsam.context.BooleanUserPreference;
import org.pdfsam.context.IntUserPreference;
import org.pdfsam.context.StringUserPreference;
import org.pdfsam.context.UserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.Module;
import org.pdfsam.module.ModuleKeyValueItem;
import org.pdfsam.support.KeyStringValueItem;
import org.pdfsam.support.LocaleKeyValueItem;
import org.pdfsam.support.io.FileType;
import org.pdfsam.support.validation.Validators;
import org.pdfsam.ui.Theme;
import org.pdfsam.ui.dashboard.preference.PreferenceBrowsableDirectoryField;
import org.pdfsam.ui.dashboard.preference.PreferenceBrowsableFileField;
import org.pdfsam.ui.dashboard.preference.PreferenceCheckBox;
import org.pdfsam.ui.dashboard.preference.PreferenceComboBox;
import org.pdfsam.ui.dashboard.preference.PreferenceIntTextField;
import org.pdfsam.ui.dashboard.preference.PreferenceRadioButton;
import org.pdfsam.ui.help.HelpUtils;
import org.pdfsam.ui.io.RememberingLatestFileChooserWrapper;
import org.pdfsam.ui.log.MaxLogRowsChangedEvent;
import org.pdfsam.ui.support.FXValidationSupport;
import org.pdfsam.ui.support.Style;
import org.sejda.eventstudio.StaticStudio;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PreferenceConfig {
    @Inject
    private UserContext userContext;

    @Bean(name={"localeCombo"})
    public PreferenceComboBox<LocaleKeyValueItem> localeCombo() {
        return new PreferenceComboBox<LocaleKeyValueItem>(StringUserPreference.LOCALE, this.userContext);
    }

    @Bean(name={"themeCombo"})
    public PreferenceComboBox<KeyStringValueItem<String>> themeCombo() {
        PreferenceComboBox<KeyStringValueItem<String>> themeCombo = new PreferenceComboBox<KeyStringValueItem<String>>(StringUserPreference.THEME, this.userContext);
        themeCombo.setId("themeCombo");
        themeCombo.getItems().addAll((Collection)Arrays.stream(Theme.values()).map(t -> KeyStringValueItem.keyValue(t.toString(), t.friendlyName())).collect(Collectors.toList()));
        themeCombo.setValue(KeyStringValueItem.keyEmptyValue(this.userContext.getTheme()));
        return themeCombo;
    }

    @Bean(name={"startupModuleCombo"})
    public PreferenceComboBox<KeyStringValueItem<String>> startupModuleCombo(List<Module> modules) {
        PreferenceComboBox<KeyStringValueItem<String>> startupModuleCombo = new PreferenceComboBox<KeyStringValueItem<String>>(StringUserPreference.STARTUP_MODULE, this.userContext);
        startupModuleCombo.setId("startupModuleCombo");
        startupModuleCombo.getItems().add(KeyStringValueItem.keyValue("", DefaultI18nContext.getInstance().i18n("Dashboard")));
        modules.stream().map(ModuleKeyValueItem::new).forEach(arg_0 -> startupModuleCombo.getItems().add(arg_0));
        startupModuleCombo.setValue(KeyStringValueItem.keyEmptyValue(this.userContext.getStartupModule()));
        return startupModuleCombo;
    }

    public PreferenceComboBox<KeyStringValueItem<String>> thumbnailsCombo() {
        return new PreferenceComboBox<KeyStringValueItem<String>>(StringUserPreference.THUMBNAILS_IDENTIFIER, this.userContext);
    }

    @Bean(name={"checkForUpdates"})
    public PreferenceCheckBox checkForUpdates() {
        PreferenceCheckBox checkForUpdates = new PreferenceCheckBox(BooleanUserPreference.CHECK_UPDATES, DefaultI18nContext.getInstance().i18n("Check for updates at startup"), this.userContext.isCheckForUpdates(), this.userContext);
        checkForUpdates.setId("checkForUpdates");
        checkForUpdates.setGraphic((Node)HelpUtils.helpIcon(DefaultI18nContext.getInstance().i18n("Set whether new version availability should be checked on startup (restart needed)")));
        checkForUpdates.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        checkForUpdates.getStyleClass().add((Object)"spaced-vitem");
        return checkForUpdates;
    }

    @Bean(name={"playSounds"})
    public PreferenceCheckBox playSounds() {
        PreferenceCheckBox playSounds = new PreferenceCheckBox(BooleanUserPreference.PLAY_SOUNDS, DefaultI18nContext.getInstance().i18n("Play alert sounds"), this.userContext.isPlaySounds(), this.userContext);
        playSounds.setId("playSounds");
        playSounds.setGraphic((Node)HelpUtils.helpIcon(DefaultI18nContext.getInstance().i18n("Turn on or off alert sounds")));
        playSounds.getStyleClass().addAll((Object[])Style.WITH_HELP.css());
        playSounds.getStyleClass().add((Object)"spaced-vitem");
        return playSounds;
    }

    public PreferenceCheckBox highQualityThumbnails() {
        PreferenceCheckBox highQualityThumbnails = new PreferenceCheckBox(BooleanUserPreference.HIGH_QUALITY_THUMB, DefaultI18nContext.getInstance().i18n("High quality thumbnails"), this.userContext.isHighQualityThumbnails(), this.userContext);
        highQualityThumbnails.setId("highQualityThumbnails");
        return highQualityThumbnails;
    }

    @Bean(name={"smartRadio"})
    public PreferenceRadioButton smartRadio() {
        PreferenceRadioButton smartRadio = new PreferenceRadioButton(BooleanUserPreference.SMART_OUTPUT, DefaultI18nContext.getInstance().i18n("Use the selected PDF document directory as output directory"), this.userContext.isUseSmartOutput(), this.userContext);
        smartRadio.setId("smartRadio");
        return smartRadio;
    }

    @Bean(name={"workingDirectory"})
    public PreferenceBrowsableDirectoryField workingDirectory() {
        PreferenceBrowsableDirectoryField workingDirectory = new PreferenceBrowsableDirectoryField(StringUserPreference.WORKING_PATH, this.userContext);
        workingDirectory.getTextField().setText(this.userContext.getDefaultWorkingPath());
        workingDirectory.setId("workingDirectory");
        return workingDirectory;
    }

    @Bean(name={"workspace"})
    public PreferenceBrowsableFileField workspace() {
        PreferenceBrowsableFileField workspace = new PreferenceBrowsableFileField(StringUserPreference.WORKSPACE_PATH, FileType.JSON, RememberingLatestFileChooserWrapper.OpenType.OPEN, this.userContext);
        workspace.getTextField().setText(this.userContext.getDefaultWorkspacePath());
        workspace.setId("workspace");
        return workspace;
    }

    @Bean(name={"logViewRowsNumber"})
    public PreferenceIntTextField logViewRowsNumber() {
        PreferenceIntTextField logRowsNumber = new PreferenceIntTextField(IntUserPreference.LOGVIEW_ROWS_NUMBER, this.userContext, Validators.positiveInteger());
        logRowsNumber.setText(Integer.toString(this.userContext.getNumberOfLogRows()));
        logRowsNumber.setErrorMessage(DefaultI18nContext.getInstance().i18n("Maximum number of rows mast be a positive number"));
        logRowsNumber.setId("logViewRowsNumber");
        logRowsNumber.validProperty().addListener((o, oldVal, newVal) -> {
            if (newVal == FXValidationSupport.ValidationState.VALID) {
                StaticStudio.eventStudio().broadcast(new MaxLogRowsChangedEvent());
            }
        });
        return logRowsNumber;
    }
}

