/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.io;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.ui.commons.ValidableTextField;
import org.pdfsam.ui.support.FXValidationSupport;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.workspace.RestorableView;

abstract class BrowsableField
extends HBox
implements RestorableView {
    private static final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"selected");
    private Button browseButton;
    private ValidableTextField textField = new ValidableTextField();
    private HBox validableContainer;
    private String browseWindowTitle = DefaultI18nContext.getInstance().i18n("Select");

    public BrowsableField() {
        HBox.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
        this.getStyleClass().add((Object)"browsable-field");
        this.validableContainer = new HBox(new Node[]{this.textField});
        this.validableContainer.getStyleClass().add((Object)"validable-container");
        this.textField.getStyleClass().add((Object)"validable-container-field");
        this.browseButton = new Button(DefaultI18nContext.getInstance().i18n("Browse"));
        this.browseButton.getStyleClass().addAll((Object[])Style.BROWSE_BUTTON.css());
        this.browseButton.prefHeightProperty().bind((ObservableValue)this.validableContainer.heightProperty());
        this.browseButton.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.browseButton.setMinHeight(Double.NEGATIVE_INFINITY);
        HBox.setHgrow((Node)this.validableContainer, (Priority)Priority.ALWAYS);
        this.textField.validProperty().addListener((o, oldValue, newValue) -> {
            if (newValue == FXValidationSupport.ValidationState.INVALID) {
                this.validableContainer.getStyleClass().addAll((Object[])Style.INVALID.css());
            } else {
                this.validableContainer.getStyleClass().removeAll((Object[])Style.INVALID.css());
            }
        });
        this.textField.focusedProperty().addListener((o, oldVal, newVal) -> this.validableContainer.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, newVal.booleanValue()));
        this.getChildren().addAll((Object[])new Node[]{this.validableContainer, this.browseButton});
    }

    public ValidableTextField getTextField() {
        return this.textField;
    }

    @Override
    public void saveStateTo(Map<String, String> data) {
        data.put(StringUtils.defaultString(this.getId()) + "browsableField", StringUtils.defaultString(this.textField.getText()));
    }

    @Override
    public void restoreStateFrom(Map<String, String> data) {
        this.textField.setText(Optional.ofNullable(data.get(StringUtils.defaultString(this.getId()) + "browsableField")).orElse(""));
    }

    public final void setGraphic(Node value) {
        this.validableContainer.getChildren().clear();
        if (value != null) {
            this.validableContainer.getChildren().add((Object)value);
        }
        this.validableContainer.getChildren().add((Object)this.textField);
    }

    Button getBrowseButton() {
        return this.browseButton;
    }

    String getBrowseWindowTitle() {
        return this.browseWindowTitle;
    }

    public void setBrowseWindowTitle(String browseWindowTitle) {
        this.browseWindowTitle = browseWindowTitle;
    }

    abstract void setTextFromFile(File var1);
}

