/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.notification;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.ConfigurableProperty;
import org.pdfsam.Pdfsam;
import org.pdfsam.PdfsamEdition;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.UsageService;
import org.pdfsam.ui.commons.UrlButton;
import org.pdfsam.ui.notification.AddNotificationRequestEvent;
import org.pdfsam.ui.notification.NotificationType;
import org.pdfsam.ui.notification.NotificationsContainer;
import org.pdfsam.ui.notification.RemoveNotificationRequestEvent;
import org.pdfsam.update.UpdateAvailableEvent;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.model.exception.InvalidTaskParametersException;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;

@Named
public class NotificationsController {
    private static final int TIMES_BEFORE_ENTERPRISE_NOTICE = 5;
    private NotificationsContainer container;
    private UsageService service;
    private Pdfsam pdfsam;

    @Inject
    NotificationsController(NotificationsContainer container, UsageService service, Pdfsam pdfsam) {
        this.container = container;
        this.service = service;
        this.pdfsam = pdfsam;
        StaticStudio.eventStudio().addAnnotatedListeners(this);
    }

    @EventListener
    public void onAddRequest(AddNotificationRequestEvent event) {
        this.container.addNotification(event.getTitle(), (Node)this.buildLabel(event.getMessage(), event.getType()));
    }

    private Label buildLabel(String message, NotificationType type) {
        Label textLabel = new Label(message);
        textLabel.getStyleClass().add((Object)"notification-text");
        if (type != null) {
            textLabel.getStyleClass().add((Object)type.getStyleClass());
            textLabel.setGraphic(type.getGraphic());
        }
        return textLabel;
    }

    @EventListener
    public void onTaskFailed(TaskExecutionFailedEvent e) {
        if (e.getFailingCause() instanceof InvalidTaskParametersException) {
            this.container.addNotification(DefaultI18nContext.getInstance().i18n("Invalid parameters"), (Node)this.buildLabel(DefaultI18nContext.getInstance().i18n("Input parameters are invalid, open the application messages for details."), NotificationType.ERROR));
        }
    }

    @EventListener
    public void onTaskCompleted(TaskExecutionCompletedEvent e) {
        long usages = this.service.getTotalUsage();
        if (PdfsamEdition.COMMUNITY == this.pdfsam.edition() && usages % 5L == 0L) {
            VBox content = new VBox(3.0, new Node[]{this.buildLabel(DefaultI18nContext.getInstance().i18n("You performed {0} tasks with PDFsam, did it help?", Long.toString(usages)), NotificationType.GO_PRO), UrlButton.styledUrlButton(DefaultI18nContext.getInstance().i18n("Give something back"), this.pdfsam.property(ConfigurableProperty.DONATE_URL), null)});
            content.setAlignment(Pos.TOP_RIGHT);
            this.container.addStickyNotification(DefaultI18nContext.getInstance().i18n("PDFsam worked hard!"), (Node)content);
        }
    }

    @EventListener
    public void onRemoveRequest(RemoveNotificationRequestEvent event) {
        this.container.removeNotification(event.getNotificationId());
    }

    @EventListener
    public void onUpdateAvailable(UpdateAvailableEvent event) {
        VBox content = new VBox(3.0, new Node[]{this.buildLabel(DefaultI18nContext.getInstance().i18n("PDFsam {0} is available for download", event.getAvailableVersion()), NotificationType.INFO), UrlButton.styledUrlButton(DefaultI18nContext.getInstance().i18n("Download"), this.pdfsam.property(ConfigurableProperty.DOWNLOAD_URL), null)});
        content.setAlignment(Pos.TOP_RIGHT);
        this.container.addStickyNotification(DefaultI18nContext.getInstance().i18n("New version available"), (Node)content);
    }
}

