/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.sejda.common.LookupTable;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.interactive.action.PDAction;
import org.sejda.sambox.pdmodel.interactive.action.PDActionGoTo;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Annotations {
    private static final Logger LOG = LoggerFactory.getLogger(Annotations.class);

    private Annotations() {
    }

    public static LookupTable<PDAnnotation> processAnnotations(LookupTable<PDPage> relevantPages, PDDocument pagesOwner) {
        RequireUtils.requireNotNullArg(pagesOwner, "Cannot process annotations for a null document");
        LOG.debug("Filtering annotations");
        LookupTable<PDAnnotation> annotationsLookup = new LookupTable<PDAnnotation>();
        for (PDPage page : relevantPages.keys()) {
            try {
                ArrayList<PDAnnotation> keptAnnotations = new ArrayList<PDAnnotation>();
                for (PDAnnotation annotation : page.getAnnotations()) {
                    PDAnnotation copyAnnotation;
                    if (annotation instanceof PDAnnotationLink) {
                        PDDestination destination = Annotations.getDestinationFrom((PDAnnotationLink)annotation, pagesOwner);
                        if (destination instanceof PDPageDestination) {
                            PDPage destPage = relevantPages.lookup(((PDPageDestination)destination).getPage());
                            if (Objects.nonNull(destPage)) {
                                PDAnnotationLink copyAnnotation2 = new PDAnnotationLink(annotation.getCOSObject().duplicate());
                                copyAnnotation2.getCOSObject().removeItem(COSName.A);
                                PDPageDestination newDestination = (PDPageDestination)PDDestination.create(destination.getCOSObject());
                                newDestination.setPage(destPage);
                                copyAnnotation2.setDestination(newDestination);
                                annotationsLookup.addLookupEntry(annotation, copyAnnotation2);
                                keptAnnotations.add(copyAnnotation2);
                                continue;
                            }
                            LOG.trace("Removing not relevant link annotation");
                            continue;
                        }
                        copyAnnotation = new PDAnnotationLink(annotation.getCOSObject().duplicate());
                        annotationsLookup.addLookupEntry(annotation, copyAnnotation);
                        keptAnnotations.add(copyAnnotation);
                        continue;
                    }
                    PDPage p = annotation.getPage();
                    if (p == null == relevantPages.hasLookupFor(p)) continue;
                    copyAnnotation = PDAnnotation.createAnnotation(annotation.getCOSObject().duplicate());
                    copyAnnotation.setPage(relevantPages.lookup(page));
                    annotationsLookup.addLookupEntry(annotation, copyAnnotation);
                    keptAnnotations.add(copyAnnotation);
                    LOG.trace("Updated annotation page reference with the looked up page");
                }
                relevantPages.lookup(page).setAnnotations(keptAnnotations);
            }
            catch (IOException e) {
                LOG.warn("Failed to process annotations for page", e);
            }
        }
        return annotationsLookup;
    }

    private static PDDestination getDestinationFrom(PDAnnotationLink link, PDDocument pageOwner) throws IOException {
        try {
            PDAction action;
            PDDestination destination = link.getDestination();
            if (destination == null && (action = link.getAction()) instanceof PDActionGoTo) {
                destination = ((PDActionGoTo)action).getDestination();
            }
            if (destination instanceof PDNamedDestination) {
                destination = pageOwner.getDocumentCatalog().findNamedDestinationPage((PDNamedDestination)destination);
            }
            return destination;
        }
        catch (Exception e) {
            LOG.warn("Failed to get destination for annotation", e);
            return null;
        }
    }
}

