/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sejda.core.Sejda;
import org.sejda.impl.sambox.component.PDDocumentAccessPermission;
import org.sejda.impl.sambox.util.PageLabelUtils;
import org.sejda.impl.sambox.util.ViewerPreferencesUtils;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.pdf.PdfVersion;
import org.sejda.model.pdf.label.PdfPageLabel;
import org.sejda.model.pdf.viewerpreference.PdfPageLayout;
import org.sejda.model.pdf.viewerpreference.PdfPageMode;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.output.WriteOption;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDDocumentInformation;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageTree;
import org.sejda.sambox.pdmodel.PageLayout;
import org.sejda.sambox.pdmodel.PageMode;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;
import org.sejda.sambox.rendering.ImageType;
import org.sejda.sambox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDDocumentHandler
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PDDocumentHandler.class);
    private static final WriteOption[] COMPRESSED_OPTS = new WriteOption[]{WriteOption.COMPRESS_STREAMS, WriteOption.OBJECT_STREAMS, WriteOption.XREF_STREAM};
    private PDDocument document;
    private PDDocumentAccessPermission permissions;
    private Set<WriteOption> writeOptions = new HashSet<WriteOption>();

    public PDDocumentHandler(PDDocument document) {
        if (document == null) {
            throw new IllegalArgumentException("PDDocument cannot be null.");
        }
        this.document = document;
        this.permissions = new PDDocumentAccessPermission(document);
    }

    public PDDocumentHandler() {
        this.document = new PDDocument();
        this.permissions = new PDDocumentAccessPermission(this.document);
    }

    public void setCreatorOnPDDocument() {
        this.document.getDocumentInformation().setCreator(Sejda.CREATOR);
    }

    public void setDocumentInformation(PDDocumentInformation info) {
        this.document.setDocumentInformation(info);
    }

    public PDDocumentAccessPermission getPermissions() {
        return this.permissions;
    }

    public void setPageLayoutOnDocument(PdfPageLayout layout) {
        this.setPageLayout(ViewerPreferencesUtils.getPageLayout(layout));
        LOG.trace("Page layout set to '{}'", (Object)layout);
    }

    public void setPageModeOnDocument(PdfPageMode mode) {
        this.setPageMode(ViewerPreferencesUtils.getPageMode(mode));
        LOG.trace("Page mode set to '{}'", (Object)mode);
    }

    public void setPageLabelsOnDocument(Map<Integer, PdfPageLabel> labels) {
        this.document.getDocumentCatalog().setPageLabels(PageLabelUtils.getLabels(labels, this.getNumberOfPages()));
        LOG.trace("Page labels set");
    }

    public void setVersionOnPDDocument(PdfVersion version) {
        if (version != null) {
            this.document.setVersion(version.getVersionAsDoubleString());
            LOG.trace("Version set to '{}'", (Object)version);
        }
    }

    public void addWriteOption(WriteOption ... opts) {
        for (WriteOption opt : opts) {
            this.writeOptions.add(opt);
        }
    }

    public void removeWriteOption(WriteOption ... opts) {
        for (WriteOption opt : opts) {
            this.writeOptions.remove((Object)opt);
        }
    }

    public void setCompress(boolean compress) {
        if (compress) {
            this.addWriteOption(COMPRESSED_OPTS);
        } else {
            this.removeWriteOption(COMPRESSED_OPTS);
        }
    }

    public PDViewerPreferences getViewerPreferences() {
        PDViewerPreferences retVal = this.document.getDocumentCatalog().getViewerPreferences();
        if (retVal == null) {
            retVal = new PDViewerPreferences(new COSDictionary());
        }
        return retVal;
    }

    public void setViewerPreferences(PDViewerPreferences preferences) {
        this.document.getDocumentCatalog().setViewerPreferences(preferences);
    }

    @Override
    public void close() throws IOException {
        this.document.close();
    }

    public void savePDDocument(File file) throws TaskException {
        try {
            LOG.trace("Saving document to {}", (Object)file);
            this.document.writeTo(file, this.writeOptions.toArray(new WriteOption[this.writeOptions.size()]));
        }
        catch (IOException e) {
            throw new TaskIOException("Unable to save to temporary file.", e);
        }
    }

    public int getNumberOfPages() {
        return this.document.getNumberOfPages();
    }

    public PDDocument getUnderlyingPDDocument() {
        return this.document;
    }

    public PDPage importPage(PDPage page) {
        PDPage imported = new PDPage(page.getCOSObject().duplicate());
        imported.setCropBox(page.getCropBox());
        imported.setMediaBox(page.getMediaBox());
        imported.setResources(page.getResources());
        imported.setRotation(page.getRotation());
        return this.addPage(imported);
    }

    public PDPage addPage(PDPage page) {
        this.document.addPage(page);
        return page;
    }

    public void movePageToDocumentEnd(int oldPageNumber) {
        if (oldPageNumber == this.document.getNumberOfPages()) {
            return;
        }
        PDPage page = this.getPage(oldPageNumber);
        this.document.addPage(page);
        this.document.removePage(oldPageNumber - 1);
    }

    public PDPage getPage(int pageNumber) {
        return this.document.getPage(pageNumber - 1);
    }

    public PDPageTree getPages() {
        return this.document.getPages();
    }

    public void initialiseBasedOn(PDDocument other) {
        this.setDocumentInformation(other.getDocumentInformation());
        this.setViewerPreferences(other.getDocumentCatalog().getViewerPreferences());
        this.setPageLayout(other.getDocumentCatalog().getPageLayout());
        this.setPageMode(other.getDocumentCatalog().getPageMode());
        this.document.getDocumentCatalog().setLanguage(other.getDocumentCatalog().getLanguage());
        this.setCreatorOnPDDocument();
    }

    public BufferedImage renderImage(int pageNumber, int dpi) throws TaskException {
        try {
            PDFRenderer pdfRenderer = new PDFRenderer(this.document);
            return pdfRenderer.renderImageWithDPI(pageNumber - 1, dpi, ImageType.RGB);
        }
        catch (IOException ex) {
            LOG.error("Failed to render page " + pageNumber, ex);
            throw new TaskException("Failed to render page " + pageNumber, ex);
        }
    }

    public void setDocumentOutline(PDDocumentOutline outline) {
        this.document.getDocumentCatalog().setDocumentOutline(outline);
    }

    public void setDocumentAcroForm(PDAcroForm acroForm) {
        this.document.getDocumentCatalog().setAcroForm(acroForm);
    }

    private void setPageMode(PageMode pageMode) {
        this.document.getDocumentCatalog().setPageMode(pageMode);
    }

    private void setPageLayout(PageLayout pageLayout) {
        this.document.getDocumentCatalog().setPageLayout(pageLayout);
    }

    public void addBlankPageIfOdd(PDRectangle mediaBox) {
        if (this.document.getNumberOfPages() % 2 != 0) {
            this.addBlankPage(mediaBox);
        }
    }

    public void addBlankPage(PDRectangle mediaBox) {
        LOG.debug("Adding blank page");
        this.addPage(new PDPage(Optional.ofNullable(mediaBox).orElse(PDRectangle.LETTER)));
    }
}

