/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.Closeable;
import java.io.IOException;
import org.sejda.io.BufferedCountingChannelWriter;
import org.sejda.io.CountingWritableByteChannel;
import org.sejda.sambox.cos.IndirectCOSObjectReference;
import org.sejda.sambox.output.COSWriter;
import org.sejda.sambox.output.DefaultPDFWriter;
import org.sejda.sambox.output.IndirectReferencesAwareCOSWriter;
import org.sejda.sambox.output.PDFWriteContext;
import org.sejda.sambox.util.Charsets;
import org.sejda.util.IOUtils;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndirectObjectsWriter
implements Closeable {
    private static final byte[] OBJ = "obj".getBytes(Charsets.US_ASCII);
    private static final byte[] ENDOBJ = "endobj".getBytes(Charsets.US_ASCII);
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPDFWriter.class);
    private COSWriter writer;
    private PDFWriteContext context;

    IndirectObjectsWriter(CountingWritableByteChannel channel, PDFWriteContext context) {
        this(new BufferedCountingChannelWriter(channel), context);
    }

    IndirectObjectsWriter(BufferedCountingChannelWriter writer, PDFWriteContext context) {
        RequireUtils.requireNotNullArg(writer, "Writer cannot be null");
        RequireUtils.requireNotNullArg(context, "Write context cannot be null");
        this.writer = new IndirectReferencesAwareCOSWriter(writer, context);
        this.context = context;
    }

    PDFWriteContext context() {
        return this.context;
    }

    public void writeObjectIfNotWritten(IndirectCOSObjectReference object) throws IOException {
        if (!this.context.hasWritten(object.xrefEntry())) {
            this.writeObject(object);
        }
    }

    public void writeObject(IndirectCOSObjectReference object) throws IOException {
        this.doWriteObject(object);
        this.context.putWritten(object.xrefEntry());
        this.onWritten(object);
    }

    protected void onWritten(IndirectCOSObjectReference ref) {
        ref.releaseCOSObject();
        LOG.trace("Released " + ref);
    }

    private void doWriteObject(IndirectCOSObjectReference object) throws IOException {
        object.xrefEntry().setByteOffset(this.writer.writer().offset());
        this.writer.writer().write(Long.toString(object.xrefEntry().getObjectNumber()));
        this.writer.writer().write((byte)32);
        this.writer.writer().write(Integer.toString(object.xrefEntry().getGenerationNumber()));
        this.writer.writer().write((byte)32);
        this.writer.writer().write(OBJ);
        this.writer.writer().writeEOL();
        object.getCOSObject().accept(this.writer);
        this.writer.writer().writeEOL();
        this.writer.writer().write(ENDOBJ);
        this.writer.writer().writeEOL();
        LOG.trace("Written object " + object.xrefEntry());
    }

    COSWriter writer() {
        return this.writer;
    }

    public void writeEOL() throws IOException {
        this.writer.writer().writeEOL();
    }

    public void write(byte[] bytes) throws IOException {
        this.writer.writer().write(bytes);
    }

    public void write(String string) throws IOException {
        this.writer.writer().write(string);
    }

    public void write(byte b) throws IOException {
        this.writer.writer().write(b);
    }

    public long offset() {
        return this.writer.writer().offset();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.writer);
        this.context = null;
    }
}

