/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.annotation;

import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.interactive.action.PDAction;
import org.sejda.sambox.pdmodel.interactive.action.PDActionFactory;
import org.sejda.sambox.pdmodel.interactive.action.PDAnnotationAdditionalActions;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.sejda.sambox.pdmodel.interactive.annotation.PDBorderStyleDictionary;

public class PDAnnotationWidget
extends PDAnnotation {
    public PDAnnotationWidget() {
        this.getCOSObject().setName(COSName.SUBTYPE, COSName.WIDGET.getName());
    }

    public PDAnnotationWidget(COSDictionary field) {
        super(field);
        this.getCOSObject().setName(COSName.SUBTYPE, COSName.WIDGET.getName());
    }

    public String getHighlightingMode() {
        return this.getCOSObject().getNameAsString(COSName.H, "I");
    }

    public void setHighlightingMode(String highlightingMode) {
        if (!(highlightingMode == null || "N".equals(highlightingMode) || "I".equals(highlightingMode) || "O".equals(highlightingMode) || "P".equals(highlightingMode) || "T".equals(highlightingMode))) {
            throw new IllegalArgumentException("Valid values for highlighting mode are 'N', 'N', 'O', 'P' or 'T'");
        }
        this.getCOSObject().setName(COSName.H, highlightingMode);
    }

    public PDAppearanceCharacteristicsDictionary getAppearanceCharacteristics() {
        COSBase mk = this.getCOSObject().getDictionaryObject(COSName.MK);
        if (mk instanceof COSDictionary) {
            return new PDAppearanceCharacteristicsDictionary((COSDictionary)mk);
        }
        return null;
    }

    public void setAppearanceCharacteristics(PDAppearanceCharacteristicsDictionary appearanceCharacteristics) {
        this.getCOSObject().setItem(COSName.MK, (COSObjectable)appearanceCharacteristics);
    }

    public PDAction getAction() {
        return PDActionFactory.createAction((COSDictionary)this.getCOSObject().getDictionaryObject(COSName.A));
    }

    public void setAction(PDAction action) {
        this.getCOSObject().setItem(COSName.A, (COSObjectable)action);
    }

    public PDAnnotationAdditionalActions getActions() {
        COSDictionary aa = (COSDictionary)this.getCOSObject().getDictionaryObject("AA");
        if (aa != null) {
            return new PDAnnotationAdditionalActions(aa);
        }
        return null;
    }

    public void setActions(PDAnnotationAdditionalActions actions) {
        this.getCOSObject().setItem("AA", (COSObjectable)actions);
    }

    public void setBorderStyle(PDBorderStyleDictionary bs) {
        this.getCOSObject().setItem("BS", (COSObjectable)bs);
    }

    public PDBorderStyleDictionary getBorderStyle() {
        COSDictionary bs = (COSDictionary)this.getCOSObject().getItem(COSName.BS);
        if (bs != null) {
            return new PDBorderStyleDictionary(bs);
        }
        return null;
    }
}

