/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.basics.geom;

public class PointDouble {
    public final Double x;
    public final Double y;

    public PointDouble(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Double getX() {
        return this.x;
    }

    public Double getY() {
        return this.y;
    }

    public double distance(PointDouble o) {
        double distX = o.getX() - this.getX();
        double distY = o.getY() - this.getY();
        return Math.sqrt(distX * distX + distY * distY);
    }

    public PointDouble copy() {
        return new PointDouble(this.x, this.y);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.x == null ? 0 : this.x.hashCode());
        result = 31 * result + (this.y == null ? 0 : this.y.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PointDouble other = (PointDouble)obj;
        if (this.x == null ? other.x != null : !this.x.equals(other.x)) {
            return false;
        }
        return !(this.y == null ? other.y != null : !this.y.equals(other.y));
    }

    public String toString() {
        return "p(x=" + this.x + " y=" + this.y + ")";
    }
}

