/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.configure;

import java.io.File;
import org.gradle.model.Defaults;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeExecutableBinarySpec;
import org.gradle.nativeplatform.NativeExecutableFileSpec;
import org.gradle.nativeplatform.SharedLibraryBinarySpec;
import org.gradle.nativeplatform.StaticLibraryBinarySpec;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class NativeBinaryRules
extends RuleSource {
    @Defaults
    public static void assignTools(NativeBinarySpec nativeBinarySpec, NativeToolChainRegistryInternal toolChains, File buildDir) {
        NativeBinarySpecInternal nativeBinary = (NativeBinarySpecInternal)nativeBinarySpec;
        NativeBinaryRules.assignToolsToNativeBinary(nativeBinary, nativeBinarySpec, toolChains);
        NativeBinaryRules.assignToolsToNativeBinaryExtension(nativeBinary, buildDir);
    }

    private static void assignToolsToNativeBinary(NativeBinarySpecInternal nativeBinary, NativeBinarySpec nativeBinarySpec, NativeToolChainRegistryInternal toolChains) {
        NativeToolChainInternal toolChain = NativeBinaryRules.toolChainFor(nativeBinarySpec, toolChains);
        PlatformToolProvider toolProvider = toolChain.select((NativePlatformInternal)nativeBinarySpec.getTargetPlatform());
        nativeBinary.setToolChain(toolChain);
        nativeBinary.setPlatformToolProvider(toolProvider);
    }

    private static void assignToolsToNativeBinaryExtension(NativeBinarySpecInternal nativeBinary, File buildDir) {
        if (nativeBinary instanceof NativeExecutableBinarySpec) {
            NativeBinaryRules.assignToolsToNativeExecutableBinary(nativeBinary, buildDir);
        } else if (nativeBinary instanceof SharedLibraryBinarySpec) {
            NativeBinaryRules.assignToolsToSharedLibraryBinary(nativeBinary, buildDir);
        } else if (nativeBinary instanceof StaticLibraryBinarySpec) {
            NativeBinaryRules.assignToolsToStaticLibraryBinary(buildDir, nativeBinary);
        }
    }

    private static void assignToolsToNativeExecutableBinary(NativeBinarySpecInternal nativeBinary, File buildDir) {
        NativeExecutableBinarySpec nativeExecutable = (NativeExecutableBinarySpec)((Object)nativeBinary);
        NativeExecutableFileSpec executable = nativeExecutable.getExecutable();
        executable.setFile(NativeBinaryRules.executableFileFor(nativeBinary, buildDir));
        executable.setToolChain(nativeBinary.getToolChain());
        nativeExecutable.getInstallation().setDirectory(NativeBinaryRules.installationDirFor(nativeBinary, buildDir));
    }

    private static void assignToolsToSharedLibraryBinary(NativeBinarySpecInternal nativeBinary, File buildDir) {
        SharedLibraryBinarySpec sharedLibrary = (SharedLibraryBinarySpec)((Object)nativeBinary);
        sharedLibrary.setSharedLibraryFile(NativeBinaryRules.sharedLibraryFileFor(nativeBinary, buildDir));
        sharedLibrary.setSharedLibraryLinkFile(NativeBinaryRules.sharedLibraryLinkFileFor(nativeBinary, buildDir));
    }

    private static void assignToolsToStaticLibraryBinary(File buildDir, NativeBinarySpecInternal nativeBinary) {
        StaticLibraryBinarySpec staticLibrary = (StaticLibraryBinarySpec)((Object)nativeBinary);
        staticLibrary.setStaticLibraryFile(NativeBinaryRules.staticLibraryFileFor(nativeBinary, buildDir));
    }

    public static File executableFileFor(NativeBinarySpecInternal nativeBinary, File buildDir) {
        return new File(nativeBinary.getNamingScheme().getOutputDirectory(buildDir, "exe"), NativeBinaryRules.executableNameFor(nativeBinary));
    }

    private static File sharedLibraryLinkFileFor(NativeBinarySpecInternal nativeBinary, File buildDir) {
        return new File(nativeBinary.getNamingScheme().getOutputDirectory(buildDir, "libs"), NativeBinaryRules.sharedLibraryLinkFileNameFor(nativeBinary));
    }

    private static File sharedLibraryFileFor(NativeBinarySpecInternal nativeBinary, File buildDir) {
        return new File(nativeBinary.getNamingScheme().getOutputDirectory(buildDir, "libs"), NativeBinaryRules.sharedLibraryNameFor(nativeBinary));
    }

    private static File staticLibraryFileFor(NativeBinarySpecInternal nativeBinary, File buildDir) {
        return new File(nativeBinary.getNamingScheme().getOutputDirectory(buildDir, "libs"), NativeBinaryRules.staticLibraryNameFor(nativeBinary));
    }

    public static File installationDirFor(NativeBinarySpecInternal nativeBinary, File buildDir) {
        return nativeBinary.getNamingScheme().getOutputDirectory(buildDir, "install");
    }

    private static String executableNameFor(NativeBinarySpecInternal nativeBinary) {
        return nativeBinary.getPlatformToolProvider().getExecutableName(NativeBinaryRules.baseNameOf(nativeBinary));
    }

    private static String sharedLibraryLinkFileNameFor(NativeBinarySpecInternal nativeBinary) {
        return nativeBinary.getPlatformToolProvider().getSharedLibraryLinkFileName(NativeBinaryRules.baseNameOf(nativeBinary));
    }

    private static String sharedLibraryNameFor(NativeBinarySpecInternal nativeBinary) {
        return nativeBinary.getPlatformToolProvider().getSharedLibraryName(NativeBinaryRules.baseNameOf(nativeBinary));
    }

    private static String staticLibraryNameFor(NativeBinarySpecInternal nativeBinary) {
        return nativeBinary.getPlatformToolProvider().getStaticLibraryName(NativeBinaryRules.baseNameOf(nativeBinary));
    }

    private static String baseNameOf(NativeBinarySpecInternal nativeBinary) {
        return nativeBinary.getComponent().getBaseName();
    }

    private static NativeToolChainInternal toolChainFor(NativeBinarySpec nativeBinary, NativeToolChainRegistryInternal toolChains) {
        return (NativeToolChainInternal)toolChains.getForPlatform(nativeBinary.getTargetPlatform());
    }
}

