/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.report;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.tasks.testing.junit.report.ClassTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.TestResultModel;
import org.gradle.api.internal.tasks.testing.junit.result.TestFailure;
import org.gradle.api.tasks.testing.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResult
extends TestResultModel
implements Comparable<TestResult> {
    private final long duration;
    final ClassTestResults classResults;
    final List<TestFailure> failures = new ArrayList<TestFailure>();
    final String name;
    boolean ignored;

    public TestResult(String name, long duration, ClassTestResults classResults) {
        this.name = name;
        this.duration = duration;
        this.classResults = classResults;
    }

    public Object getId() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return String.format("Test %s", this.name);
    }

    @Override
    public TestResult.ResultType getResultType() {
        if (this.ignored) {
            return TestResult.ResultType.SKIPPED;
        }
        return this.failures.isEmpty() ? TestResult.ResultType.SUCCESS : TestResult.ResultType.FAILURE;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public String getFormattedDuration() {
        return this.ignored ? "-" : super.getFormattedDuration();
    }

    public ClassTestResults getClassResults() {
        return this.classResults;
    }

    public List<TestFailure> getFailures() {
        return this.failures;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void addFailure(TestFailure failure) {
        this.classResults.failed(this);
        this.failures.add(failure);
    }

    public void setIgnored() {
        this.classResults.ignored(this);
        this.ignored = true;
    }

    @Override
    public int compareTo(TestResult testResult) {
        int diff = this.classResults.getName().compareTo(testResult.classResults.getName());
        if (diff != 0) {
            return diff;
        }
        diff = this.name.compareTo(testResult.name);
        if (diff != 0) {
            return diff;
        }
        Integer thisIdentity = System.identityHashCode(this);
        int otherIdentity = System.identityHashCode(testResult);
        return thisIdentity.compareTo(otherIdentity);
    }
}

