/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import org.gradle.model.internal.inspect.MethodModelRuleExtractor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.RuleSourceValidationProblemCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationDrivenModelRuleExtractor<T extends Annotation>
implements MethodModelRuleExtractor {
    private final Class<T> annotationType;

    protected AbstractAnnotationDrivenModelRuleExtractor() {
        Class annotationType;
        this.annotationType = annotationType = new TypeToken<T>(this.getClass()){}.getRawType();
    }

    @Override
    public boolean isSatisfiedBy(MethodRuleDefinition<?, ?> ruleDefinition) {
        return ruleDefinition.getAnnotation(this.annotationType) != null;
    }

    @Override
    public String getDescription() {
        return String.format("annotated with @%s", this.annotationType.getSimpleName());
    }

    protected void validateIsVoidMethod(MethodRuleDefinition<?, ?> ruleDefinition, RuleSourceValidationProblemCollector problems) {
        if (!ruleDefinition.getReturnType().getRawClass().equals(Void.TYPE)) {
            problems.add(ruleDefinition, "A method " + this.getDescription() + " must have void return type.");
        }
    }
}

